// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Purview.Models
{
    /// <summary> The managed resources in customer subscription. </summary>
    public partial class PurviewManagedResource
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PurviewManagedResource"/>. </summary>
        internal PurviewManagedResource()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PurviewManagedResource"/>. </summary>
        /// <param name="eventHubNamespace"> Gets the managed event hub namespace resource identifier. </param>
        /// <param name="resourceGroup"> Gets the managed resource group resource identifier. This resource group will host resource dependencies for the account. </param>
        /// <param name="storageAccount"> Gets the managed storage account resource identifier. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PurviewManagedResource(ResourceIdentifier eventHubNamespace, ResourceIdentifier resourceGroup, ResourceIdentifier storageAccount, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EventHubNamespace = eventHubNamespace;
            ResourceGroup = resourceGroup;
            StorageAccount = storageAccount;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Gets the managed event hub namespace resource identifier. </summary>
        public ResourceIdentifier EventHubNamespace { get; }
        /// <summary> Gets the managed resource group resource identifier. This resource group will host resource dependencies for the account. </summary>
        public ResourceIdentifier ResourceGroup { get; }
        /// <summary> Gets the managed storage account resource identifier. </summary>
        public ResourceIdentifier StorageAccount { get; }
    }
}
