// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Purview.Models
{
    /// <summary> Gets or sets the state of managed eventhub. If enabled managed eventhub will be created, if disabled the managed eventhub will be removed. </summary>
    public readonly partial struct PurviewManagedEventHubState : IEquatable<PurviewManagedEventHubState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PurviewManagedEventHubState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PurviewManagedEventHubState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> NotSpecified. </summary>
        public static PurviewManagedEventHubState NotSpecified { get; } = new PurviewManagedEventHubState(NotSpecifiedValue);
        /// <summary> Disabled. </summary>
        public static PurviewManagedEventHubState Disabled { get; } = new PurviewManagedEventHubState(DisabledValue);
        /// <summary> Enabled. </summary>
        public static PurviewManagedEventHubState Enabled { get; } = new PurviewManagedEventHubState(EnabledValue);
        /// <summary> Determines if two <see cref="PurviewManagedEventHubState"/> values are the same. </summary>
        public static bool operator ==(PurviewManagedEventHubState left, PurviewManagedEventHubState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PurviewManagedEventHubState"/> values are not the same. </summary>
        public static bool operator !=(PurviewManagedEventHubState left, PurviewManagedEventHubState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PurviewManagedEventHubState"/>. </summary>
        public static implicit operator PurviewManagedEventHubState(string value) => new PurviewManagedEventHubState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PurviewManagedEventHubState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PurviewManagedEventHubState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
