// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Purview.Models
{
    /// <summary> The event streaming service type. </summary>
    public readonly partial struct PurviewEventStreamingType : IEquatable<PurviewEventStreamingType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PurviewEventStreamingType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PurviewEventStreamingType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string ManagedValue = "Managed";
        private const string AzureValue = "Azure";

        /// <summary> None. </summary>
        public static PurviewEventStreamingType None { get; } = new PurviewEventStreamingType(NoneValue);
        /// <summary> Managed. </summary>
        public static PurviewEventStreamingType Managed { get; } = new PurviewEventStreamingType(ManagedValue);
        /// <summary> Azure. </summary>
        public static PurviewEventStreamingType Azure { get; } = new PurviewEventStreamingType(AzureValue);
        /// <summary> Determines if two <see cref="PurviewEventStreamingType"/> values are the same. </summary>
        public static bool operator ==(PurviewEventStreamingType left, PurviewEventStreamingType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PurviewEventStreamingType"/> values are not the same. </summary>
        public static bool operator !=(PurviewEventStreamingType left, PurviewEventStreamingType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PurviewEventStreamingType"/>. </summary>
        public static implicit operator PurviewEventStreamingType(string value) => new PurviewEventStreamingType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PurviewEventStreamingType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PurviewEventStreamingType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
