// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Purview.Models
{
    /// <summary> Identity Type. </summary>
    public readonly partial struct PurviewCredentialsType : IEquatable<PurviewCredentialsType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PurviewCredentialsType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PurviewCredentialsType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string SystemAssignedValue = "SystemAssigned";
        private const string UserAssignedValue = "UserAssigned";

        /// <summary> None. </summary>
        public static PurviewCredentialsType None { get; } = new PurviewCredentialsType(NoneValue);
        /// <summary> SystemAssigned. </summary>
        public static PurviewCredentialsType SystemAssigned { get; } = new PurviewCredentialsType(SystemAssignedValue);
        /// <summary> UserAssigned. </summary>
        public static PurviewCredentialsType UserAssigned { get; } = new PurviewCredentialsType(UserAssignedValue);
        /// <summary> Determines if two <see cref="PurviewCredentialsType"/> values are the same. </summary>
        public static bool operator ==(PurviewCredentialsType left, PurviewCredentialsType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PurviewCredentialsType"/> values are not the same. </summary>
        public static bool operator !=(PurviewCredentialsType left, PurviewCredentialsType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PurviewCredentialsType"/>. </summary>
        public static implicit operator PurviewCredentialsType(string value) => new PurviewCredentialsType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PurviewCredentialsType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PurviewCredentialsType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
