// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Purview.Models
{
    /// <summary> Gets or sets the sku name. </summary>
    public readonly partial struct PurviewAccountSkuName : IEquatable<PurviewAccountSkuName>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PurviewAccountSkuName"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PurviewAccountSkuName(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string StandardValue = "Standard";
        private const string FreeValue = "Free";

        /// <summary> Standard. </summary>
        public static PurviewAccountSkuName Standard { get; } = new PurviewAccountSkuName(StandardValue);
        /// <summary> Free. </summary>
        public static PurviewAccountSkuName Free { get; } = new PurviewAccountSkuName(FreeValue);
        /// <summary> Determines if two <see cref="PurviewAccountSkuName"/> values are the same. </summary>
        public static bool operator ==(PurviewAccountSkuName left, PurviewAccountSkuName right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PurviewAccountSkuName"/> values are not the same. </summary>
        public static bool operator !=(PurviewAccountSkuName left, PurviewAccountSkuName right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PurviewAccountSkuName"/>. </summary>
        public static implicit operator PurviewAccountSkuName(string value) => new PurviewAccountSkuName(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PurviewAccountSkuName other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PurviewAccountSkuName other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
