// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Purview.Models
{
    /// <summary> The scope where the default account is set. </summary>
    public readonly partial struct PurviewAccountScopeType : IEquatable<PurviewAccountScopeType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PurviewAccountScopeType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PurviewAccountScopeType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string TenantValue = "Tenant";
        private const string SubscriptionValue = "Subscription";

        /// <summary> Tenant. </summary>
        public static PurviewAccountScopeType Tenant { get; } = new PurviewAccountScopeType(TenantValue);
        /// <summary> Subscription. </summary>
        public static PurviewAccountScopeType Subscription { get; } = new PurviewAccountScopeType(SubscriptionValue);
        /// <summary> Determines if two <see cref="PurviewAccountScopeType"/> values are the same. </summary>
        public static bool operator ==(PurviewAccountScopeType left, PurviewAccountScopeType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PurviewAccountScopeType"/> values are not the same. </summary>
        public static bool operator !=(PurviewAccountScopeType left, PurviewAccountScopeType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PurviewAccountScopeType"/>. </summary>
        public static implicit operator PurviewAccountScopeType(string value) => new PurviewAccountScopeType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PurviewAccountScopeType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PurviewAccountScopeType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
