// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Purview.Models
{
    /// <summary> Gets the account status code. </summary>
    public readonly partial struct PurviewAccountProvisioningState : IEquatable<PurviewAccountProvisioningState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PurviewAccountProvisioningState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PurviewAccountProvisioningState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string MovingValue = "Moving";
        private const string DeletingValue = "Deleting";
        private const string SoftDeletingValue = "SoftDeleting";
        private const string SoftDeletedValue = "SoftDeleted";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";

        /// <summary> Unknown. </summary>
        public static PurviewAccountProvisioningState Unknown { get; } = new PurviewAccountProvisioningState(UnknownValue);
        /// <summary> Creating. </summary>
        public static PurviewAccountProvisioningState Creating { get; } = new PurviewAccountProvisioningState(CreatingValue);
        /// <summary> Updating. </summary>
        public static PurviewAccountProvisioningState Updating { get; } = new PurviewAccountProvisioningState(UpdatingValue);
        /// <summary> Moving. </summary>
        public static PurviewAccountProvisioningState Moving { get; } = new PurviewAccountProvisioningState(MovingValue);
        /// <summary> Deleting. </summary>
        public static PurviewAccountProvisioningState Deleting { get; } = new PurviewAccountProvisioningState(DeletingValue);
        /// <summary> SoftDeleting. </summary>
        public static PurviewAccountProvisioningState SoftDeleting { get; } = new PurviewAccountProvisioningState(SoftDeletingValue);
        /// <summary> SoftDeleted. </summary>
        public static PurviewAccountProvisioningState SoftDeleted { get; } = new PurviewAccountProvisioningState(SoftDeletedValue);
        /// <summary> Failed. </summary>
        public static PurviewAccountProvisioningState Failed { get; } = new PurviewAccountProvisioningState(FailedValue);
        /// <summary> Succeeded. </summary>
        public static PurviewAccountProvisioningState Succeeded { get; } = new PurviewAccountProvisioningState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static PurviewAccountProvisioningState Canceled { get; } = new PurviewAccountProvisioningState(CanceledValue);
        /// <summary> Determines if two <see cref="PurviewAccountProvisioningState"/> values are the same. </summary>
        public static bool operator ==(PurviewAccountProvisioningState left, PurviewAccountProvisioningState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PurviewAccountProvisioningState"/> values are not the same. </summary>
        public static bool operator !=(PurviewAccountProvisioningState left, PurviewAccountProvisioningState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PurviewAccountProvisioningState"/>. </summary>
        public static implicit operator PurviewAccountProvisioningState(string value) => new PurviewAccountProvisioningState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PurviewAccountProvisioningState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PurviewAccountProvisioningState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
