// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Purview.Models
{
    /// <summary> The reason the name is not available. </summary>
    public readonly partial struct PurviewAccountNameUnavailableReason : IEquatable<PurviewAccountNameUnavailableReason>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="PurviewAccountNameUnavailableReason"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public PurviewAccountNameUnavailableReason(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InvalidValue = "Invalid";
        private const string AlreadyExistsValue = "AlreadyExists";

        /// <summary> Invalid. </summary>
        public static PurviewAccountNameUnavailableReason Invalid { get; } = new PurviewAccountNameUnavailableReason(InvalidValue);
        /// <summary> AlreadyExists. </summary>
        public static PurviewAccountNameUnavailableReason AlreadyExists { get; } = new PurviewAccountNameUnavailableReason(AlreadyExistsValue);
        /// <summary> Determines if two <see cref="PurviewAccountNameUnavailableReason"/> values are the same. </summary>
        public static bool operator ==(PurviewAccountNameUnavailableReason left, PurviewAccountNameUnavailableReason right) => left.Equals(right);
        /// <summary> Determines if two <see cref="PurviewAccountNameUnavailableReason"/> values are not the same. </summary>
        public static bool operator !=(PurviewAccountNameUnavailableReason left, PurviewAccountNameUnavailableReason right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="PurviewAccountNameUnavailableReason"/>. </summary>
        public static implicit operator PurviewAccountNameUnavailableReason(string value) => new PurviewAccountNameUnavailableReason(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is PurviewAccountNameUnavailableReason other && Equals(other);
        /// <inheritdoc />
        public bool Equals(PurviewAccountNameUnavailableReason other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
