// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Purview.Models
{
    /// <summary> Gets or sets the public network access for managed resources. </summary>
    public readonly partial struct ManagedResourcesPublicNetworkAccess : IEquatable<ManagedResourcesPublicNetworkAccess>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ManagedResourcesPublicNetworkAccess"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ManagedResourcesPublicNetworkAccess(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string EnabledValue = "Enabled";
        private const string DisabledValue = "Disabled";

        /// <summary> NotSpecified. </summary>
        public static ManagedResourcesPublicNetworkAccess NotSpecified { get; } = new ManagedResourcesPublicNetworkAccess(NotSpecifiedValue);
        /// <summary> Enabled. </summary>
        public static ManagedResourcesPublicNetworkAccess Enabled { get; } = new ManagedResourcesPublicNetworkAccess(EnabledValue);
        /// <summary> Disabled. </summary>
        public static ManagedResourcesPublicNetworkAccess Disabled { get; } = new ManagedResourcesPublicNetworkAccess(DisabledValue);
        /// <summary> Determines if two <see cref="ManagedResourcesPublicNetworkAccess"/> values are the same. </summary>
        public static bool operator ==(ManagedResourcesPublicNetworkAccess left, ManagedResourcesPublicNetworkAccess right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ManagedResourcesPublicNetworkAccess"/> values are not the same. </summary>
        public static bool operator !=(ManagedResourcesPublicNetworkAccess left, ManagedResourcesPublicNetworkAccess right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ManagedResourcesPublicNetworkAccess"/>. </summary>
        public static implicit operator ManagedResourcesPublicNetworkAccess(string value) => new ManagedResourcesPublicNetworkAccess(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ManagedResourcesPublicNetworkAccess other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ManagedResourcesPublicNetworkAccess other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
