// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Purview
{
    internal class PurviewPrivateEndpointConnectionOperationSource : IOperationSource<PurviewPrivateEndpointConnectionResource>
    {
        private readonly ArmClient _client;

        internal PurviewPrivateEndpointConnectionOperationSource(ArmClient client)
        {
            _client = client;
        }

        PurviewPrivateEndpointConnectionResource IOperationSource<PurviewPrivateEndpointConnectionResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PurviewPrivateEndpointConnectionData.DeserializePurviewPrivateEndpointConnectionData(document.RootElement);
            return new PurviewPrivateEndpointConnectionResource(_client, data);
        }

        async ValueTask<PurviewPrivateEndpointConnectionResource> IOperationSource<PurviewPrivateEndpointConnectionResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PurviewPrivateEndpointConnectionData.DeserializePurviewPrivateEndpointConnectionData(document.RootElement);
            return new PurviewPrivateEndpointConnectionResource(_client, data);
        }
    }
}
