// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System.Text.Json;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;

namespace Azure.ResourceManager.Purview
{
    internal class PurviewAccountOperationSource : IOperationSource<PurviewAccountResource>
    {
        private readonly ArmClient _client;

        internal PurviewAccountOperationSource(ArmClient client)
        {
            _client = client;
        }

        PurviewAccountResource IOperationSource<PurviewAccountResource>.CreateResult(Response response, CancellationToken cancellationToken)
        {
            using var document = JsonDocument.Parse(response.ContentStream);
            var data = PurviewAccountData.DeserializePurviewAccountData(document.RootElement);
            return new PurviewAccountResource(_client, data);
        }

        async ValueTask<PurviewAccountResource> IOperationSource<PurviewAccountResource>.CreateResultAsync(Response response, CancellationToken cancellationToken)
        {
            using var document = await JsonDocument.ParseAsync(response.ContentStream, default, cancellationToken).ConfigureAwait(false);
            var data = PurviewAccountData.DeserializePurviewAccountData(document.RootElement);
            return new PurviewAccountResource(_client, data);
        }
    }
}
