// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;
using Azure.ResourceManager.Purview.Models;

namespace Azure.ResourceManager.Purview.Mocking
{
    /// <summary> A class to add extension methods to TenantResource. </summary>
    public partial class MockablePurviewTenantResource : ArmResource
    {
        private ClientDiagnostics _defaultAccountsClientDiagnostics;
        private DefaultAccountsRestOperations _defaultAccountsRestClient;

        /// <summary> Initializes a new instance of the <see cref="MockablePurviewTenantResource"/> class for mocking. </summary>
        protected MockablePurviewTenantResource()
        {
        }

        /// <summary> Initializes a new instance of the <see cref="MockablePurviewTenantResource"/> class. </summary>
        /// <param name="client"> The client parameters to use in these operations. </param>
        /// <param name="id"> The identifier of the resource that is the target of operations. </param>
        internal MockablePurviewTenantResource(ArmClient client, ResourceIdentifier id) : base(client, id)
        {
        }

        private ClientDiagnostics DefaultAccountsClientDiagnostics => _defaultAccountsClientDiagnostics ??= new ClientDiagnostics("Azure.ResourceManager.Purview", ProviderConstants.DefaultProviderNamespace, Diagnostics);
        private DefaultAccountsRestOperations DefaultAccountsRestClient => _defaultAccountsRestClient ??= new DefaultAccountsRestOperations(Pipeline, Diagnostics.ApplicationId, Endpoint);

        private string GetApiVersionOrNull(ResourceType resourceType)
        {
            TryGetApiVersion(resourceType, out string apiVersion);
            return apiVersion;
        }

        /// <summary>
        /// Get the default account for the scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Purview/getDefaultAccount</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DefaultAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopeTenantId"> The tenant ID. </param>
        /// <param name="scopeType"> The scope for the default account. </param>
        /// <param name="scope"> The Id of the scope object, for example if the scope is "Subscription" then it is the ID of that subscription. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response<DefaultPurviewAccountPayload>> GetDefaultAccountAsync(Guid scopeTenantId, PurviewAccountScopeType scopeType, string scope = null, CancellationToken cancellationToken = default)
        {
            using var scope0 = DefaultAccountsClientDiagnostics.CreateScope("MockablePurviewTenantResource.GetDefaultAccount");
            scope0.Start();
            try
            {
                var response = await DefaultAccountsRestClient.GetAsync(scopeTenantId, scopeType, scope, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope0.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Get the default account for the scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Purview/getDefaultAccount</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DefaultAccounts_Get</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopeTenantId"> The tenant ID. </param>
        /// <param name="scopeType"> The scope for the default account. </param>
        /// <param name="scope"> The Id of the scope object, for example if the scope is "Subscription" then it is the ID of that subscription. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response<DefaultPurviewAccountPayload> GetDefaultAccount(Guid scopeTenantId, PurviewAccountScopeType scopeType, string scope = null, CancellationToken cancellationToken = default)
        {
            using var scope0 = DefaultAccountsClientDiagnostics.CreateScope("MockablePurviewTenantResource.GetDefaultAccount");
            scope0.Start();
            try
            {
                var response = DefaultAccountsRestClient.Get(scopeTenantId, scopeType, scope, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope0.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes the default account from the scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Purview/removeDefaultAccount</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DefaultAccounts_Remove</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopeTenantId"> The tenant ID. </param>
        /// <param name="scopeType"> The scope for the default account. </param>
        /// <param name="scope"> The Id of the scope object, for example if the scope is "Subscription" then it is the ID of that subscription. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual async Task<Response> RemoveDefaultAccountAsync(Guid scopeTenantId, PurviewAccountScopeType scopeType, string scope = null, CancellationToken cancellationToken = default)
        {
            using var scope0 = DefaultAccountsClientDiagnostics.CreateScope("MockablePurviewTenantResource.RemoveDefaultAccount");
            scope0.Start();
            try
            {
                var response = await DefaultAccountsRestClient.RemoveAsync(scopeTenantId, scopeType, scope, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope0.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Removes the default account from the scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Purview/removeDefaultAccount</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DefaultAccounts_Remove</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="scopeTenantId"> The tenant ID. </param>
        /// <param name="scopeType"> The scope for the default account. </param>
        /// <param name="scope"> The Id of the scope object, for example if the scope is "Subscription" then it is the ID of that subscription. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        public virtual Response RemoveDefaultAccount(Guid scopeTenantId, PurviewAccountScopeType scopeType, string scope = null, CancellationToken cancellationToken = default)
        {
            using var scope0 = DefaultAccountsClientDiagnostics.CreateScope("MockablePurviewTenantResource.RemoveDefaultAccount");
            scope0.Start();
            try
            {
                var response = DefaultAccountsRestClient.Remove(scopeTenantId, scopeType, scope, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope0.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Sets the default account for the scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Purview/setDefaultAccount</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DefaultAccounts_Set</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="defaultAccountPayload"> The payload containing the default account information and the scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="defaultAccountPayload"/> is null. </exception>
        public virtual async Task<Response<DefaultPurviewAccountPayload>> SetDefaultAccountAsync(DefaultPurviewAccountPayload defaultAccountPayload, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(defaultAccountPayload, nameof(defaultAccountPayload));

            using var scope = DefaultAccountsClientDiagnostics.CreateScope("MockablePurviewTenantResource.SetDefaultAccount");
            scope.Start();
            try
            {
                var response = await DefaultAccountsRestClient.SetAsync(defaultAccountPayload, cancellationToken).ConfigureAwait(false);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Sets the default account for the scope.
        /// <list type="bullet">
        /// <item>
        /// <term>Request Path</term>
        /// <description>/providers/Microsoft.Purview/setDefaultAccount</description>
        /// </item>
        /// <item>
        /// <term>Operation Id</term>
        /// <description>DefaultAccounts_Set</description>
        /// </item>
        /// <item>
        /// <term>Default Api Version</term>
        /// <description>2023-05-01-preview</description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="defaultAccountPayload"> The payload containing the default account information and the scope. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="defaultAccountPayload"/> is null. </exception>
        public virtual Response<DefaultPurviewAccountPayload> SetDefaultAccount(DefaultPurviewAccountPayload defaultAccountPayload, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNull(defaultAccountPayload, nameof(defaultAccountPayload));

            using var scope = DefaultAccountsClientDiagnostics.CreateScope("MockablePurviewTenantResource.SetDefaultAccount");
            scope.Start();
            try
            {
                var response = DefaultAccountsRestClient.Set(defaultAccountPayload, cancellationToken);
                return response;
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }
    }
}
