// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using Azure.ResourceManager.Purview.Models;

namespace Azure.ResourceManager.Purview.Samples
{
    public partial class Sample_TenantResourceExtensions
    {
        // DefaultAccounts_Get
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task GetDefaultAccount_DefaultAccountsGet()
        {
            // Generated from example definition: specification/purview/resource-manager/Microsoft.Purview/preview/2023-05-01-preview/examples/DefaultAccounts_Get.json
            // this example is just showing the usage of "DefaultAccounts_Get" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            Guid scopeTenantId = Guid.Parse("ee85a74c-405e-4adc-bb47-ffa8ca0c9f31");
            PurviewAccountScopeType scopeType = PurviewAccountScopeType.Tenant;
            string scope = "12345678-1234-1234-1234-12345678abcd";
            DefaultPurviewAccountPayload result = await tenantResource.GetDefaultAccountAsync(scopeTenantId, scopeType, scope: scope);

            Console.WriteLine($"Succeeded: {result}");
        }

        // DefaultAccounts_Remove
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task RemoveDefaultAccount_DefaultAccountsRemove()
        {
            // Generated from example definition: specification/purview/resource-manager/Microsoft.Purview/preview/2023-05-01-preview/examples/DefaultAccounts_Remove.json
            // this example is just showing the usage of "DefaultAccounts_Remove" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            Guid scopeTenantId = Guid.Parse("ee85a74c-405e-4adc-bb47-ffa8ca0c9f31");
            PurviewAccountScopeType scopeType = PurviewAccountScopeType.Tenant;
            string scope = "12345678-1234-1234-1234-12345678abcd";
            await tenantResource.RemoveDefaultAccountAsync(scopeTenantId, scopeType, scope: scope);

            Console.WriteLine($"Succeeded");
        }

        // DefaultAccounts_Set
        [NUnit.Framework.Test]
        [NUnit.Framework.Ignore("Only verifying that the sample builds")]
        public async Task SetDefaultAccount_DefaultAccountsSet()
        {
            // Generated from example definition: specification/purview/resource-manager/Microsoft.Purview/preview/2023-05-01-preview/examples/DefaultAccounts_Set.json
            // this example is just showing the usage of "DefaultAccounts_Set" operation, for the dependent resources, they will have to be created separately.

            // get your azure access token, for more details of how Azure SDK get your access token, please refer to https://learn.microsoft.com/en-us/dotnet/azure/sdk/authentication?tabs=command-line
            TokenCredential cred = new DefaultAzureCredential();
            // authenticate your client
            ArmClient client = new ArmClient(cred);

            // this example assumes you already have this TenantResource created on azure
            // for more information of creating TenantResource, please refer to the document of TenantResource
            var tenantResource = client.GetTenants().GetAllAsync().GetAsyncEnumerator().Current;

            // invoke the operation
            DefaultPurviewAccountPayload defaultAccountPayload = new DefaultPurviewAccountPayload()
            {
                AccountName = "myDefaultAccount",
                ResourceGroupName = "rg-1",
                Scope = "12345678-1234-1234-1234-12345678abcd",
                ScopeTenantId = Guid.Parse("12345678-1234-1234-1234-12345678abcd"),
                ScopeType = PurviewAccountScopeType.Tenant,
                SubscriptionId = "12345678-1234-1234-1234-12345678aaaa",
            };
            DefaultPurviewAccountPayload result = await tenantResource.SetDefaultAccountAsync(defaultAccountPayload);

            Console.WriteLine($"Succeeded: {result}");
        }
    }
}
