// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Workflows.Samples
{
    public partial class Samples_WorkflowsClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflows_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowsClient client = new WorkflowsClient(endpoint, credential);

            foreach (BinaryData item in client.GetWorkflows(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("isEnabled").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflows_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowsClient client = new WorkflowsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetWorkflowsAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("isEnabled").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflows_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowsClient client = new WorkflowsClient(endpoint, credential);

            foreach (BinaryData item in client.GetWorkflows(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
                Console.WriteLine(result.GetProperty("createdTime").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
                Console.WriteLine(result.GetProperty("updatedBy").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("isEnabled").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflows_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowsClient client = new WorkflowsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetWorkflowsAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
                Console.WriteLine(result.GetProperty("createdTime").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
                Console.WriteLine(result.GetProperty("updatedBy").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("isEnabled").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
            }
        }
    }
}
