// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Workflows.Samples
{
    public partial class Samples_WorkflowRunClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflowRun_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            Response response = client.GetWorkflowRun(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("runInput").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("actions").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflowRun_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            Response response = await client.GetWorkflowRunAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("runInput").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("actions").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflowRun_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            Response response = client.GetWorkflowRun(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("workflowId").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("userRequestId").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("targetValue").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("cancelTime").ToString());
            Console.WriteLine(result.GetProperty("cancelComment").ToString());
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("runInput").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("actions").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflowRun_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            Response response = await client.GetWorkflowRunAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("workflowId").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("userRequestId").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("targetValue").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("cancelTime").ToString());
            Console.WriteLine(result.GetProperty("cancelComment").ToString());
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("runInput").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("actions").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Cancel_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Cancel(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Cancel_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.CancelAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Cancel_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = client.Cancel(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Cancel_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = await client.CancelAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }
    }
}
