// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Workflows.Samples
{
    public partial class Samples_WorkflowClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflow_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = client.GetWorkflow(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflow_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = await client.GetWorkflowAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflow_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = client.GetWorkflow(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflow_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = await client.GetWorkflowAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrReplace_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
            });
            Response response = client.CreateOrReplace(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrReplace_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
            });
            Response response = await client.CreateOrReplaceAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrReplace_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
underGlossaryHierarchy = "<underGlossaryHierarchy>",
underCollection = "<underCollection>",
underGlossary = "<underGlossary>",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
                actionDag = new object(),
            });
            Response response = client.CreateOrReplace(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrReplace_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
underGlossaryHierarchy = "<underGlossaryHierarchy>",
underCollection = "<underCollection>",
underGlossary = "<underGlossary>",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
                actionDag = new object(),
            });
            Response response = await client.CreateOrReplaceAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Delete_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = client.Delete(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Delete_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = await client.DeleteAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Delete_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = client.Delete(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Delete_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = await client.DeleteAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Validate_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
            });
            Response response = client.Validate(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("severity").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("location").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("message").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Validate_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
            });
            Response response = await client.ValidateAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("severity").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("location").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("message").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Validate_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
underGlossaryHierarchy = "<underGlossaryHierarchy>",
underCollection = "<underCollection>",
underGlossary = "<underGlossary>",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
                actionDag = new object(),
            });
            Response response = client.Validate(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("severity").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("location").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("location").GetProperty("actionName").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("location").GetProperty("parameterKey").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("message").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Validate_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
underGlossaryHierarchy = "<underGlossaryHierarchy>",
underCollection = "<underCollection>",
underGlossary = "<underGlossary>",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
                actionDag = new object(),
            });
            Response response = await client.ValidateAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("severity").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("location").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("location").GetProperty("actionName").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("location").GetProperty("parameterKey").ToString());
            Console.WriteLine(result.GetProperty("value")[0].GetProperty("message").ToString());
        }
    }
}
