// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Workflows.Samples
{
    public partial class Samples_UserRequestsClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Submit_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            UserRequestsClient client = new UserRequestsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                operations = new object[]
            {
new
{
type = "CreateTerm",
payload = new object(),
}
            },
            });
            Response response = client.Submit(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("requestId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Submit_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            UserRequestsClient client = new UserRequestsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                operations = new object[]
            {
new
{
type = "CreateTerm",
payload = new object(),
}
            },
            });
            Response response = await client.SubmitAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("requestId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Submit_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            UserRequestsClient client = new UserRequestsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                operations = new object[]
            {
new
{
type = "CreateTerm",
payload = new object(),
}
            },
                comment = "<comment>",
            });
            Response response = client.Submit(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("requestId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("workflowRunIds")[0].ToString());
            Console.WriteLine(result.GetProperty("comment").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Submit_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            UserRequestsClient client = new UserRequestsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                operations = new object[]
            {
new
{
type = "CreateTerm",
payload = new object(),
}
            },
                comment = "<comment>",
            });
            Response response = await client.SubmitAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("requestId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("workflowRunIds")[0].ToString());
            Console.WriteLine(result.GetProperty("comment").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }
    }
}
