// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Workflows.Samples
{
    public partial class Samples_TaskStatusClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Update_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TaskStatusClient client = new TaskStatusClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                newStatus = "NotStarted",
            });
            Response response = client.Update(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Update_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TaskStatusClient client = new TaskStatusClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                newStatus = "NotStarted",
            });
            Response response = await client.UpdateAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Update_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TaskStatusClient client = new TaskStatusClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                newStatus = "NotStarted",
                comment = "<comment>",
            });
            Response response = client.Update(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Update_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TaskStatusClient client = new TaskStatusClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                newStatus = "NotStarted",
                comment = "<comment>",
            });
            Response response = await client.UpdateAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }
    }
}
