// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure;
using Azure.Analytics.Purview.Workflows;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Workflows.Samples
{
    public partial class Samples_PurviewWorkflowServiceClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflow_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = client.GetWorkflow(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflow_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = await client.GetWorkflowAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflow_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = client.GetWorkflow(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflow_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = await client.GetWorkflowAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrReplaceWorkflow_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
            });
            Response response = client.CreateOrReplace(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrReplaceWorkflow_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
            });
            Response response = await client.CreateOrReplaceAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CreateOrReplaceWorkflow_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
underGlossaryHierarchy = "<underGlossaryHierarchy>",
underCollection = "<underCollection>",
underGlossary = "<underGlossary>",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
                actionDag = new object(),
            });
            Response response = client.CreateOrReplace(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CreateOrReplaceWorkflow_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                triggers = new object[]
            {
new
{
type = "when_term_creation_is_requested",
underGlossaryHierarchy = "<underGlossaryHierarchy>",
underCollection = "<underCollection>",
underGlossary = "<underGlossary>",
}
            },
                name = "<name>",
                isEnabled = true,
                description = "<description>",
                actionDag = new object(),
            });
            Response response = await client.CreateOrReplaceAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
            Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("createdBy").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("updatedBy").ToString());
            Console.WriteLine(result.GetProperty("name").ToString());
            Console.WriteLine(result.GetProperty("isEnabled").ToString());
            Console.WriteLine(result.GetProperty("description").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteWorkflow_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = client.Delete(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteWorkflow_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = await client.DeleteAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_DeleteWorkflow_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = client.Delete(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_DeleteWorkflow_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowClient client = new WorkflowClient(endpoint, credential);

            Response response = await client.DeleteAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"));

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SubmitUserRequests_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            UserRequestsClient client = new UserRequestsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                operations = new object[]
            {
new
{
type = "CreateTerm",
payload = new object(),
}
            },
            });
            Response response = client.Submit(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("requestId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SubmitUserRequests_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            UserRequestsClient client = new UserRequestsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                operations = new object[]
            {
new
{
type = "CreateTerm",
payload = new object(),
}
            },
            });
            Response response = await client.SubmitAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("requestId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_SubmitUserRequests_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            UserRequestsClient client = new UserRequestsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                operations = new object[]
            {
new
{
type = "CreateTerm",
payload = new object(),
}
            },
                comment = "<comment>",
            });
            Response response = client.Submit(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("requestId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("workflowRunIds")[0].ToString());
            Console.WriteLine(result.GetProperty("comment").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_SubmitUserRequests_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            UserRequestsClient client = new UserRequestsClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                operations = new object[]
            {
new
{
type = "CreateTerm",
payload = new object(),
}
            },
                comment = "<comment>",
            });
            Response response = await client.SubmitAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("requestId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("operations")[0].GetProperty("workflowRunIds")[0].ToString());
            Console.WriteLine(result.GetProperty("comment").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflowRun_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            Response response = client.GetWorkflowRun(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("runInput").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("actions").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflowRun_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            Response response = await client.GetWorkflowRunAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("runInput").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("actions").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflowRun_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            Response response = client.GetWorkflowRun(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("workflowId").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("userRequestId").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("targetValue").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("cancelTime").ToString());
            Console.WriteLine(result.GetProperty("cancelComment").ToString());
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("runInput").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("actions").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflowRun_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            Response response = await client.GetWorkflowRunAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("workflowId").ToString());
            Console.WriteLine(result.GetProperty("startTime").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("userRequestId").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("targetValue").ToString());
            Console.WriteLine(result.GetProperty("runPayload").GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("status").ToString());
            Console.WriteLine(result.GetProperty("endTime").ToString());
            Console.WriteLine(result.GetProperty("cancelTime").ToString());
            Console.WriteLine(result.GetProperty("cancelComment").ToString());
            Console.WriteLine(result.GetProperty("actionDag").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("runInput").ToString());
            Console.WriteLine(result.GetProperty("detail").GetProperty("actions").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CancelWorkflowRun_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Cancel(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CancelWorkflowRun_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.CancelAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_CancelWorkflowRun_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = client.Cancel(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_CancelWorkflowRun_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunClient client = new WorkflowRunClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = await client.CancelAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflowTask_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTaskClient client = new WorkflowTaskClient(endpoint, credential);

            Response response = client.GetWorkflowTask(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("workflowRunId").ToString());
            Console.WriteLine(result.GetProperty("workflowId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("payload").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("payload").GetProperty("targetValue").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflowTask_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTaskClient client = new WorkflowTaskClient(endpoint, credential);

            Response response = await client.GetWorkflowTaskAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("workflowRunId").ToString());
            Console.WriteLine(result.GetProperty("workflowId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("payload").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("payload").GetProperty("targetValue").ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflowTask_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTaskClient client = new WorkflowTaskClient(endpoint, credential);

            Response response = client.GetWorkflowTask(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("title").ToString());
            Console.WriteLine(result.GetProperty("workflowRunId").ToString());
            Console.WriteLine(result.GetProperty("workflowId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("payload").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("payload").GetProperty("targetValue").ToString());
            Console.WriteLine(result.GetProperty("payload").GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("lastRemindTime").ToString());
            Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("nextRemindTime").ToString());
            Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("reminderSettings").ToString());
            Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("lastExpiryNotificationTime").ToString());
            Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("nextExpiryNotificationTime").ToString());
            Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expiryTime").ToString());
            Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expirySettings").GetProperty("expireAfter").ToString());
            Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expirySettings").GetProperty("notifyOnExpiration")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflowTask_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTaskClient client = new WorkflowTaskClient(endpoint, credential);

            Response response = await client.GetWorkflowTaskAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("id").ToString());
            Console.WriteLine(result.GetProperty("title").ToString());
            Console.WriteLine(result.GetProperty("workflowRunId").ToString());
            Console.WriteLine(result.GetProperty("workflowId").ToString());
            Console.WriteLine(result.GetProperty("requestor").ToString());
            Console.WriteLine(result.GetProperty("createdTime").ToString());
            Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
            Console.WriteLine(result.GetProperty("payload").GetProperty("type").ToString());
            Console.WriteLine(result.GetProperty("payload").GetProperty("targetValue").ToString());
            Console.WriteLine(result.GetProperty("payload").GetProperty("payload").ToString());
            Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("lastRemindTime").ToString());
            Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("nextRemindTime").ToString());
            Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("reminderSettings").ToString());
            Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("lastExpiryNotificationTime").ToString());
            Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("nextExpiryNotificationTime").ToString());
            Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expiryTime").ToString());
            Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expirySettings").GetProperty("expireAfter").ToString());
            Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expirySettings").GetProperty("notifyOnExpiration")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ApproveApprovalTask_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Approve(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ApproveApprovalTask_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.ApproveAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ApproveApprovalTask_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = client.Approve(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ApproveApprovalTask_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = await client.ApproveAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_RejectApprovalTask_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Reject(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_RejectApprovalTask_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.RejectAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_RejectApprovalTask_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = client.Reject(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_RejectApprovalTask_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = await client.RejectAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ReassignWorkflowTask_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTaskClient client = new WorkflowTaskClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Reassign(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ReassignWorkflowTask_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTaskClient client = new WorkflowTaskClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.ReassignAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_ReassignWorkflowTask_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTaskClient client = new WorkflowTaskClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                reassignments = new object[]
            {
new
{
reassignFrom = "73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a",
reassignTo = "73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a",
}
            },
            });
            Response response = client.Reassign(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_ReassignWorkflowTask_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTaskClient client = new WorkflowTaskClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                reassignments = new object[]
            {
new
{
reassignFrom = "73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a",
reassignTo = "73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a",
}
            },
            });
            Response response = await client.ReassignAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateTaskStatus_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TaskStatusClient client = new TaskStatusClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                newStatus = "NotStarted",
            });
            Response response = client.Update(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateTaskStatus_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TaskStatusClient client = new TaskStatusClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                newStatus = "NotStarted",
            });
            Response response = await client.UpdateAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_UpdateTaskStatus_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TaskStatusClient client = new TaskStatusClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                newStatus = "NotStarted",
                comment = "<comment>",
            });
            Response response = client.Update(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_UpdateTaskStatus_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TaskStatusClient client = new TaskStatusClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                newStatus = "NotStarted",
                comment = "<comment>",
            });
            Response response = await client.UpdateAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflows_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowsClient client = new WorkflowsClient(endpoint, credential);

            foreach (BinaryData item in client.GetWorkflows(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("isEnabled").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflows_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowsClient client = new WorkflowsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetWorkflowsAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("isEnabled").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflows_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowsClient client = new WorkflowsClient(endpoint, credential);

            foreach (BinaryData item in client.GetWorkflows(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
                Console.WriteLine(result.GetProperty("createdTime").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
                Console.WriteLine(result.GetProperty("updatedBy").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("isEnabled").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflows_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowsClient client = new WorkflowsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetWorkflowsAsync(null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossaryHierarchy").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underCollection").ToString());
                Console.WriteLine(result.GetProperty("triggers")[0].GetProperty("underGlossary").ToString());
                Console.WriteLine(result.GetProperty("createdTime").ToString());
                Console.WriteLine(result.GetProperty("createdBy").ToString());
                Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
                Console.WriteLine(result.GetProperty("updatedBy").ToString());
                Console.WriteLine(result.GetProperty("name").ToString());
                Console.WriteLine(result.GetProperty("isEnabled").ToString());
                Console.WriteLine(result.GetProperty("description").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflowRuns_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunsClient client = new WorkflowRunsClient(endpoint, credential);

            foreach (BinaryData item in client.GetWorkflowRuns(null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("workflowId").ToString());
                Console.WriteLine(result.GetProperty("startTime").ToString());
                Console.WriteLine(result.GetProperty("requestor").ToString());
                Console.WriteLine(result.GetProperty("runPayload").GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("runPayload").GetProperty("targetValue").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflowRuns_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunsClient client = new WorkflowRunsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetWorkflowRunsAsync(null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("workflowId").ToString());
                Console.WriteLine(result.GetProperty("startTime").ToString());
                Console.WriteLine(result.GetProperty("requestor").ToString());
                Console.WriteLine(result.GetProperty("runPayload").GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("runPayload").GetProperty("targetValue").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflowRuns_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunsClient client = new WorkflowRunsClient(endpoint, credential);

            foreach (BinaryData item in client.GetWorkflowRuns("<viewMode>", "1d", "status desc", new string[] { "InProgress" }, new string[] { "<workflowIds>" }, new string[] { "<requestorIds>" }, 1234, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("workflowId").ToString());
                Console.WriteLine(result.GetProperty("startTime").ToString());
                Console.WriteLine(result.GetProperty("requestor").ToString());
                Console.WriteLine(result.GetProperty("userRequestId").ToString());
                Console.WriteLine(result.GetProperty("runPayload").GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("runPayload").GetProperty("targetValue").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("endTime").ToString());
                Console.WriteLine(result.GetProperty("cancelTime").ToString());
                Console.WriteLine(result.GetProperty("cancelComment").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflowRuns_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowRunsClient client = new WorkflowRunsClient(endpoint, credential);

            await foreach (BinaryData item in client.GetWorkflowRunsAsync("<viewMode>", "1d", "status desc", new string[] { "InProgress" }, new string[] { "<workflowIds>" }, new string[] { "<requestorIds>" }, 1234, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("workflowId").ToString());
                Console.WriteLine(result.GetProperty("startTime").ToString());
                Console.WriteLine(result.GetProperty("requestor").ToString());
                Console.WriteLine(result.GetProperty("userRequestId").ToString());
                Console.WriteLine(result.GetProperty("runPayload").GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("runPayload").GetProperty("targetValue").ToString());
                Console.WriteLine(result.GetProperty("status").ToString());
                Console.WriteLine(result.GetProperty("endTime").ToString());
                Console.WriteLine(result.GetProperty("cancelTime").ToString());
                Console.WriteLine(result.GetProperty("cancelComment").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflowTasks_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTasksClient client = new WorkflowTasksClient(endpoint, credential);

            foreach (BinaryData item in client.GetWorkflowTasks(null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("workflowRunId").ToString());
                Console.WriteLine(result.GetProperty("workflowId").ToString());
                Console.WriteLine(result.GetProperty("requestor").ToString());
                Console.WriteLine(result.GetProperty("createdTime").ToString());
                Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
                Console.WriteLine(result.GetProperty("payload").GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("payload").GetProperty("targetValue").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflowTasks_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTasksClient client = new WorkflowTasksClient(endpoint, credential);

            await foreach (BinaryData item in client.GetWorkflowTasksAsync(null, null, null, null, null, null, null, null, null, null, null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("workflowRunId").ToString());
                Console.WriteLine(result.GetProperty("workflowId").ToString());
                Console.WriteLine(result.GetProperty("requestor").ToString());
                Console.WriteLine(result.GetProperty("createdTime").ToString());
                Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
                Console.WriteLine(result.GetProperty("payload").GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("payload").GetProperty("targetValue").ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_GetWorkflowTasks_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTasksClient client = new WorkflowTasksClient(endpoint, credential);

            foreach (BinaryData item in client.GetWorkflowTasks("<viewMode>", new string[] { "<workflowIds>" }, "1d", 1234, "status desc", new string[] { "Approval" }, new string[] { "InProgress" }, new string[] { "<requestorIds>" }, new string[] { "<assigneeIds>" }, "<workflowNameKeyword>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("title").ToString());
                Console.WriteLine(result.GetProperty("workflowRunId").ToString());
                Console.WriteLine(result.GetProperty("workflowId").ToString());
                Console.WriteLine(result.GetProperty("requestor").ToString());
                Console.WriteLine(result.GetProperty("createdTime").ToString());
                Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
                Console.WriteLine(result.GetProperty("payload").GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("payload").GetProperty("targetValue").ToString());
                Console.WriteLine(result.GetProperty("payload").GetProperty("payload").ToString());
                Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("lastRemindTime").ToString());
                Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("nextRemindTime").ToString());
                Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("reminderSettings").ToString());
                Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("lastExpiryNotificationTime").ToString());
                Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("nextExpiryNotificationTime").ToString());
                Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expiryTime").ToString());
                Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expirySettings").GetProperty("expireAfter").ToString());
                Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expirySettings").GetProperty("notifyOnExpiration")[0].ToString());
            }
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_GetWorkflowTasks_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            WorkflowTasksClient client = new WorkflowTasksClient(endpoint, credential);

            await foreach (BinaryData item in client.GetWorkflowTasksAsync("<viewMode>", new string[] { "<workflowIds>" }, "1d", 1234, "status desc", new string[] { "Approval" }, new string[] { "<requestorIds>" }, new string[] { "<assigneeIds>" }, new string[] { "InProgress" }, "<workflowNameKeyword>", null))
            {
                JsonElement result = JsonDocument.Parse(item.ToStream()).RootElement;
                Console.WriteLine(result.GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("id").ToString());
                Console.WriteLine(result.GetProperty("title").ToString());
                Console.WriteLine(result.GetProperty("workflowRunId").ToString());
                Console.WriteLine(result.GetProperty("workflowId").ToString());
                Console.WriteLine(result.GetProperty("requestor").ToString());
                Console.WriteLine(result.GetProperty("createdTime").ToString());
                Console.WriteLine(result.GetProperty("lastUpdateTime").ToString());
                Console.WriteLine(result.GetProperty("payload").GetProperty("type").ToString());
                Console.WriteLine(result.GetProperty("payload").GetProperty("targetValue").ToString());
                Console.WriteLine(result.GetProperty("payload").GetProperty("payload").ToString());
                Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("lastRemindTime").ToString());
                Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("nextRemindTime").ToString());
                Console.WriteLine(result.GetProperty("reminderInfo").GetProperty("reminderSettings").ToString());
                Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("lastExpiryNotificationTime").ToString());
                Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("nextExpiryNotificationTime").ToString());
                Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expiryTime").ToString());
                Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expirySettings").GetProperty("expireAfter").ToString());
                Console.WriteLine(result.GetProperty("expiryInfo").GetProperty("expirySettings").GetProperty("notifyOnExpiration")[0].ToString());
            }
        }
    }
}
