// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.Workflows.Samples
{
    public partial class Samples_ApprovalClient
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Approve_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Approve(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Approve_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.ApproveAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Approve_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = client.Approve(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Approve_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = await client.ApproveAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Reject_ShortVersion()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = client.Reject(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Reject_ShortVersion_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new object());
            Response response = await client.RejectAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Reject_AllParameters()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = client.Reject(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Reject_AllParameters_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            ApprovalClient client = new ApprovalClient(endpoint, credential);

            using RequestContent content = RequestContent.Create(new
            {
                comment = "<comment>",
            });
            Response response = await client.RejectAsync(Guid.Parse("73f411fe-4f43-4b4b-9cbd-6828d8f4cf9a"), content);

            Console.WriteLine(response.Status);
        }
    }
}
