// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Autorest.CSharp.Core;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Analytics.Purview.Workflows
{
    // Data plane generated client.
    /// <summary> The WorkflowTasks service client. </summary>
    public partial class WorkflowTasksClient
    {
        private static readonly string[] AuthorizationScopes = new string[] { "https://purview.azure.net/.default" };
        private readonly TokenCredential _tokenCredential;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public virtual HttpPipeline Pipeline => _pipeline;

        /// <summary> Initializes a new instance of WorkflowTasksClient for mocking. </summary>
        protected WorkflowTasksClient()
        {
        }

        /// <summary> Initializes a new instance of WorkflowTasksClient. </summary>
        /// <param name="endpoint"> The account endpoint of your Purview account. Example: https://{accountName}.purview.azure.com/. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public WorkflowTasksClient(Uri endpoint, TokenCredential credential) : this(endpoint, credential, new PurviewWorkflowServiceClientOptions())
        {
        }

        /// <summary> Initializes a new instance of WorkflowTasksClient. </summary>
        /// <param name="endpoint"> The account endpoint of your Purview account. Example: https://{accountName}.purview.azure.com/. </param>
        /// <param name="credential"> A credential used to authenticate to an Azure Service. </param>
        /// <param name="options"> The options for configuring the client. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="endpoint"/> or <paramref name="credential"/> is null. </exception>
        public WorkflowTasksClient(Uri endpoint, TokenCredential credential, PurviewWorkflowServiceClientOptions options)
        {
            Argument.AssertNotNull(endpoint, nameof(endpoint));
            Argument.AssertNotNull(credential, nameof(credential));
            options ??= new PurviewWorkflowServiceClientOptions();

            ClientDiagnostics = new ClientDiagnostics(options, true);
            _tokenCredential = credential;
            _pipeline = HttpPipelineBuilder.Build(options, Array.Empty<HttpPipelinePolicy>(), new HttpPipelinePolicy[] { new BearerTokenAuthenticationPolicy(_tokenCredential, AuthorizationScopes) }, new ResponseClassifier());
            _endpoint = endpoint;
            _apiVersion = options.Version;
        }

        /// <summary>
        /// [Protocol Method] Get all workflow tasks.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="viewMode"> To filter user's sent, received or history workflow tasks. </param>
        /// <param name="workflowIds"> Filter items by workflow id list. </param>
        /// <param name="timeWindow"> Time window of filtering items. Allowed values: "1d" | "7d" | "30d" | "90d". </param>
        /// <param name="maxpagesize"> The maximum page size to get the items at one time. The default value is 100. </param>
        /// <param name="orderby"> The key word which used to sort the results. Allowed values: "status desc" | "status asc" | "requestor desc" | "requestor asc" | "startTime desc" | "startTime asc" | "createdTime desc" | "createdTime asc". </param>
        /// <param name="taskTypes"> Filter items by workflow task type. </param>
        /// <param name="taskStatuses"> Filter workflow tasks by status. </param>
        /// <param name="requestors"> Requestors' ids to filter. </param>
        /// <param name="assignees"> Assignees' ids to filter. </param>
        /// <param name="workflowNameKeyword"> The key word which could used to filter workflow item with related workflow. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="AsyncPageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/WorkflowTasksClient.xml" path="doc/members/member[@name='GetWorkflowTasksAsync(string,IEnumerable{string},string,int?,string,IEnumerable{string},IEnumerable{string},IEnumerable{string},IEnumerable{string},string,RequestContext)']/*" />
        public virtual AsyncPageable<BinaryData> GetWorkflowTasksAsync(string viewMode, IEnumerable<string> workflowIds, string timeWindow, int? maxpagesize, string orderby, IEnumerable<string> taskTypes, IEnumerable<string> taskStatuses, IEnumerable<string> requestors, IEnumerable<string> assignees, string workflowNameKeyword, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetWorkflowTasksRequest(viewMode, workflowIds, timeWindow, maxpagesize, orderby, taskTypes, taskStatuses, requestors, assignees, workflowNameKeyword, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetWorkflowTasksNextPageRequest(nextLink, viewMode, workflowIds, timeWindow, maxpagesize, orderby, taskTypes, taskStatuses, requestors, assignees, workflowNameKeyword, context);
            return GeneratorPageableHelpers.CreateAsyncPageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "WorkflowTasksClient.GetWorkflowTasks", "value", "nextLink", context);
        }

        /// <summary>
        /// [Protocol Method] Get all workflow tasks.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="viewMode"> To filter user's sent, received or history workflow tasks. </param>
        /// <param name="workflowIds"> Filter items by workflow id list. </param>
        /// <param name="timeWindow"> Time window of filtering items. Allowed values: "1d" | "7d" | "30d" | "90d". </param>
        /// <param name="maxpagesize"> The maximum page size to get the items at one time. The default value is 100. </param>
        /// <param name="orderby"> The key word which used to sort the results. Allowed values: "status desc" | "status asc" | "requestor desc" | "requestor asc" | "startTime desc" | "startTime asc" | "createdTime desc" | "createdTime asc". </param>
        /// <param name="taskTypes"> Filter items by workflow task type. </param>
        /// <param name="taskStatuses"> Filter workflow tasks by status. </param>
        /// <param name="requestors"> Requestors' ids to filter. </param>
        /// <param name="assignees"> Assignees' ids to filter. </param>
        /// <param name="workflowNameKeyword"> The key word which could used to filter workflow item with related workflow. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The <see cref="Pageable{T}"/> from the service containing a list of <see cref="BinaryData"/> objects. Details of the body schema for each item in the collection are in the Remarks section below. </returns>
        /// <include file="Docs/WorkflowTasksClient.xml" path="doc/members/member[@name='GetWorkflowTasks(string,IEnumerable{string},string,int?,string,IEnumerable{string},IEnumerable{string},IEnumerable{string},IEnumerable{string},string,RequestContext)']/*" />
        public virtual Pageable<BinaryData> GetWorkflowTasks(string viewMode, IEnumerable<string> workflowIds, string timeWindow, int? maxpagesize, string orderby, IEnumerable<string> taskTypes, IEnumerable<string> taskStatuses, IEnumerable<string> requestors, IEnumerable<string> assignees, string workflowNameKeyword, RequestContext context)
        {
            HttpMessage FirstPageRequest(int? pageSizeHint) => CreateGetWorkflowTasksRequest(viewMode, workflowIds, timeWindow, maxpagesize, orderby, taskTypes, taskStatuses, requestors, assignees, workflowNameKeyword, context);
            HttpMessage NextPageRequest(int? pageSizeHint, string nextLink) => CreateGetWorkflowTasksNextPageRequest(nextLink, viewMode, workflowIds, timeWindow, maxpagesize, orderby, taskTypes, taskStatuses, requestors, assignees, workflowNameKeyword, context);
            return GeneratorPageableHelpers.CreatePageable(FirstPageRequest, NextPageRequest, e => BinaryData.FromString(e.GetRawText()), ClientDiagnostics, _pipeline, "WorkflowTasksClient.GetWorkflowTasks", "value", "nextLink", context);
        }

        internal HttpMessage CreateGetWorkflowTasksRequest(string viewMode, IEnumerable<string> workflowIds, string timeWindow, int? maxpagesize, string orderby, IEnumerable<string> taskTypes, IEnumerable<string> taskStatuses, IEnumerable<string> requestors, IEnumerable<string> assignees, string workflowNameKeyword, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/workflow", false);
            uri.AppendPath("/workflowtasks", false);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (viewMode != null)
            {
                uri.AppendQuery("viewMode", viewMode, true);
            }
            if (workflowIds != null && !(workflowIds is ChangeTrackingList<string> changeTrackingList && changeTrackingList.IsUndefined))
            {
                uri.AppendQueryDelimited("workflowIds", workflowIds, ",", true);
            }
            if (timeWindow != null)
            {
                uri.AppendQuery("timeWindow", timeWindow, true);
            }
            if (maxpagesize != null)
            {
                uri.AppendQuery("maxpagesize", maxpagesize.Value, true);
            }
            if (orderby != null)
            {
                uri.AppendQuery("orderby", orderby, true);
            }
            if (taskTypes != null && !(taskTypes is ChangeTrackingList<string> changeTrackingList0 && changeTrackingList0.IsUndefined))
            {
                uri.AppendQueryDelimited("taskTypes", taskTypes, ",", true);
            }
            if (taskStatuses != null && !(taskStatuses is ChangeTrackingList<string> changeTrackingList1 && changeTrackingList1.IsUndefined))
            {
                uri.AppendQueryDelimited("taskStatuses", taskStatuses, ",", true);
            }
            if (requestors != null && !(requestors is ChangeTrackingList<string> changeTrackingList2 && changeTrackingList2.IsUndefined))
            {
                uri.AppendQueryDelimited("requestors", requestors, ",", true);
            }
            if (assignees != null && !(assignees is ChangeTrackingList<string> changeTrackingList3 && changeTrackingList3.IsUndefined))
            {
                uri.AppendQueryDelimited("assignees", assignees, ",", true);
            }
            if (workflowNameKeyword != null)
            {
                uri.AppendQuery("workflowNameKeyword", workflowNameKeyword, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetWorkflowTasksNextPageRequest(string nextLink, string viewMode, IEnumerable<string> workflowIds, string timeWindow, int? maxpagesize, string orderby, IEnumerable<string> taskTypes, IEnumerable<string> taskStatuses, IEnumerable<string> requestors, IEnumerable<string> assignees, string workflowNameKeyword, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/workflow", false);
            uri.AppendRawNextLink(nextLink, false);
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        private static ResponseClassifier _responseClassifier200;
        private static ResponseClassifier ResponseClassifier200 => _responseClassifier200 ??= new StatusCodeClassifier(stackalloc ushort[] { 200 });
    }
}
