// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Analytics.Purview.Sharing;
using Azure.Core.Extensions;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="ReceivedSharesClient"/>, <see cref="SentSharesClient"/>, <see cref="ShareResourcesClient"/> to client builder. </summary>
    public static partial class AnalyticsPurviewSharingClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="ReceivedSharesClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The sharing endpoint of your purview account. Example: https://{accountName}.purview.azure.com/share. </param>
        public static IAzureClientBuilder<ReceivedSharesClient, PurviewShareClientOptions> AddReceivedSharesClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<ReceivedSharesClient, PurviewShareClientOptions>((options, cred) => new ReceivedSharesClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="SentSharesClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The sharing endpoint of your purview account. Example: https://{accountName}.purview.azure.com/share. </param>
        public static IAzureClientBuilder<SentSharesClient, PurviewShareClientOptions> AddSentSharesClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<SentSharesClient, PurviewShareClientOptions>((options, cred) => new SentSharesClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="ShareResourcesClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The sharing endpoint of your purview account. Example: https://{accountName}.purview.azure.com/share. </param>
        public static IAzureClientBuilder<ShareResourcesClient, PurviewShareClientOptions> AddShareResourcesClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<ShareResourcesClient, PurviewShareClientOptions>((options, cred) => new ShareResourcesClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="ReceivedSharesClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<ReceivedSharesClient, PurviewShareClientOptions> AddReceivedSharesClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<ReceivedSharesClient, PurviewShareClientOptions>(configuration);
        }
        /// <summary> Registers a <see cref="SentSharesClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<SentSharesClient, PurviewShareClientOptions> AddSentSharesClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<SentSharesClient, PurviewShareClientOptions>(configuration);
        }
        /// <summary> Registers a <see cref="ShareResourcesClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<ShareResourcesClient, PurviewShareClientOptions> AddShareResourcesClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<ShareResourcesClient, PurviewShareClientOptions>(configuration);
        }
    }
}
