// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Analytics.Purview.Scanning
{
    /// <summary> Client options for PurviewScanningServiceClient. </summary>
    public partial class PurviewScanningServiceClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V2018_12_01_Preview;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2018-12-01-preview". </summary>
            V2018_12_01_Preview = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of PurviewScanningServiceClientOptions. </summary>
        public PurviewScanningServiceClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V2018_12_01_Preview => "2018-12-01-preview",
                _ => throw new NotSupportedException()
            };
        }
    }
}
