// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Analytics.Purview.Scanning;
using Azure.Core.Extensions;

namespace Microsoft.Extensions.Azure
{
    /// <summary> Extension methods to add <see cref="PurviewScanningServiceClient"/>, <see cref="PurviewClassificationRuleClient"/>, <see cref="PurviewDataSourceClient"/>, <see cref="PurviewScanClient"/> to client builder. </summary>
    public static partial class AnalyticsPurviewScanningClientBuilderExtensions
    {
        /// <summary> Registers a <see cref="PurviewScanningServiceClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The scanning endpoint of your purview account. Example: https://{accountName}.scan.purview.azure.com. </param>
        public static IAzureClientBuilder<PurviewScanningServiceClient, PurviewScanningServiceClientOptions> AddPurviewScanningServiceClient<TBuilder>(this TBuilder builder, Uri endpoint)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<PurviewScanningServiceClient, PurviewScanningServiceClientOptions>((options, cred) => new PurviewScanningServiceClient(endpoint, cred, options));
        }

        /// <summary> Registers a <see cref="PurviewClassificationRuleClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The scanning endpoint of your purview account. Example: https://{accountName}.scan.purview.azure.com. </param>
        /// <param name="classificationRuleName"> The <see cref="string"/> to use. </param>
        public static IAzureClientBuilder<PurviewClassificationRuleClient, PurviewScanningServiceClientOptions> AddPurviewClassificationRuleClient<TBuilder>(this TBuilder builder, Uri endpoint, string classificationRuleName)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<PurviewClassificationRuleClient, PurviewScanningServiceClientOptions>((options, cred) => new PurviewClassificationRuleClient(endpoint, classificationRuleName, cred, options));
        }

        /// <summary> Registers a <see cref="PurviewDataSourceClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The scanning endpoint of your purview account. Example: https://{accountName}.scan.purview.azure.com. </param>
        /// <param name="dataSourceName"> The <see cref="string"/> to use. </param>
        public static IAzureClientBuilder<PurviewDataSourceClient, PurviewScanningServiceClientOptions> AddPurviewDataSourceClient<TBuilder>(this TBuilder builder, Uri endpoint, string dataSourceName)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<PurviewDataSourceClient, PurviewScanningServiceClientOptions>((options, cred) => new PurviewDataSourceClient(endpoint, dataSourceName, cred, options));
        }

        /// <summary> Registers a <see cref="PurviewScanClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="endpoint"> The scanning endpoint of your purview account. Example: https://{accountName}.scan.purview.azure.com. </param>
        /// <param name="dataSourceName"> The <see cref="string"/> to use. </param>
        /// <param name="scanName"> The <see cref="string"/> to use. </param>
        public static IAzureClientBuilder<PurviewScanClient, PurviewScanningServiceClientOptions> AddPurviewScanClient<TBuilder>(this TBuilder builder, Uri endpoint, string dataSourceName, string scanName)
        where TBuilder : IAzureClientFactoryBuilderWithCredential
        {
            return builder.RegisterClientFactory<PurviewScanClient, PurviewScanningServiceClientOptions>((options, cred) => new PurviewScanClient(endpoint, dataSourceName, scanName, cred, options));
        }

        /// <summary> Registers a <see cref="PurviewScanningServiceClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<PurviewScanningServiceClient, PurviewScanningServiceClientOptions> AddPurviewScanningServiceClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<PurviewScanningServiceClient, PurviewScanningServiceClientOptions>(configuration);
        }
        /// <summary> Registers a <see cref="PurviewClassificationRuleClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<PurviewClassificationRuleClient, PurviewScanningServiceClientOptions> AddPurviewClassificationRuleClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<PurviewClassificationRuleClient, PurviewScanningServiceClientOptions>(configuration);
        }
        /// <summary> Registers a <see cref="PurviewDataSourceClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<PurviewDataSourceClient, PurviewScanningServiceClientOptions> AddPurviewDataSourceClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<PurviewDataSourceClient, PurviewScanningServiceClientOptions>(configuration);
        }
        /// <summary> Registers a <see cref="PurviewScanClient"/> instance. </summary>
        /// <param name="builder"> The builder to register with. </param>
        /// <param name="configuration"> The configuration values. </param>
        public static IAzureClientBuilder<PurviewScanClient, PurviewScanningServiceClientOptions> AddPurviewScanClient<TBuilder, TConfiguration>(this TBuilder builder, TConfiguration configuration)
        where TBuilder : IAzureClientFactoryBuilderWithConfiguration<TConfiguration>
        {
            return builder.RegisterClientFactory<PurviewScanClient, PurviewScanningServiceClientOptions>(configuration);
        }
    }
}
