// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.DataMap.Samples
{
    public partial class Samples_TypeDefinition
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetBusinessMetadataById_TypeGetBusinessMetadataDefByGuid()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetBusinessMetadataById("d8757510-c866-61ba-486f-1afca09f43b8", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetBusinessMetadataById_TypeGetBusinessMetadataDefByGuid_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetBusinessMetadataByIdAsync("d8757510-c866-61ba-486f-1afca09f43b8", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetBusinessMetadataById_TypeGetBusinessMetadataDefByGuid_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasBusinessMetadataDef> response = client.GetBusinessMetadataById("d8757510-c866-61ba-486f-1afca09f43b8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetBusinessMetadataById_TypeGetBusinessMetadataDefByGuid_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasBusinessMetadataDef> response = await client.GetBusinessMetadataByIdAsync("d8757510-c866-61ba-486f-1afca09f43b8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetBusinessMetadataByName_TypeGetBusinessMetadataDefByName()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetBusinessMetadataByName("Business_Metadata_Type_Name", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetBusinessMetadataByName_TypeGetBusinessMetadataDefByName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetBusinessMetadataByNameAsync("Business_Metadata_Type_Name", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetBusinessMetadataByName_TypeGetBusinessMetadataDefByName_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasBusinessMetadataDef> response = client.GetBusinessMetadataByName("Business_Metadata_Type_Name");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetBusinessMetadataByName_TypeGetBusinessMetadataDefByName_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasBusinessMetadataDef> response = await client.GetBusinessMetadataByNameAsync("Business_Metadata_Type_Name");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetClassificationById_TypeGetClassificationDefByGuid()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetClassificationById("e79878fa-adba-4ee5-adc5-328d8841cd49", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetClassificationById_TypeGetClassificationDefByGuid_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetClassificationByIdAsync("e79878fa-adba-4ee5-adc5-328d8841cd49", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetClassificationById_TypeGetClassificationDefByGuid_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasClassificationDef> response = client.GetClassificationById("e79878fa-adba-4ee5-adc5-328d8841cd49");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetClassificationById_TypeGetClassificationDefByGuid_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasClassificationDef> response = await client.GetClassificationByIdAsync("e79878fa-adba-4ee5-adc5-328d8841cd49");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetClassificationByName_TypeGetClassificationDefByName()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetClassificationByName("MICROSOFT.GOVERNMENT.CANADA.SOCIAL_INSURANCE_NUMBER", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetClassificationByName_TypeGetClassificationDefByName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetClassificationByNameAsync("MICROSOFT.GOVERNMENT.CANADA.SOCIAL_INSURANCE_NUMBER", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetClassificationByName_TypeGetClassificationDefByName_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasClassificationDef> response = client.GetClassificationByName("MICROSOFT.GOVERNMENT.CANADA.SOCIAL_INSURANCE_NUMBER");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetClassificationByName_TypeGetClassificationDefByName_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasClassificationDef> response = await client.GetClassificationByNameAsync("MICROSOFT.GOVERNMENT.CANADA.SOCIAL_INSURANCE_NUMBER");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetEntityById_TypeGetEntityDefByGuid()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetEntityById("4bc54c37-98a8-4de8-9ee8-182610859d43", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetEntityById_TypeGetEntityDefByGuid_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetEntityByIdAsync("4bc54c37-98a8-4de8-9ee8-182610859d43", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetEntityById_TypeGetEntityDefByGuid_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasEntityDef> response = client.GetEntityById("4bc54c37-98a8-4de8-9ee8-182610859d43");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetEntityById_TypeGetEntityDefByGuid_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasEntityDef> response = await client.GetEntityByIdAsync("4bc54c37-98a8-4de8-9ee8-182610859d43");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetEntityByName_TypeGetEntityDefByName()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetEntityByName("DataSet", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetEntityByName_TypeGetEntityDefByName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetEntityByNameAsync("DataSet", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetEntityByName_TypeGetEntityDefByName_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasEntityDef> response = client.GetEntityByName("DataSet");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetEntityByName_TypeGetEntityDefByName_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasEntityDef> response = await client.GetEntityByNameAsync("DataSet");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetEnumById_TypeGetEnumDefByGuid()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetEnumById("644ab9c7-893a-4a4d-8e0a-591a6556d1a0", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetEnumById_TypeGetEnumDefByGuid_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetEnumByIdAsync("644ab9c7-893a-4a4d-8e0a-591a6556d1a0", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetEnumById_TypeGetEnumDefByGuid_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasEnumDef> response = client.GetEnumById("644ab9c7-893a-4a4d-8e0a-591a6556d1a0");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetEnumById_TypeGetEnumDefByGuid_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasEnumDef> response = await client.GetEnumByIdAsync("644ab9c7-893a-4a4d-8e0a-591a6556d1a0");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetEnumByName_TypeGetEnumDefByName()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetEnumByName("hive_principal_type", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetEnumByName_TypeGetEnumDefByName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetEnumByNameAsync("hive_principal_type", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetEnumByName_TypeGetEnumDefByName_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasEnumDef> response = client.GetEnumByName("hive_principal_type");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetEnumByName_TypeGetEnumDefByName_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasEnumDef> response = await client.GetEnumByNameAsync("hive_principal_type");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetRelationshipById_TypeGetRelationshipDefByGuid()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetRelationshipById("695edde1-2782-4a3c-841b-0b3aba25fe45", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetRelationshipById_TypeGetRelationshipDefByGuid_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetRelationshipByIdAsync("695edde1-2782-4a3c-841b-0b3aba25fe45", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetRelationshipById_TypeGetRelationshipDefByGuid_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasRelationshipDef> response = client.GetRelationshipById("695edde1-2782-4a3c-841b-0b3aba25fe45");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetRelationshipById_TypeGetRelationshipDefByGuid_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasRelationshipDef> response = await client.GetRelationshipByIdAsync("695edde1-2782-4a3c-841b-0b3aba25fe45");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetRelationshipByName_TypeGetRelationshipDefByName()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetRelationshipByName("storm_topology_nodes", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetRelationshipByName_TypeGetRelationshipDefByName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetRelationshipByNameAsync("storm_topology_nodes", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetRelationshipByName_TypeGetRelationshipDefByName_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasRelationshipDef> response = client.GetRelationshipByName("storm_topology_nodes");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetRelationshipByName_TypeGetRelationshipDefByName_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasRelationshipDef> response = await client.GetRelationshipByNameAsync("storm_topology_nodes");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetStructById_TypeGetStructDefByGuid()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetStructById("f1571b6e-ad08-4040-a9a7-c30ed935d437", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetStructById_TypeGetStructDefByGuid_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetStructByIdAsync("f1571b6e-ad08-4040-a9a7-c30ed935d437", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetStructById_TypeGetStructDefByGuid_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasStructDef> response = client.GetStructById("f1571b6e-ad08-4040-a9a7-c30ed935d437");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetStructById_TypeGetStructDefByGuid_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasStructDef> response = await client.GetStructByIdAsync("f1571b6e-ad08-4040-a9a7-c30ed935d437");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetStructByName_TypeGetStructDefByName()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetStructByName("hive_order", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetStructByName_TypeGetStructDefByName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetStructByNameAsync("hive_order", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetStructByName_TypeGetStructDefByName_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasStructDef> response = client.GetStructByName("hive_order");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetStructByName_TypeGetStructDefByName_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasStructDef> response = await client.GetStructByNameAsync("hive_order");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetById_TypeGetByGuid()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetById("0ddc2fcf-ad17-4d06-984a-ffb2ffb2a941", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetById_TypeGetByGuid_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetByIdAsync("0ddc2fcf-ad17-4d06-984a-ffb2ffb2a941", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetById_TypeGetByGuid_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasTypeDef> response = client.GetById("0ddc2fcf-ad17-4d06-984a-ffb2ffb2a941");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetById_TypeGetByGuid_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasTypeDef> response = await client.GetByIdAsync("0ddc2fcf-ad17-4d06-984a-ffb2ffb2a941");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetByName_TypeGetByName()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetByName("glossary_term_status_value", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetByName_TypeGetByName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetByNameAsync("glossary_term_status_value", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetByName_TypeGetByName_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasTypeDef> response = client.GetByName("glossary_term_status_value");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetByName_TypeGetByName_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<AtlasTypeDef> response = await client.GetByNameAsync("glossary_term_status_value");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_Delete_TypeDelete()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.Delete("hive_order");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_Delete_TypeDelete_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.DeleteAsync("hive_order");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetTypeDefinition_TypeList()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response response = client.GetTypeDefinition(true, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetTypeDefinition_TypeList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response response = await client.GetTypeDefinitionAsync(true, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetTypeDefinition_TypeList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response<AtlasTypesDef> response = client.GetTypeDefinition();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetTypeDefinition_TypeList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response<AtlasTypesDef> response = await client.GetTypeDefinitionAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetTypeDefinition_TypeListEnumDefs()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response response = client.GetTypeDefinition(null, "ENUM", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetTypeDefinition_TypeListEnumDefs_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response response = await client.GetTypeDefinitionAsync(null, "ENUM", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetTypeDefinition_TypeListEnumDefs_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response<AtlasTypesDef> response = client.GetTypeDefinition();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetTypeDefinition_TypeListEnumDefs_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response<AtlasTypesDef> response = await client.GetTypeDefinitionAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetTypeDefinition_TypeListTermTemplateDefs()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response response = client.GetTypeDefinition(null, "TERM_TEMPLATE", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetTypeDefinition_TypeListTermTemplateDefs_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response response = await client.GetTypeDefinitionAsync(null, "TERM_TEMPLATE", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetTypeDefinition_TypeListTermTemplateDefs_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response<AtlasTypesDef> response = client.GetTypeDefinition();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetTypeDefinition_TypeListTermTemplateDefs_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response<AtlasTypesDef> response = await client.GetTypeDefinitionAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_BatchCreate_TypeBulkCreate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            using RequestContent content = RequestContent.Create(new
            {
                enumDefs = Array.Empty<object>(),
                structDefs = Array.Empty<object>(),
                classificationDefs = Array.Empty<object>(),
                entityDefs = new object[]
            {
new
{
name = "azure_sql_server_example",
superTypes = new object[]
{
"azure_resource"
},
typeVersion = "1.0",
attributeDefs = new object[]
{
new
{
name = "databases",
typeName = "array<azure_sql_db>",
cardinality = "SET",
isIndexable = false,
isOptional = true,
isUnique = false,
}
},
}
            },
                relationshipDefs = Array.Empty<object>(),
            });
            Response response = client.BatchCreate(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_BatchCreate_TypeBulkCreate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            using RequestContent content = RequestContent.Create(new
            {
                enumDefs = Array.Empty<object>(),
                structDefs = Array.Empty<object>(),
                classificationDefs = Array.Empty<object>(),
                entityDefs = new object[]
            {
new
{
name = "azure_sql_server_example",
superTypes = new object[]
{
"azure_resource"
},
typeVersion = "1.0",
attributeDefs = new object[]
{
new
{
name = "databases",
typeName = "array<azure_sql_db>",
cardinality = "SET",
isIndexable = false,
isOptional = true,
isUnique = false,
}
},
}
            },
                relationshipDefs = Array.Empty<object>(),
            });
            Response response = await client.BatchCreateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_BatchCreate_TypeBulkCreate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            AtlasTypesDef body = new AtlasTypesDef
            {
                ClassificationDefs = { },
                EntityDefs = {new AtlasEntityDef
{
Name = "azure_sql_server_example",
TypeVersion = "1.0",
AttributeDefs = {new AtlasAttributeDef
{
Cardinality = CardinalityValue.Set,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "databases",
TypeName = "array<azure_sql_db>",
}},
SuperTypes = {"azure_resource"},
}},
                EnumDefs = { },
                RelationshipDefs = { },
                StructDefs = { },
            };
            Response<AtlasTypesDef> response = client.BatchCreate(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_BatchCreate_TypeBulkCreate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            AtlasTypesDef body = new AtlasTypesDef
            {
                ClassificationDefs = { },
                EntityDefs = {new AtlasEntityDef
{
Name = "azure_sql_server_example",
TypeVersion = "1.0",
AttributeDefs = {new AtlasAttributeDef
{
Cardinality = CardinalityValue.Set,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "databases",
TypeName = "array<azure_sql_db>",
}},
SuperTypes = {"azure_resource"},
}},
                EnumDefs = { },
                RelationshipDefs = { },
                StructDefs = { },
            };
            Response<AtlasTypesDef> response = await client.BatchCreateAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_BatchCreate_TypeBulkCreateBusinessMetadataDefs()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            using RequestContent content = RequestContent.Create(new
            {
                enumDefs = Array.Empty<object>(),
                structDefs = Array.Empty<object>(),
                classificationDefs = Array.Empty<object>(),
                entityDefs = Array.Empty<object>(),
                relationshipDefs = Array.Empty<object>(),
                businessMetadataDefs = new object[]
            {
new
{
name = "myBizMetadata1",
description = "",
attributeDefs = new object[]
{
new
{
name = "bizAttr1",
typeName = "string",
isOptional = true,
cardinality = "SINGLE",
isUnique = false,
isIndexable = true,
options = new
{
maxStrLength = "50",
applicableEntityTypes = "[\"Path\"]",
},
}
},
}
            },
            });
            Response response = client.BatchCreate(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_BatchCreate_TypeBulkCreateBusinessMetadataDefs_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            using RequestContent content = RequestContent.Create(new
            {
                enumDefs = Array.Empty<object>(),
                structDefs = Array.Empty<object>(),
                classificationDefs = Array.Empty<object>(),
                entityDefs = Array.Empty<object>(),
                relationshipDefs = Array.Empty<object>(),
                businessMetadataDefs = new object[]
            {
new
{
name = "myBizMetadata1",
description = "",
attributeDefs = new object[]
{
new
{
name = "bizAttr1",
typeName = "string",
isOptional = true,
cardinality = "SINGLE",
isUnique = false,
isIndexable = true,
options = new
{
maxStrLength = "50",
applicableEntityTypes = "[\"Path\"]",
},
}
},
}
            },
            });
            Response response = await client.BatchCreateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_BatchCreate_TypeBulkCreateBusinessMetadataDefs_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            AtlasTypesDef body = new AtlasTypesDef
            {
                BusinessMetadataDefs = {new AtlasBusinessMetadataDef
{
Description = "",
Name = "myBizMetadata1",
AttributeDefs = {new AtlasAttributeDef
{
Cardinality = CardinalityValue.Single,
IsIndexable = true,
IsOptional = true,
IsUnique = false,
Name = "bizAttr1",
Options =
{
["maxStrLength"] = "50",
["applicableEntityTypes"] = "[\"Path\"]"
},
TypeName = "string",
}},
}},
                ClassificationDefs = { },
                EntityDefs = { },
                EnumDefs = { },
                RelationshipDefs = { },
                StructDefs = { },
            };
            Response<AtlasTypesDef> response = client.BatchCreate(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_BatchCreate_TypeBulkCreateBusinessMetadataDefs_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            AtlasTypesDef body = new AtlasTypesDef
            {
                BusinessMetadataDefs = {new AtlasBusinessMetadataDef
{
Description = "",
Name = "myBizMetadata1",
AttributeDefs = {new AtlasAttributeDef
{
Cardinality = CardinalityValue.Single,
IsIndexable = true,
IsOptional = true,
IsUnique = false,
Name = "bizAttr1",
Options =
{
["maxStrLength"] = "50",
["applicableEntityTypes"] = "[\"Path\"]"
},
TypeName = "string",
}},
}},
                ClassificationDefs = { },
                EntityDefs = { },
                EnumDefs = { },
                RelationshipDefs = { },
                StructDefs = { },
            };
            Response<AtlasTypesDef> response = await client.BatchCreateAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_BatchUpdate_TypeBulkUpdate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            using RequestContent content = RequestContent.Create(new
            {
                enumDefs = Array.Empty<object>(),
                structDefs = Array.Empty<object>(),
                classificationDefs = Array.Empty<object>(),
                entityDefs = new object[]
            {
new
{
name = "azure_sql_server",
superTypes = new object[]
{
"azure_resource"
},
typeVersion = "1.0",
attributeDefs = new object[]
{
new
{
name = "databases",
typeName = "array<azure_sql_db>",
cardinality = "SET",
isIndexable = false,
isOptional = true,
isUnique = false,
}
},
},
new
{
name = "azure_sql_db",
superTypes = new object[]
{
"azure_resource"
},
typeVersion = "1.0",
attributeDefs = new object[]
{
new
{
name = "server",
typeName = "azure_sql_server",
cardinality = "SINGLE",
constraints = new object[]
{
new Dictionary<string, object>
{
["type"] = "inverseRef",
["params"] = new
{
attribute = "databases",
}
}
},
isIndexable = false,
isOptional = false,
isUnique = false,
},
new
{
name = "schemas",
typeName = "array<azure_sql_schema>",
cardinality = "SET",
isIndexable = false,
isOptional = true,
isUnique = false,
},
new
{
name = "collation",
typeName = "string",
cardinality = "SINGLE",
isIndexable = false,
isOptional = true,
isUnique = false,
},
new
{
name = "compatibilityLevel",
typeName = "int",
cardinality = "SINGLE",
isIndexable = false,
isOptional = true,
isUnique = false,
}
},
}
            },
                relationshipDefs = new object[]
            {
new
{
name = "azure_sql_server_databases",
typeVersion = "1.0",
relationshipCategory = "COMPOSITION",
endDef1 = new
{
type = "azure_sql_server",
name = "databases",
isContainer = true,
cardinality = "SET",
isLegacyAttribute = true,
},
endDef2 = new
{
type = "azure_sql_db",
name = "server",
isContainer = false,
cardinality = "SINGLE",
isLegacyAttribute = true,
},
},
new
{
name = "azure_sql_db_schemas",
typeVersion = "1.0",
relationshipCategory = "COMPOSITION",
endDef1 = new
{
type = "azure_sql_db",
name = "schemas",
isContainer = true,
cardinality = "SET",
isLegacyAttribute = true,
},
endDef2 = new
{
type = "azure_sql_schema",
name = "db",
isContainer = false,
cardinality = "SINGLE",
isLegacyAttribute = true,
},
}
            },
            });
            Response response = client.BatchUpdate(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_BatchUpdate_TypeBulkUpdate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            using RequestContent content = RequestContent.Create(new
            {
                enumDefs = Array.Empty<object>(),
                structDefs = Array.Empty<object>(),
                classificationDefs = Array.Empty<object>(),
                entityDefs = new object[]
            {
new
{
name = "azure_sql_server",
superTypes = new object[]
{
"azure_resource"
},
typeVersion = "1.0",
attributeDefs = new object[]
{
new
{
name = "databases",
typeName = "array<azure_sql_db>",
cardinality = "SET",
isIndexable = false,
isOptional = true,
isUnique = false,
}
},
},
new
{
name = "azure_sql_db",
superTypes = new object[]
{
"azure_resource"
},
typeVersion = "1.0",
attributeDefs = new object[]
{
new
{
name = "server",
typeName = "azure_sql_server",
cardinality = "SINGLE",
constraints = new object[]
{
new Dictionary<string, object>
{
["type"] = "inverseRef",
["params"] = new
{
attribute = "databases",
}
}
},
isIndexable = false,
isOptional = false,
isUnique = false,
},
new
{
name = "schemas",
typeName = "array<azure_sql_schema>",
cardinality = "SET",
isIndexable = false,
isOptional = true,
isUnique = false,
},
new
{
name = "collation",
typeName = "string",
cardinality = "SINGLE",
isIndexable = false,
isOptional = true,
isUnique = false,
},
new
{
name = "compatibilityLevel",
typeName = "int",
cardinality = "SINGLE",
isIndexable = false,
isOptional = true,
isUnique = false,
}
},
}
            },
                relationshipDefs = new object[]
            {
new
{
name = "azure_sql_server_databases",
typeVersion = "1.0",
relationshipCategory = "COMPOSITION",
endDef1 = new
{
type = "azure_sql_server",
name = "databases",
isContainer = true,
cardinality = "SET",
isLegacyAttribute = true,
},
endDef2 = new
{
type = "azure_sql_db",
name = "server",
isContainer = false,
cardinality = "SINGLE",
isLegacyAttribute = true,
},
},
new
{
name = "azure_sql_db_schemas",
typeVersion = "1.0",
relationshipCategory = "COMPOSITION",
endDef1 = new
{
type = "azure_sql_db",
name = "schemas",
isContainer = true,
cardinality = "SET",
isLegacyAttribute = true,
},
endDef2 = new
{
type = "azure_sql_schema",
name = "db",
isContainer = false,
cardinality = "SINGLE",
isLegacyAttribute = true,
},
}
            },
            });
            Response response = await client.BatchUpdateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_BatchUpdate_TypeBulkUpdate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            AtlasTypesDef body = new AtlasTypesDef
            {
                ClassificationDefs = { },
                EntityDefs = {new AtlasEntityDef
{
Name = "azure_sql_server",
TypeVersion = "1.0",
AttributeDefs = {new AtlasAttributeDef
{
Cardinality = CardinalityValue.Set,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "databases",
TypeName = "array<azure_sql_db>",
}},
SuperTypes = {"azure_resource"},
}, new AtlasEntityDef
{
Name = "azure_sql_db",
TypeVersion = "1.0",
AttributeDefs = {new AtlasAttributeDef
{
Cardinality = CardinalityValue.Single,
Constraints = {new AtlasConstraintDef
{
Params =
{
["attribute"] = BinaryData.FromObjectAsJson("databases")
},
Type = "inverseRef",
}},
IsIndexable = false,
IsOptional = false,
IsUnique = false,
Name = "server",
TypeName = "azure_sql_server",
}, new AtlasAttributeDef
{
Cardinality = CardinalityValue.Set,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "schemas",
TypeName = "array<azure_sql_schema>",
}, new AtlasAttributeDef
{
Cardinality = CardinalityValue.Single,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "collation",
TypeName = "string",
}, new AtlasAttributeDef
{
Cardinality = CardinalityValue.Single,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "compatibilityLevel",
TypeName = "int",
}},
SuperTypes = {"azure_resource"},
}},
                EnumDefs = { },
                RelationshipDefs = {new AtlasRelationshipDef
{
Name = "azure_sql_server_databases",
TypeVersion = "1.0",
EndDef1 = new AtlasRelationshipEndDef
{
Cardinality = CardinalityValue.Set,
IsContainer = true,
IsLegacyAttribute = true,
Name = "databases",
Type = "azure_sql_server",
},
EndDef2 = new AtlasRelationshipEndDef
{
Cardinality = CardinalityValue.Single,
IsContainer = false,
IsLegacyAttribute = true,
Name = "server",
Type = "azure_sql_db",
},
RelationshipCategory = RelationshipCategory.Composition,
}, new AtlasRelationshipDef
{
Name = "azure_sql_db_schemas",
TypeVersion = "1.0",
EndDef1 = new AtlasRelationshipEndDef
{
Cardinality = CardinalityValue.Set,
IsContainer = true,
IsLegacyAttribute = true,
Name = "schemas",
Type = "azure_sql_db",
},
EndDef2 = new AtlasRelationshipEndDef
{
Cardinality = CardinalityValue.Single,
IsContainer = false,
IsLegacyAttribute = true,
Name = "db",
Type = "azure_sql_schema",
},
RelationshipCategory = RelationshipCategory.Composition,
}},
                StructDefs = { },
            };
            Response<AtlasTypesDef> response = client.BatchUpdate(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_BatchUpdate_TypeBulkUpdate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            AtlasTypesDef body = new AtlasTypesDef
            {
                ClassificationDefs = { },
                EntityDefs = {new AtlasEntityDef
{
Name = "azure_sql_server",
TypeVersion = "1.0",
AttributeDefs = {new AtlasAttributeDef
{
Cardinality = CardinalityValue.Set,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "databases",
TypeName = "array<azure_sql_db>",
}},
SuperTypes = {"azure_resource"},
}, new AtlasEntityDef
{
Name = "azure_sql_db",
TypeVersion = "1.0",
AttributeDefs = {new AtlasAttributeDef
{
Cardinality = CardinalityValue.Single,
Constraints = {new AtlasConstraintDef
{
Params =
{
["attribute"] = BinaryData.FromObjectAsJson("databases")
},
Type = "inverseRef",
}},
IsIndexable = false,
IsOptional = false,
IsUnique = false,
Name = "server",
TypeName = "azure_sql_server",
}, new AtlasAttributeDef
{
Cardinality = CardinalityValue.Set,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "schemas",
TypeName = "array<azure_sql_schema>",
}, new AtlasAttributeDef
{
Cardinality = CardinalityValue.Single,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "collation",
TypeName = "string",
}, new AtlasAttributeDef
{
Cardinality = CardinalityValue.Single,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "compatibilityLevel",
TypeName = "int",
}},
SuperTypes = {"azure_resource"},
}},
                EnumDefs = { },
                RelationshipDefs = {new AtlasRelationshipDef
{
Name = "azure_sql_server_databases",
TypeVersion = "1.0",
EndDef1 = new AtlasRelationshipEndDef
{
Cardinality = CardinalityValue.Set,
IsContainer = true,
IsLegacyAttribute = true,
Name = "databases",
Type = "azure_sql_server",
},
EndDef2 = new AtlasRelationshipEndDef
{
Cardinality = CardinalityValue.Single,
IsContainer = false,
IsLegacyAttribute = true,
Name = "server",
Type = "azure_sql_db",
},
RelationshipCategory = RelationshipCategory.Composition,
}, new AtlasRelationshipDef
{
Name = "azure_sql_db_schemas",
TypeVersion = "1.0",
EndDef1 = new AtlasRelationshipEndDef
{
Cardinality = CardinalityValue.Set,
IsContainer = true,
IsLegacyAttribute = true,
Name = "schemas",
Type = "azure_sql_db",
},
EndDef2 = new AtlasRelationshipEndDef
{
Cardinality = CardinalityValue.Single,
IsContainer = false,
IsLegacyAttribute = true,
Name = "db",
Type = "azure_sql_schema",
},
RelationshipCategory = RelationshipCategory.Composition,
}},
                StructDefs = { },
            };
            Response<AtlasTypesDef> response = await client.BatchUpdateAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_BatchDelete_TypeBulkDelete()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            using RequestContent content = RequestContent.Create(new
            {
                enumDefs = Array.Empty<object>(),
                structDefs = Array.Empty<object>(),
                classificationDefs = Array.Empty<object>(),
                entityDefs = new object[]
            {
new
{
name = "azure_sql_server_example",
superTypes = new object[]
{
"azure_resource"
},
typeVersion = "1.0",
attributeDefs = new object[]
{
new
{
name = "databases",
typeName = "array<azure_sql_db>",
cardinality = "SET",
isIndexable = false,
isOptional = true,
isUnique = false,
}
},
}
            },
                relationshipDefs = Array.Empty<object>(),
            });
            Response response = client.BatchDelete(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_BatchDelete_TypeBulkDelete_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            using RequestContent content = RequestContent.Create(new
            {
                enumDefs = Array.Empty<object>(),
                structDefs = Array.Empty<object>(),
                classificationDefs = Array.Empty<object>(),
                entityDefs = new object[]
            {
new
{
name = "azure_sql_server_example",
superTypes = new object[]
{
"azure_resource"
},
typeVersion = "1.0",
attributeDefs = new object[]
{
new
{
name = "databases",
typeName = "array<azure_sql_db>",
cardinality = "SET",
isIndexable = false,
isOptional = true,
isUnique = false,
}
},
}
            },
                relationshipDefs = Array.Empty<object>(),
            });
            Response response = await client.BatchDeleteAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_BatchDelete_TypeBulkDelete_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            AtlasTypesDef body = new AtlasTypesDef
            {
                ClassificationDefs = { },
                EntityDefs = {new AtlasEntityDef
{
Name = "azure_sql_server_example",
TypeVersion = "1.0",
AttributeDefs = {new AtlasAttributeDef
{
Cardinality = CardinalityValue.Set,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "databases",
TypeName = "array<azure_sql_db>",
}},
SuperTypes = {"azure_resource"},
}},
                EnumDefs = { },
                RelationshipDefs = { },
                StructDefs = { },
            };
            Response response = client.BatchDelete(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_BatchDelete_TypeBulkDelete_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            AtlasTypesDef body = new AtlasTypesDef
            {
                ClassificationDefs = { },
                EntityDefs = {new AtlasEntityDef
{
Name = "azure_sql_server_example",
TypeVersion = "1.0",
AttributeDefs = {new AtlasAttributeDef
{
Cardinality = CardinalityValue.Set,
IsIndexable = false,
IsOptional = true,
IsUnique = false,
Name = "databases",
TypeName = "array<azure_sql_db>",
}},
SuperTypes = {"azure_resource"},
}},
                EnumDefs = { },
                RelationshipDefs = { },
                StructDefs = { },
            };
            Response response = await client.BatchDeleteAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetHeaders_TypeListHeaders()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = client.GetHeaders(true, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetHeaders_TypeListHeaders_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response response = await client.GetHeadersAsync(true, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetHeaders_TypeListHeaders_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<IReadOnlyList<AtlasTypeDefHeader>> response = client.GetHeaders();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetHeaders_TypeListHeaders_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient();

            Response<IReadOnlyList<AtlasTypeDefHeader>> response = await client.GetHeadersAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetTermTemplateById_TypeGetTermTemplateDefByGuid()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response response = client.GetTermTemplateById("d776af9c-985c-4168-abb2-477523dbfc70", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetTermTemplateById_TypeGetTermTemplateDefByGuid_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response response = await client.GetTermTemplateByIdAsync("d776af9c-985c-4168-abb2-477523dbfc70", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetTermTemplateById_TypeGetTermTemplateDefByGuid_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response<TermTemplateDef> response = client.GetTermTemplateById("d776af9c-985c-4168-abb2-477523dbfc70");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetTermTemplateById_TypeGetTermTemplateDefByGuid_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response<TermTemplateDef> response = await client.GetTermTemplateByIdAsync("d776af9c-985c-4168-abb2-477523dbfc70");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetTermTemplateByName_TypeGetTermTemplateDefByName()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response response = client.GetTermTemplateByName("MS KPI", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetTermTemplateByName_TypeGetTermTemplateDefByName_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response response = await client.GetTermTemplateByNameAsync("MS KPI", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_TypeDefinition_GetTermTemplateByName_TypeGetTermTemplateDefByName_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response<TermTemplateDef> response = client.GetTermTemplateByName("MS KPI");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_TypeDefinition_GetTermTemplateByName_TypeGetTermTemplateDefByName_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            TypeDefinition client = new DataMapClient(endpoint, credential).GetTypeDefinitionClient(apiVersion: "2023-09-01");

            Response<TermTemplateDef> response = await client.GetTermTemplateByNameAsync("MS KPI");
        }
    }
}
