// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.DataMap.Samples
{
    public partial class Samples_Lineage
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Lineage_GetLineage_LineageGet()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient();

            Response response = client.GetLineage("a6894eb3-81f3-829b-2adc-52f3e603411a", "INPUT");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Lineage_GetLineage_LineageGet_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient();

            Response response = await client.GetLineageAsync("a6894eb3-81f3-829b-2adc-52f3e603411a", "INPUT");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Lineage_GetLineage_LineageGet_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient();

            Response<AtlasLineageInfo> response = client.GetLineage("a6894eb3-81f3-829b-2adc-52f3e603411a", LineageDirection.Input);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Lineage_GetLineage_LineageGet_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient();

            Response<AtlasLineageInfo> response = await client.GetLineageAsync("a6894eb3-81f3-829b-2adc-52f3e603411a", LineageDirection.Input);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Lineage_GetNextPage_LineageGetNextPage()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient(apiVersion: "2023-09-01");

            Response response = client.GetNextPage("a6894eb3-81f3-829b-2adc-52f3e603411a", "INPUT");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Lineage_GetNextPage_LineageGetNextPage_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient(apiVersion: "2023-09-01");

            Response response = await client.GetNextPageAsync("a6894eb3-81f3-829b-2adc-52f3e603411a", "INPUT");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Lineage_GetNextPage_LineageGetNextPage_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient(apiVersion: "2023-09-01");

            Response<AtlasLineageInfo> response = client.GetNextPage("a6894eb3-81f3-829b-2adc-52f3e603411a", LineageDirection.Input);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Lineage_GetNextPage_LineageGetNextPage_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient(apiVersion: "2023-09-01");

            Response<AtlasLineageInfo> response = await client.GetNextPageAsync("a6894eb3-81f3-829b-2adc-52f3e603411a", LineageDirection.Input);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Lineage_GetByUniqueAttribute_LineageGetByUniqueAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient();

            Response response = client.GetByUniqueAttribute("azure_blob_path", "BOTH");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Lineage_GetByUniqueAttribute_LineageGetByUniqueAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient();

            Response response = await client.GetByUniqueAttributeAsync("azure_blob_path", "BOTH");

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Lineage_GetByUniqueAttribute_LineageGetByUniqueAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient();

            Response<AtlasLineageInfo> response = client.GetByUniqueAttribute("azure_blob_path", LineageDirection.Both);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Lineage_GetByUniqueAttribute_LineageGetByUniqueAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Lineage client = new DataMapClient(endpoint, credential).GetLineageClient();

            Response<AtlasLineageInfo> response = await client.GetByUniqueAttributeAsync("azure_blob_path", LineageDirection.Both);
        }
    }
}
