// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.DataMap.Samples
{
    public partial class Samples_Glossary
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_BatchGet_GlossaryList()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.BatchGet(null, null, "ASC", null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_BatchGet_GlossaryList_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.BatchGetAsync(null, null, "ASC", null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_BatchGet_GlossaryList_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasGlossary>> response = client.BatchGet();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_BatchGet_GlossaryList_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasGlossary>> response = await client.BatchGetAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_Create_GlossaryCreate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                name = "Glossary",
                shortDescription = "Example Short Description",
                longDescription = "Example Long Description",
                language = "en",
                usage = "Example Glossary",
            });
            Response response = client.Create(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_Create_GlossaryCreate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                name = "Glossary",
                shortDescription = "Example Short Description",
                longDescription = "Example Long Description",
                language = "en",
                usage = "Example Glossary",
            });
            Response response = await client.CreateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_Create_GlossaryCreate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossary body = new AtlasGlossary
            {
                LongDescription = "Example Long Description",
                Name = "Glossary",
                ShortDescription = "Example Short Description",
                Language = "en",
                Usage = "Example Glossary",
            };
            Response<AtlasGlossary> response = client.Create(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_Create_GlossaryCreate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossary body = new AtlasGlossary
            {
                LongDescription = "Example Long Description",
                Name = "Glossary",
                ShortDescription = "Example Short Description",
                Language = "en",
                Usage = "Example Glossary",
            };
            Response<AtlasGlossary> response = await client.CreateAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_CreateCategories_GlossaryCreateCategories()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
name = "ExampleCategory2",
anchor = new
{
glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
},
new
{
name = "ExampleCategory3",
anchor = new
{
glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
}
            });
            Response response = client.CreateCategories(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_CreateCategories_GlossaryCreateCategories_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
name = "ExampleCategory2",
anchor = new
{
glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
},
new
{
name = "ExampleCategory3",
anchor = new
{
glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
}
            });
            Response response = await client.CreateCategoriesAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_CreateCategories_GlossaryCreateCategories_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasGlossaryCategory>> response = client.CreateCategories(new AtlasGlossaryCategory[]
            {
new AtlasGlossaryCategory
{
Name = "ExampleCategory2",
Anchor = new AtlasGlossaryHeader
{
GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
},
new AtlasGlossaryCategory
{
Name = "ExampleCategory3",
Anchor = new AtlasGlossaryHeader
{
GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_CreateCategories_GlossaryCreateCategories_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasGlossaryCategory>> response = await client.CreateCategoriesAsync(new AtlasGlossaryCategory[]
            {
new AtlasGlossaryCategory
{
Name = "ExampleCategory2",
Anchor = new AtlasGlossaryHeader
{
GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
},
new AtlasGlossaryCategory
{
Name = "ExampleCategory3",
Anchor = new AtlasGlossaryHeader
{
GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_CreateCategory_GlossaryCreateCategory()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                anchor = new
                {
                    glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                name = "ExampleCategory1",
                terms = new object[]
            {
new
{
termGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
}
            },
            });
            Response response = client.CreateCategory(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_CreateCategory_GlossaryCreateCategory_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                anchor = new
                {
                    glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                name = "ExampleCategory1",
                terms = new object[]
            {
new
{
termGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
}
            },
            });
            Response response = await client.CreateCategoryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_CreateCategory_GlossaryCreateCategory_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossaryCategory body = new AtlasGlossaryCategory
            {
                Name = "ExampleCategory1",
                Anchor = new AtlasGlossaryHeader
                {
                    GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                Terms = {new AtlasRelatedTermHeader
{
TermGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
}},
            };
            Response<AtlasGlossaryCategory> response = client.CreateCategory(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_CreateCategory_GlossaryCreateCategory_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossaryCategory body = new AtlasGlossaryCategory
            {
                Name = "ExampleCategory1",
                Anchor = new AtlasGlossaryHeader
                {
                    GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                Terms = {new AtlasRelatedTermHeader
{
TermGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
}},
            };
            Response<AtlasGlossaryCategory> response = await client.CreateCategoryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetCategory_GlossaryGetCategory()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetCategory("ed7458f0-9463-48a5-b5c6-4f785fb34e12", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetCategory_GlossaryGetCategory_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetCategoryAsync("ed7458f0-9463-48a5-b5c6-4f785fb34e12", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetCategory_GlossaryGetCategory_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryCategory> response = client.GetCategory("ed7458f0-9463-48a5-b5c6-4f785fb34e12");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetCategory_GlossaryGetCategory_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryCategory> response = await client.GetCategoryAsync("ed7458f0-9463-48a5-b5c6-4f785fb34e12");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_UpdateCategory_GlossaryUpdateCategory()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                guid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
                qualifiedName = "ExampleCategory1@Glossary",
                name = "ExampleCategory1",
                lastModifiedTS = "1",
                anchor = new
                {
                    glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                    relationGuid = "7bdcef93-a57a-4d1d-95ab-9d3036f394a0",
                },
                terms = new object[]
            {
new
{
termGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
relationGuid = "6aebf5ac-0c83-40c0-98bf-958fe9c99007",
}
            },
                childrenCategories = new object[]
            {
new
{
categoryGuid = "0d6766f6-f4b6-435b-bda2-d3edc358998e",
}
            },
                parentCategory = new
                {
                    categoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
                },
            });
            Response response = client.UpdateCategory("ed7458f0-9463-48a5-b5c6-4f785fb34e12", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_UpdateCategory_GlossaryUpdateCategory_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                guid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
                qualifiedName = "ExampleCategory1@Glossary",
                name = "ExampleCategory1",
                lastModifiedTS = "1",
                anchor = new
                {
                    glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                    relationGuid = "7bdcef93-a57a-4d1d-95ab-9d3036f394a0",
                },
                terms = new object[]
            {
new
{
termGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
relationGuid = "6aebf5ac-0c83-40c0-98bf-958fe9c99007",
}
            },
                childrenCategories = new object[]
            {
new
{
categoryGuid = "0d6766f6-f4b6-435b-bda2-d3edc358998e",
}
            },
                parentCategory = new
                {
                    categoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
                },
            });
            Response response = await client.UpdateCategoryAsync("ed7458f0-9463-48a5-b5c6-4f785fb34e12", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_UpdateCategory_GlossaryUpdateCategory_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossaryCategory body = new AtlasGlossaryCategory
            {
                Guid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
                Name = "ExampleCategory1",
                QualifiedName = "ExampleCategory1@Glossary",
                LastModifiedTS = "1",
                Anchor = new AtlasGlossaryHeader
                {
                    GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                    RelationGuid = "7bdcef93-a57a-4d1d-95ab-9d3036f394a0",
                },
                ChildrenCategories = {new AtlasRelatedCategoryHeader
{
CategoryGuid = "0d6766f6-f4b6-435b-bda2-d3edc358998e",
}},
                ParentCategory = new AtlasRelatedCategoryHeader
                {
                    CategoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
                },
                Terms = {new AtlasRelatedTermHeader
{
RelationGuid = "6aebf5ac-0c83-40c0-98bf-958fe9c99007",
TermGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
}},
            };
            Response<AtlasGlossaryCategory> response = client.UpdateCategory("ed7458f0-9463-48a5-b5c6-4f785fb34e12", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_UpdateCategory_GlossaryUpdateCategory_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossaryCategory body = new AtlasGlossaryCategory
            {
                Guid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
                Name = "ExampleCategory1",
                QualifiedName = "ExampleCategory1@Glossary",
                LastModifiedTS = "1",
                Anchor = new AtlasGlossaryHeader
                {
                    GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                    RelationGuid = "7bdcef93-a57a-4d1d-95ab-9d3036f394a0",
                },
                ChildrenCategories = {new AtlasRelatedCategoryHeader
{
CategoryGuid = "0d6766f6-f4b6-435b-bda2-d3edc358998e",
}},
                ParentCategory = new AtlasRelatedCategoryHeader
                {
                    CategoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
                },
                Terms = {new AtlasRelatedTermHeader
{
RelationGuid = "6aebf5ac-0c83-40c0-98bf-958fe9c99007",
TermGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
}},
            };
            Response<AtlasGlossaryCategory> response = await client.UpdateCategoryAsync("ed7458f0-9463-48a5-b5c6-4f785fb34e12", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_DeleteCategory_GlossaryDeleteCategory()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.DeleteCategory("0e391355-252a-e5f3-ac18-5a3602df7616");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_DeleteCategory_GlossaryDeleteCategory_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.DeleteCategoryAsync("0e391355-252a-e5f3-ac18-5a3602df7616");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_PartialUpdateCategory_GlossaryPartialUpdateCategory()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                longDescription = "Example Long Description",
            });
            Response response = client.PartialUpdateCategory("3243ea0a-9492-47e1-392e-a84e64980af9", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_PartialUpdateCategory_GlossaryPartialUpdateCategory_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                longDescription = "Example Long Description",
            });
            Response response = await client.PartialUpdateCategoryAsync("3243ea0a-9492-47e1-392e-a84e64980af9", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_PartialUpdateCategory_GlossaryPartialUpdateCategory_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryCategory> response = client.PartialUpdateCategory("3243ea0a-9492-47e1-392e-a84e64980af9", new Dictionary<string, string>
            {
                ["longDescription"] = "Example Long Description"
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_PartialUpdateCategory_GlossaryPartialUpdateCategory_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryCategory> response = await client.PartialUpdateCategoryAsync("3243ea0a-9492-47e1-392e-a84e64980af9", new Dictionary<string, string>
            {
                ["longDescription"] = "Example Long Description"
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetRelatedCategories_GlossaryListRelatedCategories()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetRelatedCategories("ed7458f0-9463-48a5-b5c6-4f785fb34e12", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetRelatedCategories_GlossaryListRelatedCategories_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetRelatedCategoriesAsync("ed7458f0-9463-48a5-b5c6-4f785fb34e12", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetRelatedCategories_GlossaryListRelatedCategories_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyDictionary<string, IList<AtlasRelatedCategoryHeader>>> response = client.GetRelatedCategories("ed7458f0-9463-48a5-b5c6-4f785fb34e12");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetRelatedCategories_GlossaryListRelatedCategories_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyDictionary<string, IList<AtlasRelatedCategoryHeader>>> response = await client.GetRelatedCategoriesAsync("ed7458f0-9463-48a5-b5c6-4f785fb34e12");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetCategoryTerms_GlossaryListCategoryTerms()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetCategoryTerms("ed7458f0-9463-48a5-b5c6-4f785fb34e12", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetCategoryTerms_GlossaryListCategoryTerms_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetCategoryTermsAsync("ed7458f0-9463-48a5-b5c6-4f785fb34e12", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetCategoryTerms_GlossaryListCategoryTerms_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasRelatedTermHeader>> response = client.GetCategoryTerms("ed7458f0-9463-48a5-b5c6-4f785fb34e12");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetCategoryTerms_GlossaryListCategoryTerms_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasRelatedTermHeader>> response = await client.GetCategoryTermsAsync("ed7458f0-9463-48a5-b5c6-4f785fb34e12");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_CreateTerm_GlossaryCreateTerm()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                name = "ExampleTerm1",
                shortDescription = "Example Short Description",
                longDescription = "Example Long Description",
                abbreviation = "T1",
                status = "Approved",
                anchor = new
                {
                    glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                resources = new object[]
            {
new
{
displayName = "Example Display Name",
url = "Example Url",
}
            },
                contacts = new
                {
                    Expert = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Expert Info",
}
            },
                    Steward = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Steward info",
}
            },
                },
            });
            Response response = client.CreateTerm(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_CreateTerm_GlossaryCreateTerm_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                name = "ExampleTerm1",
                shortDescription = "Example Short Description",
                longDescription = "Example Long Description",
                abbreviation = "T1",
                status = "Approved",
                anchor = new
                {
                    glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                resources = new object[]
            {
new
{
displayName = "Example Display Name",
url = "Example Url",
}
            },
                contacts = new
                {
                    Expert = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Expert Info",
}
            },
                    Steward = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Steward info",
}
            },
                },
            });
            Response response = await client.CreateTermAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_CreateTerm_GlossaryCreateTerm_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossaryTerm body = new AtlasGlossaryTerm
            {
                LongDescription = "Example Long Description",
                Name = "ExampleTerm1",
                ShortDescription = "Example Short Description",
                Abbreviation = "T1",
                Anchor = new AtlasGlossaryHeader
                {
                    GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                Status = TermStatus.Approved,
                Resources = {new ResourceLink
{
DisplayName = "Example Display Name",
Url = "Example Url",
}},
                Contacts =
{
["Expert"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Expert Info",
}},
["Steward"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Steward info",
}}
},
            };
            Response<AtlasGlossaryTerm> response = client.CreateTerm(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_CreateTerm_GlossaryCreateTerm_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossaryTerm body = new AtlasGlossaryTerm
            {
                LongDescription = "Example Long Description",
                Name = "ExampleTerm1",
                ShortDescription = "Example Short Description",
                Abbreviation = "T1",
                Anchor = new AtlasGlossaryHeader
                {
                    GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                Status = TermStatus.Approved,
                Resources = {new ResourceLink
{
DisplayName = "Example Display Name",
Url = "Example Url",
}},
                Contacts =
{
["Expert"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Expert Info",
}},
["Steward"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Steward info",
}}
},
            };
            Response<AtlasGlossaryTerm> response = await client.CreateTermAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_CreateTerm_GlossaryCreateTermWithTemplate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                name = "ExampleTerm",
                anchor = new
                {
                    glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                attributes = new
                {
                    ExampleTermTemplateAttribute = new Dictionary<string, object>
                    {
                        ["plain string"] = "Example String",
                        ["date"] = 1606233600000L,
                        ["single choice"] = "Example Single Choice A",
                        ["multi choice"] = new object[]
            {
"Example Multi Choice A",
"Example Multi Choice B"
            }
                    },
                },
            });
            Response response = client.CreateTerm(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_CreateTerm_GlossaryCreateTermWithTemplate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                name = "ExampleTerm",
                anchor = new
                {
                    glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                attributes = new
                {
                    ExampleTermTemplateAttribute = new Dictionary<string, object>
                    {
                        ["plain string"] = "Example String",
                        ["date"] = 1606233600000L,
                        ["single choice"] = "Example Single Choice A",
                        ["multi choice"] = new object[]
            {
"Example Multi Choice A",
"Example Multi Choice B"
            }
                    },
                },
            });
            Response response = await client.CreateTermAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_CreateTerm_GlossaryCreateTermWithTemplate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossaryTerm body = new AtlasGlossaryTerm
            {
                Name = "ExampleTerm",
                Anchor = new AtlasGlossaryHeader
                {
                    GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                Attributes =
{
["ExampleTermTemplateAttribute"] =
{
["plain string"] = BinaryData.FromObjectAsJson("Example String"),
["date"] = BinaryData.FromObjectAsJson(1606233600000L),
["single choice"] = BinaryData.FromObjectAsJson("Example Single Choice A"),
["multi choice"] = BinaryData.FromObjectAsJson(new object[]
{
"Example Multi Choice A",
"Example Multi Choice B"
})
}
},
            };
            Response<AtlasGlossaryTerm> response = client.CreateTerm(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_CreateTerm_GlossaryCreateTermWithTemplate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossaryTerm body = new AtlasGlossaryTerm
            {
                Name = "ExampleTerm",
                Anchor = new AtlasGlossaryHeader
                {
                    GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                },
                Attributes =
{
["ExampleTermTemplateAttribute"] =
{
["plain string"] = BinaryData.FromObjectAsJson("Example String"),
["date"] = BinaryData.FromObjectAsJson(1606233600000L),
["single choice"] = BinaryData.FromObjectAsJson("Example Single Choice A"),
["multi choice"] = BinaryData.FromObjectAsJson(new object[]
{
"Example Multi Choice A",
"Example Multi Choice B"
})
}
},
            };
            Response<AtlasGlossaryTerm> response = await client.CreateTermAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetTerm_GlossaryGetTerm()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetTerm("54688d39-b298-4104-9e80-f2a16f44aaea", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetTerm_GlossaryGetTerm_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetTermAsync("54688d39-b298-4104-9e80-f2a16f44aaea", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetTerm_GlossaryGetTerm_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryTerm> response = client.GetTerm("54688d39-b298-4104-9e80-f2a16f44aaea");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetTerm_GlossaryGetTerm_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryTerm> response = await client.GetTermAsync("54688d39-b298-4104-9e80-f2a16f44aaea");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetTerm_GlossaryGetTermWithoutAssets()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetTerm("54688d39-b298-4104-9e80-f2a16f44aaea", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetTerm_GlossaryGetTermWithoutAssets_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetTermAsync("54688d39-b298-4104-9e80-f2a16f44aaea", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetTerm_GlossaryGetTermWithoutAssets_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryTerm> response = client.GetTerm("54688d39-b298-4104-9e80-f2a16f44aaea");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetTerm_GlossaryGetTermWithoutAssets_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryTerm> response = await client.GetTermAsync("54688d39-b298-4104-9e80-f2a16f44aaea");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_UpdateTerm_GlossaryUpdateTerm()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                guid = "54688d39-b298-4104-9e80-f2a16f44aaea",
                qualifiedName = "ExampleTerm1@Glossary",
                name = "ExampleTerm1",
                shortDescription = "Example Short Description",
                lastModifiedTS = "1",
                abbreviation = "T1",
                status = "Approved",
                anchor = new
                {
                    glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                    relationGuid = "7b6a8149-a928-476a-a068-dce58653cfa0",
                },
                resources = new object[]
            {
new
{
displayName = "Example Display Name",
url = "Example Url",
}
            },
                seeAlso = new object[]
            {
new
{
termGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
},
new
{
termGuid = "821beef0-ced9-47ba-8f7f-c4f3459f4d18",
}
            },
                synonyms = new object[]
            {
new
{
termGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
},
new
{
termGuid = "821beef0-ced9-47ba-8f7f-c4f3459f4d18",
}
            },
            });
            Response response = client.UpdateTerm("54688d39-b298-4104-9e80-f2a16f44aaea", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_UpdateTerm_GlossaryUpdateTerm_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                guid = "54688d39-b298-4104-9e80-f2a16f44aaea",
                qualifiedName = "ExampleTerm1@Glossary",
                name = "ExampleTerm1",
                shortDescription = "Example Short Description",
                lastModifiedTS = "1",
                abbreviation = "T1",
                status = "Approved",
                anchor = new
                {
                    glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                    relationGuid = "7b6a8149-a928-476a-a068-dce58653cfa0",
                },
                resources = new object[]
            {
new
{
displayName = "Example Display Name",
url = "Example Url",
}
            },
                seeAlso = new object[]
            {
new
{
termGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
},
new
{
termGuid = "821beef0-ced9-47ba-8f7f-c4f3459f4d18",
}
            },
                synonyms = new object[]
            {
new
{
termGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
},
new
{
termGuid = "821beef0-ced9-47ba-8f7f-c4f3459f4d18",
}
            },
            });
            Response response = await client.UpdateTermAsync("54688d39-b298-4104-9e80-f2a16f44aaea", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_UpdateTerm_GlossaryUpdateTerm_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossaryTerm body = new AtlasGlossaryTerm
            {
                Guid = "54688d39-b298-4104-9e80-f2a16f44aaea",
                Name = "ExampleTerm1",
                QualifiedName = "ExampleTerm1@Glossary",
                ShortDescription = "Example Short Description",
                LastModifiedTS = "1",
                Abbreviation = "T1",
                Anchor = new AtlasGlossaryHeader
                {
                    GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                    RelationGuid = "7b6a8149-a928-476a-a068-dce58653cfa0",
                },
                Status = TermStatus.Approved,
                Resources = {new ResourceLink
{
DisplayName = "Example Display Name",
Url = "Example Url",
}},
                SeeAlso = {new AtlasRelatedTermHeader
{
TermGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
}, new AtlasRelatedTermHeader
{
TermGuid = "821beef0-ced9-47ba-8f7f-c4f3459f4d18",
}},
                Synonyms = {new AtlasRelatedTermHeader
{
TermGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
}, new AtlasRelatedTermHeader
{
TermGuid = "821beef0-ced9-47ba-8f7f-c4f3459f4d18",
}},
            };
            Response<AtlasGlossaryTerm> response = client.UpdateTerm("54688d39-b298-4104-9e80-f2a16f44aaea", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_UpdateTerm_GlossaryUpdateTerm_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossaryTerm body = new AtlasGlossaryTerm
            {
                Guid = "54688d39-b298-4104-9e80-f2a16f44aaea",
                Name = "ExampleTerm1",
                QualifiedName = "ExampleTerm1@Glossary",
                ShortDescription = "Example Short Description",
                LastModifiedTS = "1",
                Abbreviation = "T1",
                Anchor = new AtlasGlossaryHeader
                {
                    GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                    RelationGuid = "7b6a8149-a928-476a-a068-dce58653cfa0",
                },
                Status = TermStatus.Approved,
                Resources = {new ResourceLink
{
DisplayName = "Example Display Name",
Url = "Example Url",
}},
                SeeAlso = {new AtlasRelatedTermHeader
{
TermGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
}, new AtlasRelatedTermHeader
{
TermGuid = "821beef0-ced9-47ba-8f7f-c4f3459f4d18",
}},
                Synonyms = {new AtlasRelatedTermHeader
{
TermGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
}, new AtlasRelatedTermHeader
{
TermGuid = "821beef0-ced9-47ba-8f7f-c4f3459f4d18",
}},
            };
            Response<AtlasGlossaryTerm> response = await client.UpdateTermAsync("54688d39-b298-4104-9e80-f2a16f44aaea", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_DeleteTerm_GlossaryDeleteTerm()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.DeleteTerm("b0942506-2d7d-1f45-d286-c29ca9e7f2ef");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_DeleteTerm_GlossaryDeleteTerm_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.DeleteTermAsync("b0942506-2d7d-1f45-d286-c29ca9e7f2ef");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_PartialUpdateTerm_GlossaryPartialUpdateTerm()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                longDescription = "Example Long Description",
            });
            Response response = client.PartialUpdateTerm("54688d39-b298-4104-9e80-f2a16f44aaea", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_PartialUpdateTerm_GlossaryPartialUpdateTerm_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                longDescription = "Example Long Description",
            });
            Response response = await client.PartialUpdateTermAsync("54688d39-b298-4104-9e80-f2a16f44aaea", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_PartialUpdateTerm_GlossaryPartialUpdateTerm_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryTerm> response = client.PartialUpdateTerm("54688d39-b298-4104-9e80-f2a16f44aaea", new Dictionary<string, string>
            {
                ["longDescription"] = "Example Long Description"
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_PartialUpdateTerm_GlossaryPartialUpdateTerm_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryTerm> response = await client.PartialUpdateTermAsync("54688d39-b298-4104-9e80-f2a16f44aaea", new Dictionary<string, string>
            {
                ["longDescription"] = "Example Long Description"
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_CreateTerms_GlossaryCreateTerms()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
anchor = new
{
glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
name = "ExampleTerm2",
status = "Approved",
shortDescription = "Example Short Description",
longDescription = "Example Long Description",
abbreviation = "T2",
resources = new object[]
{
new
{
displayName = "Example Display Name",
url = "Example Url",
}
},
},
new
{
anchor = new
{
glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
name = "ExampleTerm3",
status = "Approved",
shortDescription = "Example Short Description",
longDescription = "Example Long Description",
abbreviation = "T3",
resources = new object[]
{
new
{
displayName = "Example Display Name",
url = "Example Url",
}
},
}
            });
            Response response = client.CreateTerms(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_CreateTerms_GlossaryCreateTerms_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
anchor = new
{
glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
name = "ExampleTerm2",
status = "Approved",
shortDescription = "Example Short Description",
longDescription = "Example Long Description",
abbreviation = "T2",
resources = new object[]
{
new
{
displayName = "Example Display Name",
url = "Example Url",
}
},
},
new
{
anchor = new
{
glossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
name = "ExampleTerm3",
status = "Approved",
shortDescription = "Example Short Description",
longDescription = "Example Long Description",
abbreviation = "T3",
resources = new object[]
{
new
{
displayName = "Example Display Name",
url = "Example Url",
}
},
}
            });
            Response response = await client.CreateTermsAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_CreateTerms_GlossaryCreateTerms_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasGlossaryTerm>> response = client.CreateTerms(new AtlasGlossaryTerm[]
            {
new AtlasGlossaryTerm
{
LongDescription = "Example Long Description",
Name = "ExampleTerm2",
ShortDescription = "Example Short Description",
Abbreviation = "T2",
Anchor = new AtlasGlossaryHeader
{
GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
Status = TermStatus.Approved,
Resources = {new ResourceLink
{
DisplayName = "Example Display Name",
Url = "Example Url",
}},
},
new AtlasGlossaryTerm
{
LongDescription = "Example Long Description",
Name = "ExampleTerm3",
ShortDescription = "Example Short Description",
Abbreviation = "T3",
Anchor = new AtlasGlossaryHeader
{
GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
Status = TermStatus.Approved,
Resources = {new ResourceLink
{
DisplayName = "Example Display Name",
Url = "Example Url",
}},
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_CreateTerms_GlossaryCreateTerms_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasGlossaryTerm>> response = await client.CreateTermsAsync(new AtlasGlossaryTerm[]
            {
new AtlasGlossaryTerm
{
LongDescription = "Example Long Description",
Name = "ExampleTerm2",
ShortDescription = "Example Short Description",
Abbreviation = "T2",
Anchor = new AtlasGlossaryHeader
{
GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
Status = TermStatus.Approved,
Resources = {new ResourceLink
{
DisplayName = "Example Display Name",
Url = "Example Url",
}},
},
new AtlasGlossaryTerm
{
LongDescription = "Example Long Description",
Name = "ExampleTerm3",
ShortDescription = "Example Short Description",
Abbreviation = "T3",
Anchor = new AtlasGlossaryHeader
{
GlossaryGuid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
},
Status = TermStatus.Approved,
Resources = {new ResourceLink
{
DisplayName = "Example Display Name",
Url = "Example Url",
}},
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetEntitiesAssignedWithTerm_GlossaryListEntitiesAssignedWithTerm()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetEntitiesAssignedWithTerm("daf0ba4d-bc9a-4536-8a88-4b58e39dd3d4", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetEntitiesAssignedWithTerm_GlossaryListEntitiesAssignedWithTerm_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetEntitiesAssignedWithTermAsync("daf0ba4d-bc9a-4536-8a88-4b58e39dd3d4", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetEntitiesAssignedWithTerm_GlossaryListEntitiesAssignedWithTerm_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasRelatedObjectId>> response = client.GetEntitiesAssignedWithTerm("daf0ba4d-bc9a-4536-8a88-4b58e39dd3d4");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetEntitiesAssignedWithTerm_GlossaryListEntitiesAssignedWithTerm_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasRelatedObjectId>> response = await client.GetEntitiesAssignedWithTermAsync("daf0ba4d-bc9a-4536-8a88-4b58e39dd3d4");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_AssignTermToEntities_GlossaryAssignTermToEntities()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
guid = "ab9f1920-0b94-436d-aeb4-11a32c270fc0",
relationshipAttributes = new
{
attributes = new
{
expression = "Example Expression",
confidence = 100,
description = "Example Description",
source = "ExampleSource",
},
},
}
            });
            Response response = client.AssignTermToEntities("8a7f65ec-6429-0b9b-3734-ec57bf1e34c2", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_AssignTermToEntities_GlossaryAssignTermToEntities_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
guid = "ab9f1920-0b94-436d-aeb4-11a32c270fc0",
relationshipAttributes = new
{
attributes = new
{
expression = "Example Expression",
confidence = 100,
description = "Example Description",
source = "ExampleSource",
},
},
}
            });
            Response response = await client.AssignTermToEntitiesAsync("8a7f65ec-6429-0b9b-3734-ec57bf1e34c2", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_AssignTermToEntities_GlossaryAssignTermToEntities_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.AssignTermToEntities("8a7f65ec-6429-0b9b-3734-ec57bf1e34c2", new AtlasRelatedObjectId[]
            {
new AtlasRelatedObjectId
{
Guid = "ab9f1920-0b94-436d-aeb4-11a32c270fc0",
RelationshipAttributes = new AtlasStruct
{
Attributes =
{
["expression"] = BinaryData.FromObjectAsJson("Example Expression"),
["confidence"] = BinaryData.FromObjectAsJson(100),
["description"] = BinaryData.FromObjectAsJson("Example Description"),
["source"] = BinaryData.FromObjectAsJson("ExampleSource")
},
},
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_AssignTermToEntities_GlossaryAssignTermToEntities_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.AssignTermToEntitiesAsync("8a7f65ec-6429-0b9b-3734-ec57bf1e34c2", new AtlasRelatedObjectId[]
            {
new AtlasRelatedObjectId
{
Guid = "ab9f1920-0b94-436d-aeb4-11a32c270fc0",
RelationshipAttributes = new AtlasStruct
{
Attributes =
{
["expression"] = BinaryData.FromObjectAsJson("Example Expression"),
["confidence"] = BinaryData.FromObjectAsJson(100),
["description"] = BinaryData.FromObjectAsJson("Example Description"),
["source"] = BinaryData.FromObjectAsJson("ExampleSource")
},
},
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_DeleteTermAssignmentFromEntities_GlossaryRemoveTermAssignmentFromEntities()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
guid = "16feb2a1-2c79-ade1-338d-fb24fcb8b8bd",
relationshipGuid = "624f08bb-3c93-4f03-9ce1-ed2ce2c7c8d5",
}
            });
            Response response = client.DeleteTermAssignmentFromEntities("8a7f65ec-6429-0b9b-3734-ec57bf1e34c2", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_DeleteTermAssignmentFromEntities_GlossaryRemoveTermAssignmentFromEntities_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
guid = "16feb2a1-2c79-ade1-338d-fb24fcb8b8bd",
relationshipGuid = "624f08bb-3c93-4f03-9ce1-ed2ce2c7c8d5",
}
            });
            Response response = await client.DeleteTermAssignmentFromEntitiesAsync("8a7f65ec-6429-0b9b-3734-ec57bf1e34c2", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_DeleteTermAssignmentFromEntities_GlossaryRemoveTermAssignmentFromEntities_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.DeleteTermAssignmentFromEntities("8a7f65ec-6429-0b9b-3734-ec57bf1e34c2", new AtlasRelatedObjectId[]
            {
new AtlasRelatedObjectId
{
Guid = "16feb2a1-2c79-ade1-338d-fb24fcb8b8bd",
RelationshipGuid = Guid.Parse("624f08bb-3c93-4f03-9ce1-ed2ce2c7c8d5"),
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_DeleteTermAssignmentFromEntities_GlossaryRemoveTermAssignmentFromEntities_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.DeleteTermAssignmentFromEntitiesAsync("8a7f65ec-6429-0b9b-3734-ec57bf1e34c2", new AtlasRelatedObjectId[]
            {
new AtlasRelatedObjectId
{
Guid = "16feb2a1-2c79-ade1-338d-fb24fcb8b8bd",
RelationshipGuid = Guid.Parse("624f08bb-3c93-4f03-9ce1-ed2ce2c7c8d5"),
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetRelatedTerms_GlossaryListRelatedTerms()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetRelatedTerms("54688d39-b298-4104-9e80-f2a16f44aaea", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetRelatedTerms_GlossaryListRelatedTerms_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetRelatedTermsAsync("54688d39-b298-4104-9e80-f2a16f44aaea", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.GetProperty("<key>")[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetRelatedTerms_GlossaryListRelatedTerms_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyDictionary<string, IList<AtlasRelatedTermHeader>>> response = client.GetRelatedTerms("54688d39-b298-4104-9e80-f2a16f44aaea");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetRelatedTerms_GlossaryListRelatedTerms_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyDictionary<string, IList<AtlasRelatedTermHeader>>> response = await client.GetRelatedTermsAsync("54688d39-b298-4104-9e80-f2a16f44aaea");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetGlossary_GlossaryGet()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetGlossary("47029611-67a1-42d5-8766-90eb904f7f22", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetGlossary_GlossaryGet_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetGlossaryAsync("47029611-67a1-42d5-8766-90eb904f7f22", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetGlossary_GlossaryGet_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossary> response = client.GetGlossary("47029611-67a1-42d5-8766-90eb904f7f22");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetGlossary_GlossaryGet_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossary> response = await client.GetGlossaryAsync("47029611-67a1-42d5-8766-90eb904f7f22");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_Update_GlossaryUpdate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                guid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                qualifiedName = "Glossary",
                name = "Glossary",
                shortDescription = "Example Short Description",
                longDescription = "Example Long Description",
                lastModifiedTS = "1",
                language = "en",
                usage = "Example Glossary",
                terms = new object[]
            {
new
{
termGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
relationGuid = "7b6a8149-a928-476a-a068-dce58653cfa0",
displayText = "ExampleTerm1",
},
new
{
termGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
relationGuid = "9385640b-e6be-437d-a6b9-62d11c14a189",
displayText = "ExampleTerm2",
}
            },
                categories = new object[]
            {
new
{
categoryGuid = "0d6766f6-f4b6-435b-bda2-d3edc358998e",
parentCategoryGuid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
relationGuid = "26a486a4-a8e2-483c-8a84-3b88e909f8d2",
displayText = "ExampleCategory3",
},
new
{
categoryGuid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
parentCategoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
relationGuid = "7bdcef93-a57a-4d1d-95ab-9d3036f394a0",
displayText = "ExampleCategory1",
},
new
{
categoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
relationGuid = "94071e56-fd3e-4441-93ff-1834f818482d",
displayText = "ExampleCategory2",
}
            },
            });
            Response response = client.Update("c018ddaf-7c21-4b37-a838-dae5f110c3d8", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_Update_GlossaryUpdate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                guid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                qualifiedName = "Glossary",
                name = "Glossary",
                shortDescription = "Example Short Description",
                longDescription = "Example Long Description",
                lastModifiedTS = "1",
                language = "en",
                usage = "Example Glossary",
                terms = new object[]
            {
new
{
termGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
relationGuid = "7b6a8149-a928-476a-a068-dce58653cfa0",
displayText = "ExampleTerm1",
},
new
{
termGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
relationGuid = "9385640b-e6be-437d-a6b9-62d11c14a189",
displayText = "ExampleTerm2",
}
            },
                categories = new object[]
            {
new
{
categoryGuid = "0d6766f6-f4b6-435b-bda2-d3edc358998e",
parentCategoryGuid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
relationGuid = "26a486a4-a8e2-483c-8a84-3b88e909f8d2",
displayText = "ExampleCategory3",
},
new
{
categoryGuid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
parentCategoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
relationGuid = "7bdcef93-a57a-4d1d-95ab-9d3036f394a0",
displayText = "ExampleCategory1",
},
new
{
categoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
relationGuid = "94071e56-fd3e-4441-93ff-1834f818482d",
displayText = "ExampleCategory2",
}
            },
            });
            Response response = await client.UpdateAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_Update_GlossaryUpdate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossary body = new AtlasGlossary
            {
                Guid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                LongDescription = "Example Long Description",
                Name = "Glossary",
                QualifiedName = "Glossary",
                ShortDescription = "Example Short Description",
                LastModifiedTS = "1",
                Categories = {new AtlasRelatedCategoryHeader
{
CategoryGuid = "0d6766f6-f4b6-435b-bda2-d3edc358998e",
DisplayText = "ExampleCategory3",
ParentCategoryGuid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
RelationGuid = "26a486a4-a8e2-483c-8a84-3b88e909f8d2",
}, new AtlasRelatedCategoryHeader
{
CategoryGuid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
DisplayText = "ExampleCategory1",
ParentCategoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
RelationGuid = "7bdcef93-a57a-4d1d-95ab-9d3036f394a0",
}, new AtlasRelatedCategoryHeader
{
CategoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
DisplayText = "ExampleCategory2",
RelationGuid = "94071e56-fd3e-4441-93ff-1834f818482d",
}},
                Language = "en",
                Terms = {new AtlasRelatedTermHeader
{
DisplayText = "ExampleTerm1",
RelationGuid = "7b6a8149-a928-476a-a068-dce58653cfa0",
TermGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
}, new AtlasRelatedTermHeader
{
DisplayText = "ExampleTerm2",
RelationGuid = "9385640b-e6be-437d-a6b9-62d11c14a189",
TermGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
}},
                Usage = "Example Glossary",
            };
            Response<AtlasGlossary> response = client.Update("c018ddaf-7c21-4b37-a838-dae5f110c3d8", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_Update_GlossaryUpdate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            AtlasGlossary body = new AtlasGlossary
            {
                Guid = "c018ddaf-7c21-4b37-a838-dae5f110c3d8",
                LongDescription = "Example Long Description",
                Name = "Glossary",
                QualifiedName = "Glossary",
                ShortDescription = "Example Short Description",
                LastModifiedTS = "1",
                Categories = {new AtlasRelatedCategoryHeader
{
CategoryGuid = "0d6766f6-f4b6-435b-bda2-d3edc358998e",
DisplayText = "ExampleCategory3",
ParentCategoryGuid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
RelationGuid = "26a486a4-a8e2-483c-8a84-3b88e909f8d2",
}, new AtlasRelatedCategoryHeader
{
CategoryGuid = "ed7458f0-9463-48a5-b5c6-4f785fb34e12",
DisplayText = "ExampleCategory1",
ParentCategoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
RelationGuid = "7bdcef93-a57a-4d1d-95ab-9d3036f394a0",
}, new AtlasRelatedCategoryHeader
{
CategoryGuid = "e47c4584-daca-4f9e-9092-194e04692c9a",
DisplayText = "ExampleCategory2",
RelationGuid = "94071e56-fd3e-4441-93ff-1834f818482d",
}},
                Language = "en",
                Terms = {new AtlasRelatedTermHeader
{
DisplayText = "ExampleTerm1",
RelationGuid = "7b6a8149-a928-476a-a068-dce58653cfa0",
TermGuid = "54688d39-b298-4104-9e80-f2a16f44aaea",
}, new AtlasRelatedTermHeader
{
DisplayText = "ExampleTerm2",
RelationGuid = "9385640b-e6be-437d-a6b9-62d11c14a189",
TermGuid = "952c7ba4-4c89-42d8-a05a-7d2161be7008",
}},
                Usage = "Example Glossary",
            };
            Response<AtlasGlossary> response = await client.UpdateAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_Delete_GlossaryDelete()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.Delete("c0c54153-13d1-1608-13af-43457cdffe75");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_Delete_GlossaryDelete_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.DeleteAsync("c0c54153-13d1-1608-13af-43457cdffe75");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetCategories_GlossaryListCategories()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetCategories("c018ddaf-7c21-4b37-a838-dae5f110c3d8", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetCategories_GlossaryListCategories_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetCategoriesAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetCategories_GlossaryListCategories_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasGlossaryCategory>> response = client.GetCategories("c018ddaf-7c21-4b37-a838-dae5f110c3d8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetCategories_GlossaryListCategories_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasGlossaryCategory>> response = await client.GetCategoriesAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetCategoriesHeaders_GlossaryListCategoriesHeaders()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetCategoriesHeaders("c018ddaf-7c21-4b37-a838-dae5f110c3d8", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetCategoriesHeaders_GlossaryListCategoriesHeaders_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetCategoriesHeadersAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetCategoriesHeaders_GlossaryListCategoriesHeaders_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasRelatedCategoryHeader>> response = client.GetCategoriesHeaders("c018ddaf-7c21-4b37-a838-dae5f110c3d8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetCategoriesHeaders_GlossaryListCategoriesHeaders_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasRelatedCategoryHeader>> response = await client.GetCategoriesHeadersAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetDetailed_GlossaryGetDetailed()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetDetailed("c018ddaf-7c21-4b37-a838-dae5f110c3d8", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetDetailed_GlossaryGetDetailed_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetDetailedAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetDetailed_GlossaryGetDetailed_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryExtInfo> response = client.GetDetailed("c018ddaf-7c21-4b37-a838-dae5f110c3d8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetDetailed_GlossaryGetDetailed_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossaryExtInfo> response = await client.GetDetailedAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_PartialUpdate_GlossaryPartialUpdate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                longDescription = "Example Long Description",
            });
            Response response = client.PartialUpdate("c018ddaf-7c21-4b37-a838-dae5f110c3d8", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_PartialUpdate_GlossaryPartialUpdate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            using RequestContent content = RequestContent.Create(new
            {
                longDescription = "Example Long Description",
            });
            Response response = await client.PartialUpdateAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_PartialUpdate_GlossaryPartialUpdate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossary> response = client.PartialUpdate("c018ddaf-7c21-4b37-a838-dae5f110c3d8", new Dictionary<string, string>
            {
                ["longDescription"] = "Example Long Description"
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_PartialUpdate_GlossaryPartialUpdate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<AtlasGlossary> response = await client.PartialUpdateAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8", new Dictionary<string, string>
            {
                ["longDescription"] = "Example Long Description"
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetTerms_GlossaryListTerms()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetTerms("c018ddaf-7c21-4b37-a838-dae5f110c3d8", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetTerms_GlossaryListTerms_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetTermsAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetTerms_GlossaryListTerms_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasGlossaryTerm>> response = client.GetTerms("c018ddaf-7c21-4b37-a838-dae5f110c3d8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetTerms_GlossaryListTerms_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasGlossaryTerm>> response = await client.GetTermsAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetTermHeaders_GlossaryListTermHeaders()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = client.GetTermHeaders("c018ddaf-7c21-4b37-a838-dae5f110c3d8", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetTermHeaders_GlossaryListTermHeaders_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response response = await client.GetTermHeadersAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8", null, null, "ASC", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Glossary_GetTermHeaders_GlossaryListTermHeaders_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasRelatedTermHeader>> response = client.GetTermHeaders("c018ddaf-7c21-4b37-a838-dae5f110c3d8");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Glossary_GetTermHeaders_GlossaryListTermHeaders_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Glossary client = new DataMapClient(endpoint, credential).GetGlossaryClient();

            Response<IReadOnlyList<AtlasRelatedTermHeader>> response = await client.GetTermHeadersAsync("c018ddaf-7c21-4b37-a838-dae5f110c3d8");
        }
    }
}
