// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.DataMap.Samples
{
    public partial class Samples_Entity
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_CreateOrUpdate_EntityAddCustomAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                referredEntities = new object(),
                entity = new
                {
                    typeName = "azure_storage_account",
                    attributes = new
                    {
                        owner = "ExampleOwner",
                        modifiedTime = 0,
                        createTime = 0,
                        qualifiedName = "https://exampleaccount.core.windows.net",
                        name = "ExampleStorageAccount",
                    },
                    customAttributes = new
                    {
                        custAttr1 = "attr1",
                        custAttr2 = "attr2",
                    },
                },
            });
            Response response = client.CreateOrUpdate(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_CreateOrUpdate_EntityAddCustomAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                referredEntities = new object(),
                entity = new
                {
                    typeName = "azure_storage_account",
                    attributes = new
                    {
                        owner = "ExampleOwner",
                        modifiedTime = 0,
                        createTime = 0,
                        qualifiedName = "https://exampleaccount.core.windows.net",
                        name = "ExampleStorageAccount",
                    },
                    customAttributes = new
                    {
                        custAttr1 = "attr1",
                        custAttr2 = "attr2",
                    },
                },
            });
            Response response = await client.CreateOrUpdateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_CreateOrUpdate_EntityAddCustomAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            AtlasEntityWithExtInfo body = new AtlasEntityWithExtInfo
            {
                ReferredEntities = { },
                Entity = new AtlasEntity
                {
                    Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount.core.windows.net"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount"),
["description"] = null,
["publicAccessLevel"] = null
},
                    TypeName = "azure_storage_account",
                    CustomAttributes =
{
["custAttr1"] = "attr1",
["custAttr2"] = "attr2"
},
                },
            };
            Response<EntityMutationResult> response = client.CreateOrUpdate(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_CreateOrUpdate_EntityAddCustomAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            AtlasEntityWithExtInfo body = new AtlasEntityWithExtInfo
            {
                ReferredEntities = { },
                Entity = new AtlasEntity
                {
                    Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount.core.windows.net"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount"),
["description"] = null,
["publicAccessLevel"] = null
},
                    TypeName = "azure_storage_account",
                    CustomAttributes =
{
["custAttr1"] = "attr1",
["custAttr2"] = "attr2"
},
                },
            };
            Response<EntityMutationResult> response = await client.CreateOrUpdateAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_CreateOrUpdate_EntityCreate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                referredEntities = new object(),
                entity = new
                {
                    typeName = "azure_storage_account",
                    attributes = new
                    {
                        owner = "ExampleOwner",
                        modifiedTime = 0,
                        createTime = 0,
                        qualifiedName = "https://exampleaccount.core.windows.net",
                        name = "ExampleStorageAccount",
                    },
                    contacts = new
                    {
                        Expert = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Expert Info",
}
            },
                        Owner = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Owner Info",
}
            },
                    },
                    status = "ACTIVE",
                    createdBy = "ExampleCreator",
                    updatedBy = "ExampleUpdator",
                    version = 0L,
                },
            });
            Response response = client.CreateOrUpdate(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_CreateOrUpdate_EntityCreate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                referredEntities = new object(),
                entity = new
                {
                    typeName = "azure_storage_account",
                    attributes = new
                    {
                        owner = "ExampleOwner",
                        modifiedTime = 0,
                        createTime = 0,
                        qualifiedName = "https://exampleaccount.core.windows.net",
                        name = "ExampleStorageAccount",
                    },
                    contacts = new
                    {
                        Expert = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Expert Info",
}
            },
                        Owner = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Owner Info",
}
            },
                    },
                    status = "ACTIVE",
                    createdBy = "ExampleCreator",
                    updatedBy = "ExampleUpdator",
                    version = 0L,
                },
            });
            Response response = await client.CreateOrUpdateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_CreateOrUpdate_EntityCreate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            AtlasEntityWithExtInfo body = new AtlasEntityWithExtInfo
            {
                ReferredEntities = { },
                Entity = new AtlasEntity
                {
                    Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount.core.windows.net"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount"),
["description"] = null,
["publicAccessLevel"] = null
},
                    TypeName = "azure_storage_account",
                    CreatedBy = "ExampleCreator",
                    Status = EntityStatus.Active,
                    UpdatedBy = "ExampleUpdator",
                    Version = 0L,
                    Contacts =
{
["Expert"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Expert Info",
}},
["Owner"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Owner Info",
}}
},
                },
            };
            Response<EntityMutationResult> response = client.CreateOrUpdate(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_CreateOrUpdate_EntityCreate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            AtlasEntityWithExtInfo body = new AtlasEntityWithExtInfo
            {
                ReferredEntities = { },
                Entity = new AtlasEntity
                {
                    Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount.core.windows.net"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount"),
["description"] = null,
["publicAccessLevel"] = null
},
                    TypeName = "azure_storage_account",
                    CreatedBy = "ExampleCreator",
                    Status = EntityStatus.Active,
                    UpdatedBy = "ExampleUpdator",
                    Version = 0L,
                    Contacts =
{
["Expert"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Expert Info",
}},
["Owner"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Owner Info",
}}
},
                },
            };
            Response<EntityMutationResult> response = await client.CreateOrUpdateAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_CreateOrUpdate_EntityCreateOrUpdateWithRichText()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                referredEntities = new object(),
                entity = new
                {
                    typeName = "azure_storage_account",
                    attributes = new
                    {
                        owner = "ExampleOwner",
                        modifiedTime = 0,
                        createTime = 0,
                        qualifiedName = "https://exampleaccount.core.windows.net",
                        name = "ExampleStorageAccount",
                        userDescription = "<div><b>testing</b></div>",
                    },
                    customAttributes = new
                    {
                        microsoft_isDescriptionRichText = "true",
                    },
                    status = "ACTIVE",
                    createdBy = "ExampleCreator",
                    updatedBy = "ExampleUpdator",
                    version = 0L,
                },
            });
            Response response = client.CreateOrUpdate(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_CreateOrUpdate_EntityCreateOrUpdateWithRichText_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                referredEntities = new object(),
                entity = new
                {
                    typeName = "azure_storage_account",
                    attributes = new
                    {
                        owner = "ExampleOwner",
                        modifiedTime = 0,
                        createTime = 0,
                        qualifiedName = "https://exampleaccount.core.windows.net",
                        name = "ExampleStorageAccount",
                        userDescription = "<div><b>testing</b></div>",
                    },
                    customAttributes = new
                    {
                        microsoft_isDescriptionRichText = "true",
                    },
                    status = "ACTIVE",
                    createdBy = "ExampleCreator",
                    updatedBy = "ExampleUpdator",
                    version = 0L,
                },
            });
            Response response = await client.CreateOrUpdateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_CreateOrUpdate_EntityCreateOrUpdateWithRichText_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            AtlasEntityWithExtInfo body = new AtlasEntityWithExtInfo
            {
                ReferredEntities = { },
                Entity = new AtlasEntity
                {
                    Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount.core.windows.net"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount"),
["description"] = null,
["userDescription"] = BinaryData.FromObjectAsJson("<div><b>testing</b></div>"),
["publicAccessLevel"] = null
},
                    TypeName = "azure_storage_account",
                    CreatedBy = "ExampleCreator",
                    CustomAttributes =
{
["microsoft_isDescriptionRichText"] = "true"
},
                    Status = EntityStatus.Active,
                    UpdatedBy = "ExampleUpdator",
                    Version = 0L,
                },
            };
            Response<EntityMutationResult> response = client.CreateOrUpdate(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_CreateOrUpdate_EntityCreateOrUpdateWithRichText_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            AtlasEntityWithExtInfo body = new AtlasEntityWithExtInfo
            {
                ReferredEntities = { },
                Entity = new AtlasEntity
                {
                    Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount.core.windows.net"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount"),
["description"] = null,
["userDescription"] = BinaryData.FromObjectAsJson("<div><b>testing</b></div>"),
["publicAccessLevel"] = null
},
                    TypeName = "azure_storage_account",
                    CreatedBy = "ExampleCreator",
                    CustomAttributes =
{
["microsoft_isDescriptionRichText"] = "true"
},
                    Status = EntityStatus.Active,
                    UpdatedBy = "ExampleUpdator",
                    Version = 0L,
                },
            };
            Response<EntityMutationResult> response = await client.CreateOrUpdateAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_CreateOrUpdate_EntityUpdate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                referredEntities = new object(),
                entity = new
                {
                    typeName = "azure_storage_account",
                    attributes = new
                    {
                        owner = "ExampleOwner",
                        modifiedTime = 0,
                        createTime = 0,
                        qualifiedName = "exampleaccount",
                        name = "ExampleStorageAccount",
                    },
                    contacts = new
                    {
                        Expert = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Expert Info",
}
            },
                        Owner = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Owner Info",
}
            },
                    },
                    status = "ACTIVE",
                    createdBy = "ExampleCreator",
                    updatedBy = "ExampleUpdator",
                    version = 0L,
                },
            });
            Response response = client.CreateOrUpdate(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_CreateOrUpdate_EntityUpdate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                referredEntities = new object(),
                entity = new
                {
                    typeName = "azure_storage_account",
                    attributes = new
                    {
                        owner = "ExampleOwner",
                        modifiedTime = 0,
                        createTime = 0,
                        qualifiedName = "exampleaccount",
                        name = "ExampleStorageAccount",
                    },
                    contacts = new
                    {
                        Expert = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Expert Info",
}
            },
                        Owner = new object[]
            {
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Owner Info",
}
            },
                    },
                    status = "ACTIVE",
                    createdBy = "ExampleCreator",
                    updatedBy = "ExampleUpdator",
                    version = 0L,
                },
            });
            Response response = await client.CreateOrUpdateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_CreateOrUpdate_EntityUpdate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            AtlasEntityWithExtInfo body = new AtlasEntityWithExtInfo
            {
                ReferredEntities = { },
                Entity = new AtlasEntity
                {
                    Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("exampleaccount"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount"),
["description"] = null,
["publicAccessLevel"] = null
},
                    TypeName = "azure_storage_account",
                    CreatedBy = "ExampleCreator",
                    Status = EntityStatus.Active,
                    UpdatedBy = "ExampleUpdator",
                    Version = 0L,
                    Contacts =
{
["Expert"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Expert Info",
}},
["Owner"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Owner Info",
}}
},
                },
            };
            Response<EntityMutationResult> response = client.CreateOrUpdate(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_CreateOrUpdate_EntityUpdate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            AtlasEntityWithExtInfo body = new AtlasEntityWithExtInfo
            {
                ReferredEntities = { },
                Entity = new AtlasEntity
                {
                    Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("exampleaccount"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount"),
["description"] = null,
["publicAccessLevel"] = null
},
                    TypeName = "azure_storage_account",
                    CreatedBy = "ExampleCreator",
                    Status = EntityStatus.Active,
                    UpdatedBy = "ExampleUpdator",
                    Version = 0L,
                    Contacts =
{
["Expert"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Expert Info",
}},
["Owner"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Owner Info",
}}
},
                },
            };
            Response<EntityMutationResult> response = await client.CreateOrUpdateAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetByIds_EntityListByGuids()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.GetByIds(new string[] { "784c0f2f-afd2-e26b-f9cb-984f6c2c5021", "b4ebc8be-cef4-860a-bee9-28cc34cb5caa" }, true, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetByIds_EntityListByGuids_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.GetByIdsAsync(new string[] { "784c0f2f-afd2-e26b-f9cb-984f6c2c5021", "b4ebc8be-cef4-860a-bee9-28cc34cb5caa" }, true, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetByIds_EntityListByGuids_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasEntitiesWithExtInfo> response = client.GetByIds(new string[] { "784c0f2f-afd2-e26b-f9cb-984f6c2c5021", "b4ebc8be-cef4-860a-bee9-28cc34cb5caa" });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetByIds_EntityListByGuids_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasEntitiesWithExtInfo> response = await client.GetByIdsAsync(new string[] { "784c0f2f-afd2-e26b-f9cb-984f6c2c5021", "b4ebc8be-cef4-860a-bee9-28cc34cb5caa" });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_BatchCreateOrUpdate_EntityBulkCreateOrUpdate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                referredEntities = new object(),
                entities = new object[]
            {
new
{
typeName = "azure_storage_account",
attributes = new
{
owner = "ExampleOwner",
modifiedTime = 0,
createTime = 0,
qualifiedName = "exampleaccount1",
name = "ExampleStorageAccount1",
},
contacts = new
{
Expert = new object[]
{
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Expert Info",
}
},
Owner = new object[]
{
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Owner Info",
}
},
},
status = "ACTIVE",
createdBy = "ExampleCreator",
updatedBy = "ExampleUpdator",
version = 0L,
},
new
{
typeName = "azure_storage_account",
attributes = new
{
owner = "ExampleOwner",
modifiedTime = 0,
createTime = 0,
qualifiedName = "exampleaccount2",
name = "ExampleStorageAccount2",
description = "Example Description",
},
contacts = new
{
Expert = new object[]
{
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Expert Info",
}
},
Owner = new object[]
{
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Owner Info",
}
},
},
status = "ACTIVE",
createdBy = "ExampleCreator",
updatedBy = "ExampleUpdator",
version = 0L,
}
            },
            });
            Response response = client.BatchCreateOrUpdate(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_BatchCreateOrUpdate_EntityBulkCreateOrUpdate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                referredEntities = new object(),
                entities = new object[]
            {
new
{
typeName = "azure_storage_account",
attributes = new
{
owner = "ExampleOwner",
modifiedTime = 0,
createTime = 0,
qualifiedName = "exampleaccount1",
name = "ExampleStorageAccount1",
},
contacts = new
{
Expert = new object[]
{
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Expert Info",
}
},
Owner = new object[]
{
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Owner Info",
}
},
},
status = "ACTIVE",
createdBy = "ExampleCreator",
updatedBy = "ExampleUpdator",
version = 0L,
},
new
{
typeName = "azure_storage_account",
attributes = new
{
owner = "ExampleOwner",
modifiedTime = 0,
createTime = 0,
qualifiedName = "exampleaccount2",
name = "ExampleStorageAccount2",
description = "Example Description",
},
contacts = new
{
Expert = new object[]
{
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Expert Info",
}
},
Owner = new object[]
{
new
{
id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
info = "Example Owner Info",
}
},
},
status = "ACTIVE",
createdBy = "ExampleCreator",
updatedBy = "ExampleUpdator",
version = 0L,
}
            },
            });
            Response response = await client.BatchCreateOrUpdateAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_BatchCreateOrUpdate_EntityBulkCreateOrUpdate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            AtlasEntitiesWithExtInfo body = new AtlasEntitiesWithExtInfo
            {
                ReferredEntities = { },
                Entities = {new AtlasEntity
{
Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("exampleaccount1"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount1"),
["description"] = null,
["publicAccessLevel"] = null
},
TypeName = "azure_storage_account",
CreatedBy = "ExampleCreator",
Status = EntityStatus.Active,
UpdatedBy = "ExampleUpdator",
Version = 0L,
Contacts =
{
["Expert"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Expert Info",
}},
["Owner"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Owner Info",
}}
},
}, new AtlasEntity
{
Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("exampleaccount2"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount2"),
["description"] = BinaryData.FromObjectAsJson("Example Description"),
["publicAccessLevel"] = null
},
TypeName = "azure_storage_account",
CreatedBy = "ExampleCreator",
Status = EntityStatus.Active,
UpdatedBy = "ExampleUpdator",
Version = 0L,
Contacts =
{
["Expert"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Expert Info",
}},
["Owner"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Owner Info",
}}
},
}},
            };
            Response<EntityMutationResult> response = client.BatchCreateOrUpdate(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_BatchCreateOrUpdate_EntityBulkCreateOrUpdate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            AtlasEntitiesWithExtInfo body = new AtlasEntitiesWithExtInfo
            {
                ReferredEntities = { },
                Entities = {new AtlasEntity
{
Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("exampleaccount1"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount1"),
["description"] = null,
["publicAccessLevel"] = null
},
TypeName = "azure_storage_account",
CreatedBy = "ExampleCreator",
Status = EntityStatus.Active,
UpdatedBy = "ExampleUpdator",
Version = 0L,
Contacts =
{
["Expert"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Expert Info",
}},
["Owner"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Owner Info",
}}
},
}, new AtlasEntity
{
Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["modifiedTime"] = BinaryData.FromObjectAsJson(0),
["createTime"] = BinaryData.FromObjectAsJson(0),
["qualifiedName"] = BinaryData.FromObjectAsJson("exampleaccount2"),
["name"] = BinaryData.FromObjectAsJson("ExampleStorageAccount2"),
["description"] = BinaryData.FromObjectAsJson("Example Description"),
["publicAccessLevel"] = null
},
TypeName = "azure_storage_account",
CreatedBy = "ExampleCreator",
Status = EntityStatus.Active,
UpdatedBy = "ExampleUpdator",
Version = 0L,
Contacts =
{
["Expert"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Expert Info",
}},
["Owner"] = {new ContactInfo
{
Id = "30435ff9-9b96-44af-a5a9-e05c8b1ae2df",
Info = "Example Owner Info",
}}
},
}},
            };
            Response<EntityMutationResult> response = await client.BatchCreateOrUpdateAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_BatchDelete_EntityBulkDelete()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.BatchDelete(new string[] { "18e06957-e265-967a-07f1-e14e2ab8940f", "cc0730ba-9b30-41f0-6953-559d17626d2b" }, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_BatchDelete_EntityBulkDelete_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.BatchDeleteAsync(new string[] { "18e06957-e265-967a-07f1-e14e2ab8940f", "cc0730ba-9b30-41f0-6953-559d17626d2b" }, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_BatchDelete_EntityBulkDelete_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<EntityMutationResult> response = client.BatchDelete(new string[] { "18e06957-e265-967a-07f1-e14e2ab8940f", "cc0730ba-9b30-41f0-6953-559d17626d2b" });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_BatchDelete_EntityBulkDelete_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<EntityMutationResult> response = await client.BatchDeleteAsync(new string[] { "18e06957-e265-967a-07f1-e14e2ab8940f", "cc0730ba-9b30-41f0-6953-559d17626d2b" });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddClassification_EntityAddClassificationToEntityByGuids()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                classification = new
                {
                    typeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
                    attributes = new object(),
                    validityPeriods = Array.Empty<object>(),
                },
                entityGuids = new object[]
            {
"784c0f2f-afd2-e26b-f9cb-984f6c2c5021",
"b4ebc8be-cef4-860a-bee9-28cc34cb5caa"
            },
            });
            Response response = client.AddClassification(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddClassification_EntityAddClassificationToEntityByGuids_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                classification = new
                {
                    typeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
                    attributes = new object(),
                    validityPeriods = Array.Empty<object>(),
                },
                entityGuids = new object[]
            {
"784c0f2f-afd2-e26b-f9cb-984f6c2c5021",
"b4ebc8be-cef4-860a-bee9-28cc34cb5caa"
            },
            });
            Response response = await client.AddClassificationAsync(content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddClassification_EntityAddClassificationToEntityByGuids_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            ClassificationAssociateConfig body = new ClassificationAssociateConfig
            {
                Classification = new AtlasClassification
                {
                    Attributes = { },
                    TypeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
                    ValidityPeriods = { },
                },
                EntityGuids = { "784c0f2f-afd2-e26b-f9cb-984f6c2c5021", "b4ebc8be-cef4-860a-bee9-28cc34cb5caa" },
            };
            Response response = client.AddClassification(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddClassification_EntityAddClassificationToEntityByGuids_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            ClassificationAssociateConfig body = new ClassificationAssociateConfig
            {
                Classification = new AtlasClassification
                {
                    Attributes = { },
                    TypeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
                    ValidityPeriods = { },
                },
                EntityGuids = { "784c0f2f-afd2-e26b-f9cb-984f6c2c5021", "b4ebc8be-cef4-860a-bee9-28cc34cb5caa" },
            };
            Response response = await client.AddClassificationAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetEntity_EntityGet()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.GetEntity("5cf8a9e5-c9fd-abe0-2e8c-d40024263dcb", true, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetEntity_EntityGet_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.GetEntityAsync("5cf8a9e5-c9fd-abe0-2e8c-d40024263dcb", true, null, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetEntity_EntityGet_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasEntityWithExtInfo> response = client.GetEntity("5cf8a9e5-c9fd-abe0-2e8c-d40024263dcb");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetEntity_EntityGet_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasEntityWithExtInfo> response = await client.GetEntityAsync("5cf8a9e5-c9fd-abe0-2e8c-d40024263dcb");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_UpdateAttributeById_EntityPartialUpdateAttributeByGuid()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create("ExampleNewName");
            Response response = client.UpdateAttributeById("394d9a03-912e-483b-bbd2-bedee1a69798", "ExampleName", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_UpdateAttributeById_EntityPartialUpdateAttributeByGuid_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create("ExampleNewName");
            Response response = await client.UpdateAttributeByIdAsync("394d9a03-912e-483b-bbd2-bedee1a69798", "ExampleName", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_UpdateAttributeById_EntityPartialUpdateAttributeByGuid_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<EntityMutationResult> response = client.UpdateAttributeById("394d9a03-912e-483b-bbd2-bedee1a69798", "ExampleName", BinaryData.FromObjectAsJson("ExampleNewName"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_UpdateAttributeById_EntityPartialUpdateAttributeByGuid_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<EntityMutationResult> response = await client.UpdateAttributeByIdAsync("394d9a03-912e-483b-bbd2-bedee1a69798", "ExampleName", BinaryData.FromObjectAsJson("ExampleNewName"));
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_Delete_EntityDelete()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.Delete("fd279eb4-f6c3-1b0b-ad67-e4f8abd2972f", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_Delete_EntityDelete_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.DeleteAsync("fd279eb4-f6c3-1b0b-ad67-e4f8abd2972f", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_Delete_EntityDelete_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<EntityMutationResult> response = client.Delete("fd279eb4-f6c3-1b0b-ad67-e4f8abd2972f");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_Delete_EntityDelete_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<EntityMutationResult> response = await client.DeleteAsync("fd279eb4-f6c3-1b0b-ad67-e4f8abd2972f");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetClassification_EntityGetClassification()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.GetClassification("9347abc5-7b86-4b82-a1e2-ad77c7c3cac3", "MICROSOFT.PERSONAL.DATE_OF_BIRTH", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetClassification_EntityGetClassification_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.GetClassificationAsync("9347abc5-7b86-4b82-a1e2-ad77c7c3cac3", "MICROSOFT.PERSONAL.DATE_OF_BIRTH", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetClassification_EntityGetClassification_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasClassification> response = client.GetClassification("9347abc5-7b86-4b82-a1e2-ad77c7c3cac3", "MICROSOFT.PERSONAL.DATE_OF_BIRTH");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetClassification_EntityGetClassification_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasClassification> response = await client.GetClassificationAsync("9347abc5-7b86-4b82-a1e2-ad77c7c3cac3", "MICROSOFT.PERSONAL.DATE_OF_BIRTH");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_RemoveClassification_EntityRemoveClassification()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.RemoveClassification("cc0730ba-9b30-41f0-6953-559d17626d2b", "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_RemoveClassification_EntityRemoveClassification_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.RemoveClassificationAsync("cc0730ba-9b30-41f0-6953-559d17626d2b", "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetClassifications_EntityGetClassifications()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.GetClassifications("67d26de6-771d-1a2d-cb2b-dec4dbd2a9bd", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetClassifications_EntityGetClassifications_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.GetClassificationsAsync("67d26de6-771d-1a2d-cb2b-dec4dbd2a9bd", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetClassifications_EntityGetClassifications_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasClassifications> response = client.GetClassifications("67d26de6-771d-1a2d-cb2b-dec4dbd2a9bd");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetClassifications_EntityGetClassifications_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasClassifications> response = await client.GetClassificationsAsync("67d26de6-771d-1a2d-cb2b-dec4dbd2a9bd");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddClassifications_EntityAddClassifications()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
typeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
entityGuid = "cc0730ba-9b30-41f0-6953-559d17626d2b",
},
new
{
typeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
entityGuid = "cc0730ba-9b30-41f0-6953-559d17626d2b",
}
            });
            Response response = client.AddClassifications("cc0730ba-9b30-41f0-6953-559d17626d2b", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddClassifications_EntityAddClassifications_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
typeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
entityGuid = "cc0730ba-9b30-41f0-6953-559d17626d2b",
},
new
{
typeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
entityGuid = "cc0730ba-9b30-41f0-6953-559d17626d2b",
}
            });
            Response response = await client.AddClassificationsAsync("cc0730ba-9b30-41f0-6953-559d17626d2b", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddClassifications_EntityAddClassifications_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.AddClassifications("cc0730ba-9b30-41f0-6953-559d17626d2b", new AtlasClassification[]
            {
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
EntityGuid = "cc0730ba-9b30-41f0-6953-559d17626d2b",
},
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
EntityGuid = "cc0730ba-9b30-41f0-6953-559d17626d2b",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddClassifications_EntityAddClassifications_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.AddClassificationsAsync("cc0730ba-9b30-41f0-6953-559d17626d2b", new AtlasClassification[]
            {
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
EntityGuid = "cc0730ba-9b30-41f0-6953-559d17626d2b",
},
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
EntityGuid = "cc0730ba-9b30-41f0-6953-559d17626d2b",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_UpdateClassifications_EntityUpdateClassifications()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
typeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
entityGuid = "45dd4404-e897-b7e2-ca3c-f6e6b11b4f24",
},
new
{
typeName = "MICROSOFT.FINANCIAL.US_BANK_ACCOUNT_NUMBER",
entityGuid = "45dd4404-e897-b7e2-ca3c-f6e6b11b4f24",
}
            });
            Response response = client.UpdateClassifications("45dd4404-e897-b7e2-ca3c-f6e6b11b4f24", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_UpdateClassifications_EntityUpdateClassifications_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
typeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
entityGuid = "45dd4404-e897-b7e2-ca3c-f6e6b11b4f24",
},
new
{
typeName = "MICROSOFT.FINANCIAL.US_BANK_ACCOUNT_NUMBER",
entityGuid = "45dd4404-e897-b7e2-ca3c-f6e6b11b4f24",
}
            });
            Response response = await client.UpdateClassificationsAsync("45dd4404-e897-b7e2-ca3c-f6e6b11b4f24", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_UpdateClassifications_EntityUpdateClassifications_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.UpdateClassifications("45dd4404-e897-b7e2-ca3c-f6e6b11b4f24", new AtlasClassification[]
            {
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
EntityGuid = "45dd4404-e897-b7e2-ca3c-f6e6b11b4f24",
},
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.US_BANK_ACCOUNT_NUMBER",
EntityGuid = "45dd4404-e897-b7e2-ca3c-f6e6b11b4f24",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_UpdateClassifications_EntityUpdateClassifications_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.UpdateClassificationsAsync("45dd4404-e897-b7e2-ca3c-f6e6b11b4f24", new AtlasClassification[]
            {
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
EntityGuid = "45dd4404-e897-b7e2-ca3c-f6e6b11b4f24",
},
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.US_BANK_ACCOUNT_NUMBER",
EntityGuid = "45dd4404-e897-b7e2-ca3c-f6e6b11b4f24",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetByUniqueAttribute_EntityGetByUniqueAttributes()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.GetByUniqueAttribute("azure_storage_account", true, null, "https://exampleaccount.core.windows.net", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetByUniqueAttribute_EntityGetByUniqueAttributes_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.GetByUniqueAttributeAsync("azure_storage_account", true, null, "https://exampleaccount.core.windows.net", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetByUniqueAttribute_EntityGetByUniqueAttributes_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasEntityWithExtInfo> response = client.GetByUniqueAttribute("azure_storage_account");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetByUniqueAttribute_EntityGetByUniqueAttributes_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasEntityWithExtInfo> response = await client.GetByUniqueAttributeAsync("azure_storage_account");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_UpdateByUniqueAttribute_EntityPartialUpdateByUniqueAttributes()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                entity = new
                {
                    createdBy = "8c062c84-5d25-449f-a990-9d8ab70b8ec7",
                    guid = "dc507ccf-0c57-4165-9327-f37b0d13fda0",
                    relationshipAttributes = new
                    {
                        services = Array.Empty<object>(),
                        meanings = Array.Empty<object>(),
                    },
                    status = "ACTIVE",
                    updatedBy = "8c062c84-5d25-449f-a990-9d8ab70b8ec7",
                    lastModifiedTS = "1",
                    version = 0L,
                    attributes = new
                    {
                        owner = "ExampleOwner",
                        qualifiedName = "https://exampleaccount.core.windows.net",
                        createTime = 0,
                        name = "ExampleNewName",
                    },
                    typeName = "azure_storage_account",
                },
                referredEntities = new object(),
            });
            Response response = client.UpdateByUniqueAttribute("azure_storage_account", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_UpdateByUniqueAttribute_EntityPartialUpdateByUniqueAttributes_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                entity = new
                {
                    createdBy = "8c062c84-5d25-449f-a990-9d8ab70b8ec7",
                    guid = "dc507ccf-0c57-4165-9327-f37b0d13fda0",
                    relationshipAttributes = new
                    {
                        services = Array.Empty<object>(),
                        meanings = Array.Empty<object>(),
                    },
                    status = "ACTIVE",
                    updatedBy = "8c062c84-5d25-449f-a990-9d8ab70b8ec7",
                    lastModifiedTS = "1",
                    version = 0L,
                    attributes = new
                    {
                        owner = "ExampleOwner",
                        qualifiedName = "https://exampleaccount.core.windows.net",
                        createTime = 0,
                        name = "ExampleNewName",
                    },
                    typeName = "azure_storage_account",
                },
                referredEntities = new object(),
            });
            Response response = await client.UpdateByUniqueAttributeAsync("azure_storage_account", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_UpdateByUniqueAttribute_EntityPartialUpdateByUniqueAttributes_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            AtlasEntityWithExtInfo body = new AtlasEntityWithExtInfo
            {
                ReferredEntities = { },
                Entity = new AtlasEntity
                {
                    Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount.core.windows.net"),
["createTime"] = BinaryData.FromObjectAsJson(0),
["name"] = BinaryData.FromObjectAsJson("ExampleNewName")
},
                    TypeName = "azure_storage_account",
                    LastModifiedTS = "1",
                    CreateTime = default,
                    CreatedBy = "8c062c84-5d25-449f-a990-9d8ab70b8ec7",
                    Guid = "dc507ccf-0c57-4165-9327-f37b0d13fda0",
                    RelationshipAttributes =
{
["services"] = BinaryData.FromObjectAsJson(Array.Empty<object>()),
["meanings"] = BinaryData.FromObjectAsJson(Array.Empty<object>())
},
                    Status = EntityStatus.Active,
                    UpdateTime = default,
                    UpdatedBy = "8c062c84-5d25-449f-a990-9d8ab70b8ec7",
                    Version = 0L,
                },
            };
            Response<EntityMutationResult> response = client.UpdateByUniqueAttribute("azure_storage_account", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_UpdateByUniqueAttribute_EntityPartialUpdateByUniqueAttributes_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            AtlasEntityWithExtInfo body = new AtlasEntityWithExtInfo
            {
                ReferredEntities = { },
                Entity = new AtlasEntity
                {
                    Attributes =
{
["owner"] = BinaryData.FromObjectAsJson("ExampleOwner"),
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount.core.windows.net"),
["createTime"] = BinaryData.FromObjectAsJson(0),
["name"] = BinaryData.FromObjectAsJson("ExampleNewName")
},
                    TypeName = "azure_storage_account",
                    LastModifiedTS = "1",
                    CreateTime = default,
                    CreatedBy = "8c062c84-5d25-449f-a990-9d8ab70b8ec7",
                    Guid = "dc507ccf-0c57-4165-9327-f37b0d13fda0",
                    RelationshipAttributes =
{
["services"] = BinaryData.FromObjectAsJson(Array.Empty<object>()),
["meanings"] = BinaryData.FromObjectAsJson(Array.Empty<object>())
},
                    Status = EntityStatus.Active,
                    UpdateTime = default,
                    UpdatedBy = "8c062c84-5d25-449f-a990-9d8ab70b8ec7",
                    Version = 0L,
                },
            };
            Response<EntityMutationResult> response = await client.UpdateByUniqueAttributeAsync("azure_storage_account", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_DeleteByUniqueAttribute_EntityDeleteByUniqueAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.DeleteByUniqueAttribute("azure_storage_account", "https://exampleaccount.core.windows.net", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_DeleteByUniqueAttribute_EntityDeleteByUniqueAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.DeleteByUniqueAttributeAsync("azure_storage_account", "https://exampleaccount.core.windows.net", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_DeleteByUniqueAttribute_EntityDeleteByUniqueAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<EntityMutationResult> response = client.DeleteByUniqueAttribute("azure_storage_account");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_DeleteByUniqueAttribute_EntityDeleteByUniqueAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<EntityMutationResult> response = await client.DeleteByUniqueAttributeAsync("azure_storage_account");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_RemoveClassificationByUniqueAttribute_EntityRemoveClassificationByUniqueAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.RemoveClassificationByUniqueAttribute("column", "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_RemoveClassificationByUniqueAttribute_EntityRemoveClassificationByUniqueAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.RemoveClassificationByUniqueAttributeAsync("column", "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER");

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddClassificationsByUniqueAttribute_EntityAddClassificationsByUniqueAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
typeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
},
new
{
typeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
}
            });
            Response response = client.AddClassificationsByUniqueAttribute("azure_storage_account", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddClassificationsByUniqueAttribute_EntityAddClassificationsByUniqueAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
typeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
},
new
{
typeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
}
            });
            Response response = await client.AddClassificationsByUniqueAttributeAsync("azure_storage_account", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddClassificationsByUniqueAttribute_EntityAddClassificationsByUniqueAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.AddClassificationsByUniqueAttribute("azure_storage_account", new AtlasClassification[]
            {
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
},
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddClassificationsByUniqueAttribute_EntityAddClassificationsByUniqueAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.AddClassificationsByUniqueAttributeAsync("azure_storage_account", new AtlasClassification[]
            {
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
},
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_UpdateClassificationsUniqueByAttribute_EntityUpdateClassificationsByUniqueAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
typeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
},
new
{
typeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
}
            });
            Response response = client.UpdateClassificationsUniqueByAttribute("azure_storage_account", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_UpdateClassificationsUniqueByAttribute_EntityUpdateClassificationsByUniqueAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
new
{
typeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
},
new
{
typeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
}
            });
            Response response = await client.UpdateClassificationsUniqueByAttributeAsync("azure_storage_account", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_UpdateClassificationsUniqueByAttribute_EntityUpdateClassificationsByUniqueAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.UpdateClassificationsUniqueByAttribute("azure_storage_account", new AtlasClassification[]
            {
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
},
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_UpdateClassificationsUniqueByAttribute_EntityUpdateClassificationsByUniqueAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.UpdateClassificationsUniqueByAttributeAsync("azure_storage_account", new AtlasClassification[]
            {
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.US.ABA_ROUTING_NUMBER",
},
new AtlasClassification
{
TypeName = "MICROSOFT.FINANCIAL.CREDIT_CARD_NUMBER",
}
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_BatchSetClassifications_EntityBulkSetClassifications()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                guidHeaderMap = new Dictionary<string, object>
                {
                    ["9fb74c11-ac48-4650-95bc-760665c5bd92"] = new
                    {
                        attributes = new
                        {
                            qualifiedName = "https://exampleaccount1.core.windows.net",
                        },
                        typeName = "azure_storage_account",
                        classifications = new object[]
            {
new
{
typeName = "MICROSOFT.PERSONAL.EMAIL",
}
            },
                    },
                    ["7fcc43ab-55ea-45d4-9971-ce0443cb10bb"] = new
                    {
                        attributes = new
                        {
                            qualifiedName = "https://exampleaccount2.core.windows.net",
                        },
                        typeName = "azure_storage_account",
                        classifications = new object[]
            {
new
{
typeName = "MICROSOFT.PERSONAL.IPADDRESS",
}
            },
                    }
                },
            });
            Response response = client.BatchSetClassifications(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_BatchSetClassifications_EntityBulkSetClassifications_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                guidHeaderMap = new Dictionary<string, object>
                {
                    ["9fb74c11-ac48-4650-95bc-760665c5bd92"] = new
                    {
                        attributes = new
                        {
                            qualifiedName = "https://exampleaccount1.core.windows.net",
                        },
                        typeName = "azure_storage_account",
                        classifications = new object[]
            {
new
{
typeName = "MICROSOFT.PERSONAL.EMAIL",
}
            },
                    },
                    ["7fcc43ab-55ea-45d4-9971-ce0443cb10bb"] = new
                    {
                        attributes = new
                        {
                            qualifiedName = "https://exampleaccount2.core.windows.net",
                        },
                        typeName = "azure_storage_account",
                        classifications = new object[]
            {
new
{
typeName = "MICROSOFT.PERSONAL.IPADDRESS",
}
            },
                    }
                },
            });
            Response response = await client.BatchSetClassificationsAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result[0].ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_BatchSetClassifications_EntityBulkSetClassifications_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            AtlasEntityHeaders body = new AtlasEntityHeaders
            {
                GuidHeaderMap =
{
["9fb74c11-ac48-4650-95bc-760665c5bd92"] = new AtlasEntityHeader
{
Attributes =
{
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount1.core.windows.net")
},
TypeName = "azure_storage_account",
Classifications = {new AtlasClassification
{
TypeName = "MICROSOFT.PERSONAL.EMAIL",
}},
},
["7fcc43ab-55ea-45d4-9971-ce0443cb10bb"] = new AtlasEntityHeader
{
Attributes =
{
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount2.core.windows.net")
},
TypeName = "azure_storage_account",
Classifications = {new AtlasClassification
{
TypeName = "MICROSOFT.PERSONAL.IPADDRESS",
}},
}
},
            };
            Response<IReadOnlyList<string>> response = client.BatchSetClassifications(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_BatchSetClassifications_EntityBulkSetClassifications_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            AtlasEntityHeaders body = new AtlasEntityHeaders
            {
                GuidHeaderMap =
{
["9fb74c11-ac48-4650-95bc-760665c5bd92"] = new AtlasEntityHeader
{
Attributes =
{
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount1.core.windows.net")
},
TypeName = "azure_storage_account",
Classifications = {new AtlasClassification
{
TypeName = "MICROSOFT.PERSONAL.EMAIL",
}},
},
["7fcc43ab-55ea-45d4-9971-ce0443cb10bb"] = new AtlasEntityHeader
{
Attributes =
{
["qualifiedName"] = BinaryData.FromObjectAsJson("https://exampleaccount2.core.windows.net")
},
TypeName = "azure_storage_account",
Classifications = {new AtlasClassification
{
TypeName = "MICROSOFT.PERSONAL.IPADDRESS",
}},
}
},
            };
            Response<IReadOnlyList<string>> response = await client.BatchSetClassificationsAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_BatchGetByUniqueAttributes_EntityListByUniqueAttributes()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.BatchGetByUniqueAttributes("azure_storage_account", true, null, "adl://exampleaccount.azuredatalakestore.net/123/1/DP_TFS/CBT/Extensions/DTTP.targets#:xml/Project/PropertyGroup/ExampleName1", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_BatchGetByUniqueAttributes_EntityListByUniqueAttributes_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.BatchGetByUniqueAttributesAsync("azure_storage_account", true, null, "adl://exampleaccount.azuredatalakestore.net/123/1/DP_TFS/CBT/Extensions/DTTP.targets#:xml/Project/PropertyGroup/ExampleName1", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_BatchGetByUniqueAttributes_EntityListByUniqueAttributes_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasEntitiesWithExtInfo> response = client.BatchGetByUniqueAttributes("azure_storage_account");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_BatchGetByUniqueAttributes_EntityListByUniqueAttributes_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasEntitiesWithExtInfo> response = await client.BatchGetByUniqueAttributesAsync("azure_storage_account");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetHeader_EntityGetHeader()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.GetHeader("9fb74c11-ac48-4650-95bc-760665c5bd92", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetHeader_EntityGetHeader_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.GetHeaderAsync("9fb74c11-ac48-4650-95bc-760665c5bd92", null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetHeader_EntityGetHeader_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasEntityHeader> response = client.GetHeader("9fb74c11-ac48-4650-95bc-760665c5bd92");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetHeader_EntityGetHeader_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<AtlasEntityHeader> response = await client.GetHeaderAsync("9fb74c11-ac48-4650-95bc-760665c5bd92");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_RemoveBusinessMetadata_EntityRemoveBusinessMetadata()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                myBizMetadata1 = new
                {
                    bizAttr1 = "myBizMetaData1.bizAttr1",
                },
            });
            Response response = client.RemoveBusinessMetadata("02c373fe-2823-4be3-97fa-55180a9faa06", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_RemoveBusinessMetadata_EntityRemoveBusinessMetadata_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                myBizMetadata1 = new
                {
                    bizAttr1 = "myBizMetaData1.bizAttr1",
                },
            });
            Response response = await client.RemoveBusinessMetadataAsync("02c373fe-2823-4be3-97fa-55180a9faa06", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_RemoveBusinessMetadata_EntityRemoveBusinessMetadata_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.RemoveBusinessMetadata("02c373fe-2823-4be3-97fa-55180a9faa06", new Dictionary<string, IDictionary<string, BinaryData>>
            {
                ["myBizMetadata1"] = new Dictionary<string, BinaryData>
                {
                    ["bizAttr1"] = BinaryData.FromObjectAsJson("myBizMetaData1.bizAttr1")
                }
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_RemoveBusinessMetadata_EntityRemoveBusinessMetadata_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.RemoveBusinessMetadataAsync("02c373fe-2823-4be3-97fa-55180a9faa06", new Dictionary<string, IDictionary<string, BinaryData>>
            {
                ["myBizMetadata1"] = new Dictionary<string, BinaryData>
                {
                    ["bizAttr1"] = BinaryData.FromObjectAsJson("myBizMetaData1.bizAttr1")
                }
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddOrUpdateBusinessMetadata_EntityAddOrUpdateBusinessMetadata()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                myBizMetadata1 = new
                {
                    bizAttr1 = "myBizMetaData1.bizAttr1",
                },
            });
            Response response = client.AddOrUpdateBusinessMetadata("02c373fe-2823-4be3-97fa-55180a9faa06", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddOrUpdateBusinessMetadata_EntityAddOrUpdateBusinessMetadata_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                myBizMetadata1 = new
                {
                    bizAttr1 = "myBizMetaData1.bizAttr1",
                },
            });
            Response response = await client.AddOrUpdateBusinessMetadataAsync("02c373fe-2823-4be3-97fa-55180a9faa06", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddOrUpdateBusinessMetadata_EntityAddOrUpdateBusinessMetadata_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.AddOrUpdateBusinessMetadata("02c373fe-2823-4be3-97fa-55180a9faa06", new Dictionary<string, IDictionary<string, BinaryData>>
            {
                ["myBizMetadata1"] = new Dictionary<string, BinaryData>
                {
                    ["bizAttr1"] = BinaryData.FromObjectAsJson("myBizMetaData1.bizAttr1")
                }
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddOrUpdateBusinessMetadata_EntityAddOrUpdateBusinessMetadata_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.AddOrUpdateBusinessMetadataAsync("02c373fe-2823-4be3-97fa-55180a9faa06", new Dictionary<string, IDictionary<string, BinaryData>>
            {
                ["myBizMetadata1"] = new Dictionary<string, BinaryData>
                {
                    ["bizAttr1"] = BinaryData.FromObjectAsJson("myBizMetaData1.bizAttr1")
                }
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_RemoveBusinessMetadataAttributes_EntityRemoveBusinessAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                bizAttr1 = "bizAttr1",
            });
            Response response = client.RemoveBusinessMetadataAttributes("02c373fe-2823-4be3-97fa-55180a9faa06", "myBizMetaData1", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_RemoveBusinessMetadataAttributes_EntityRemoveBusinessAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                bizAttr1 = "bizAttr1",
            });
            Response response = await client.RemoveBusinessMetadataAttributesAsync("02c373fe-2823-4be3-97fa-55180a9faa06", "myBizMetaData1", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_RemoveBusinessMetadataAttributes_EntityRemoveBusinessAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.RemoveBusinessMetadataAttributes("02c373fe-2823-4be3-97fa-55180a9faa06", "myBizMetaData1", new Dictionary<string, BinaryData>
            {
                ["bizAttr1"] = BinaryData.FromObjectAsJson("bizAttr1")
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_RemoveBusinessMetadataAttributes_EntityRemoveBusinessAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.RemoveBusinessMetadataAttributesAsync("02c373fe-2823-4be3-97fa-55180a9faa06", "myBizMetaData1", new Dictionary<string, BinaryData>
            {
                ["bizAttr1"] = BinaryData.FromObjectAsJson("bizAttr1")
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddOrUpdateBusinessMetadataAttributes_EntityAddOrUpdateBusinessAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                bizAttr1 = "bizAttr1",
            });
            Response response = client.AddOrUpdateBusinessMetadataAttributes("02c373fe-2823-4be3-97fa-55180a9faa06", "myBizMetaData1", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddOrUpdateBusinessMetadataAttributes_EntityAddOrUpdateBusinessAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new
            {
                bizAttr1 = "bizAttr1",
            });
            Response response = await client.AddOrUpdateBusinessMetadataAttributesAsync("02c373fe-2823-4be3-97fa-55180a9faa06", "myBizMetaData1", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddOrUpdateBusinessMetadataAttributes_EntityAddOrUpdateBusinessAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.AddOrUpdateBusinessMetadataAttributes("02c373fe-2823-4be3-97fa-55180a9faa06", "myBizMetaData1", new Dictionary<string, BinaryData>
            {
                ["bizAttr1"] = BinaryData.FromObjectAsJson("bizAttr1")
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddOrUpdateBusinessMetadataAttributes_EntityAddOrUpdateBusinessAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.AddOrUpdateBusinessMetadataAttributesAsync("02c373fe-2823-4be3-97fa-55180a9faa06", "myBizMetaData1", new Dictionary<string, BinaryData>
            {
                ["bizAttr1"] = BinaryData.FromObjectAsJson("bizAttr1")
            });
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetBusinessMetadataTemplate_EntityGetSampleBusinessMetadataTemplate()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.GetBusinessMetadataTemplate(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetBusinessMetadataTemplate_EntityGetSampleBusinessMetadataTemplate_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.GetBusinessMetadataTemplateAsync(null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_GetBusinessMetadataTemplate_EntityGetSampleBusinessMetadataTemplate_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<BinaryData> response = client.GetBusinessMetadataTemplate();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_GetBusinessMetadataTemplate_EntityGetSampleBusinessMetadataTemplate_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response<BinaryData> response = await client.GetBusinessMetadataTemplateAsync();
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_ImportBusinessMetadata_EntityImportBusinessMetadata()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = null;
            Response response = client.ImportBusinessMetadata(content, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_ImportBusinessMetadata_EntityImportBusinessMetadata_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = null;
            Response response = await client.ImportBusinessMetadataAsync(content, null);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_ImportBusinessMetadata_EntityImportBusinessMetadata_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            BusinessMetadataOptions body = null;
            Response<BulkImportResult> response = client.ImportBusinessMetadata(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_ImportBusinessMetadata_EntityImportBusinessMetadata_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            BusinessMetadataOptions body = null;
            Response<BulkImportResult> response = await client.ImportBusinessMetadataAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_RemoveLabels_EntityRemoveLabels()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label1",
"label2"
            });
            Response response = client.RemoveLabels("02c373fe-2823-4be3-97fa-55180a9faa06", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_RemoveLabels_EntityRemoveLabels_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label1",
"label2"
            });
            Response response = await client.RemoveLabelsAsync("02c373fe-2823-4be3-97fa-55180a9faa06", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_RemoveLabels_EntityRemoveLabels_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.RemoveLabels("02c373fe-2823-4be3-97fa-55180a9faa06");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_RemoveLabels_EntityRemoveLabels_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.RemoveLabelsAsync("02c373fe-2823-4be3-97fa-55180a9faa06");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_SetLabels_EntitySetLabels()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label1",
"label2"
            });
            Response response = client.SetLabels("02c373fe-2823-4be3-97fa-55180a9faa06", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_SetLabels_EntitySetLabels_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label1",
"label2"
            });
            Response response = await client.SetLabelsAsync("02c373fe-2823-4be3-97fa-55180a9faa06", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_SetLabels_EntitySetLabels_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.SetLabels("02c373fe-2823-4be3-97fa-55180a9faa06");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_SetLabels_EntitySetLabels_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.SetLabelsAsync("02c373fe-2823-4be3-97fa-55180a9faa06");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddLabel_EntityAddLabel()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label1",
"label2"
            });
            Response response = client.AddLabel("02c373fe-2823-4be3-97fa-55180a9faa06", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddLabel_EntityAddLabel_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label1",
"label2"
            });
            Response response = await client.AddLabelAsync("02c373fe-2823-4be3-97fa-55180a9faa06", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddLabel_EntityAddLabel_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.AddLabel("02c373fe-2823-4be3-97fa-55180a9faa06");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddLabel_EntityAddLabel_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.AddLabelAsync("02c373fe-2823-4be3-97fa-55180a9faa06");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_RemoveLabelsByUniqueAttribute_EntityRemoveLabelsByUniqueAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label1"
            });
            Response response = client.RemoveLabelsByUniqueAttribute("Asset", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_RemoveLabelsByUniqueAttribute_EntityRemoveLabelsByUniqueAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label1"
            });
            Response response = await client.RemoveLabelsByUniqueAttributeAsync("Asset", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_RemoveLabelsByUniqueAttribute_EntityRemoveLabelsByUniqueAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.RemoveLabelsByUniqueAttribute("Asset");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_RemoveLabelsByUniqueAttribute_EntityRemoveLabelsByUniqueAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.RemoveLabelsByUniqueAttributeAsync("Asset");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_SetLabelsByUniqueAttribute_EntitySetLabelsByUniqueAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label1",
"label2"
            });
            Response response = client.SetLabelsByUniqueAttribute("Asset", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_SetLabelsByUniqueAttribute_EntitySetLabelsByUniqueAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label1",
"label2"
            });
            Response response = await client.SetLabelsByUniqueAttributeAsync("Asset", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_SetLabelsByUniqueAttribute_EntitySetLabelsByUniqueAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.SetLabelsByUniqueAttribute("Asset");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_SetLabelsByUniqueAttribute_EntitySetLabelsByUniqueAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.SetLabelsByUniqueAttributeAsync("Asset");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddLabelsByUniqueAttribute_EntityAddLabelsByUniqueAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label3"
            });
            Response response = client.AddLabelsByUniqueAttribute("Asset", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddLabelsByUniqueAttribute_EntityAddLabelsByUniqueAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            using RequestContent content = RequestContent.Create(new object[]
            {
"label3"
            });
            Response response = await client.AddLabelsByUniqueAttributeAsync("Asset", content);

            Console.WriteLine(response.Status);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_AddLabelsByUniqueAttribute_EntityAddLabelsByUniqueAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = client.AddLabelsByUniqueAttribute("Asset");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_AddLabelsByUniqueAttribute_EntityAddLabelsByUniqueAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient();

            Response response = await client.AddLabelsByUniqueAttributeAsync("Asset");
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_MoveEntitiesToCollection_EntityMoveEntitiesToCollection()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                entityGuids = new object[]
            {
"321493e3-3fb7-4b3e-9df7-3b69154174c2",
"b2f9c306-cf65-4bb0-878e-cfaafde156b1"
            },
            });
            Response response = client.MoveEntitiesToCollection("ExampleNewCollection", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_MoveEntitiesToCollection_EntityMoveEntitiesToCollection_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                entityGuids = new object[]
            {
"321493e3-3fb7-4b3e-9df7-3b69154174c2",
"b2f9c306-cf65-4bb0-878e-cfaafde156b1"
            },
            });
            Response response = await client.MoveEntitiesToCollectionAsync("ExampleNewCollection", content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Entity_MoveEntitiesToCollection_EntityMoveEntitiesToCollection_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            MoveEntitiesConfig body = new MoveEntitiesConfig
            {
                EntityGuids = { "321493e3-3fb7-4b3e-9df7-3b69154174c2", "b2f9c306-cf65-4bb0-878e-cfaafde156b1" },
            };
            Response<EntityMutationResult> response = client.MoveEntitiesToCollection("ExampleNewCollection", body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Entity_MoveEntitiesToCollection_EntityMoveEntitiesToCollection_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Entity client = new DataMapClient(endpoint, credential).GetEntityClient(apiVersion: "2023-09-01");

            MoveEntitiesConfig body = new MoveEntitiesConfig
            {
                EntityGuids = { "321493e3-3fb7-4b3e-9df7-3b69154174c2", "b2f9c306-cf65-4bb0-878e-cfaafde156b1" },
            };
            Response<EntityMutationResult> response = await client.MoveEntitiesToCollectionAsync("ExampleNewCollection", body);
        }
    }
}
