// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Text.Json;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Identity;
using NUnit.Framework;

namespace Azure.Analytics.Purview.DataMap.Samples
{
    public partial class Samples_Discovery
    {
        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQuery()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4600",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4601",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "4602",
["entityType"] = "azure_blob_path"
}
            }
                },
                limit = 10,
                orderby = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4606",
["name"] = "ASC"
},
new Dictionary<string, object>
{
["$id"] = "4608",
["updateTime"] = "DESC"
}
            },
                facets = new object[]
            {
new
{
facet = "assetType",
count = 0,
sort = new
{
count = "desc",
},
},
new
{
facet = "classification",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "contactId",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "label",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "term",
count = 10,
sort = new
{
count = "desc",
},
}
            },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQuery_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4600",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4601",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "4602",
["entityType"] = "azure_blob_path"
}
            }
                },
                limit = 10,
                orderby = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4606",
["name"] = "ASC"
},
new Dictionary<string, object>
{
["$id"] = "4608",
["updateTime"] = "DESC"
}
            },
                facets = new object[]
            {
new
{
facet = "assetType",
count = 0,
sort = new
{
count = "desc",
},
},
new
{
facet = "classification",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "contactId",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "label",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "term",
count = 10,
sort = new
{
count = "desc",
},
}
            },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQuery_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "exampledata",
                Limit = 10,
                Orderby = {BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "4606",
["name"] = "ASC"
}), BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "4608",
["updateTime"] = "DESC"
})},
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4600",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4601",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "4602",
["entityType"] = "azure_blob_path"
}
            }
                }),
                Facets = {new SearchFacetItem
{
Count = 0,
Facet = "assetType",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "classification",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "contactId",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "label",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "term",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}},
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQuery_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "exampledata",
                Limit = 10,
                Orderby = {BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "4606",
["name"] = "ASC"
}), BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "4608",
["updateTime"] = "DESC"
})},
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4600",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4601",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "4602",
["entityType"] = "azure_blob_path"
}
            }
                }),
                Facets = {new SearchFacetItem
{
Count = 0,
Facet = "assetType",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "classification",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "contactId",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "label",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "term",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}},
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryAnd()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4685",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4686",
["entityType"] = "azure_blob_path"
},
new Dictionary<string, object>
{
["$id"] = "4687",
["attributeName"] = "qualifiedName",
["operator"] = "contains",
["attributeValue"] = ".csv"
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryAnd_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4685",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4686",
["entityType"] = "azure_blob_path"
},
new Dictionary<string, object>
{
["$id"] = "4687",
["attributeName"] = "qualifiedName",
["operator"] = "contains",
["attributeValue"] = ".csv"
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryAnd_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4685",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4686",
["entityType"] = "azure_blob_path"
},
new Dictionary<string, object>
{
["$id"] = "4687",
["attributeName"] = "qualifiedName",
["operator"] = "contains",
["attributeValue"] = ".csv"
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryAnd_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4685",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4686",
["entityType"] = "azure_blob_path"
},
new Dictionary<string, object>
{
["$id"] = "4687",
["attributeName"] = "qualifiedName",
["operator"] = "contains",
["attributeValue"] = ".csv"
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryAndOrNested()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4738",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4739",
["entityType"] = "azure_blob_path"
},
new Dictionary<string, object>
{
["$id"] = "4740",
["attributeName"] = "qualifiedName",
["operator"] = "contains",
["attributeValue"] = ".csv"
},
new Dictionary<string, object>
{
["$id"] = "4741",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "4742",
["attributeName"] = "name",
["operator"] = "eq",
["attributeValue"] = "exampledata.csv"
},
new Dictionary<string, object>
{
["$id"] = "4743",
["attributeName"] = "qualifiedName",
["operator"] = "prefix",
["attributeValue"] = "https://"
}
}
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryAndOrNested_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4738",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4739",
["entityType"] = "azure_blob_path"
},
new Dictionary<string, object>
{
["$id"] = "4740",
["attributeName"] = "qualifiedName",
["operator"] = "contains",
["attributeValue"] = ".csv"
},
new Dictionary<string, object>
{
["$id"] = "4741",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "4742",
["attributeName"] = "name",
["operator"] = "eq",
["attributeValue"] = "exampledata.csv"
},
new Dictionary<string, object>
{
["$id"] = "4743",
["attributeName"] = "qualifiedName",
["operator"] = "prefix",
["attributeValue"] = "https://"
}
}
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryAndOrNested_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4738",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4739",
["entityType"] = "azure_blob_path"
},
new Dictionary<string, object>
{
["$id"] = "4740",
["attributeName"] = "qualifiedName",
["operator"] = "contains",
["attributeValue"] = ".csv"
},
new Dictionary<string, object>
{
["$id"] = "4741",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "4742",
["attributeName"] = "name",
["operator"] = "eq",
["attributeValue"] = "exampledata.csv"
},
new Dictionary<string, object>
{
["$id"] = "4743",
["attributeName"] = "qualifiedName",
["operator"] = "prefix",
["attributeValue"] = "https://"
}
}
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryAndOrNested_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4738",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4739",
["entityType"] = "azure_blob_path"
},
new Dictionary<string, object>
{
["$id"] = "4740",
["attributeName"] = "qualifiedName",
["operator"] = "contains",
["attributeValue"] = ".csv"
},
new Dictionary<string, object>
{
["$id"] = "4741",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "4742",
["attributeName"] = "name",
["operator"] = "eq",
["attributeValue"] = "exampledata.csv"
},
new Dictionary<string, object>
{
["$id"] = "4743",
["attributeName"] = "qualifiedName",
["operator"] = "prefix",
["attributeValue"] = "https://"
}
}
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryAssetType()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4796",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4797",
["assetType"] = "SQL Server"
},
new Dictionary<string, object>
{
["$id"] = "4798",
["assetType"] = "Azure SQL Server"
},
new Dictionary<string, object>
{
["$id"] = "4799",
["assetType"] = "Azure SQL Database"
},
new Dictionary<string, object>
{
["$id"] = "4800",
["assetType"] = "Azure SQL Data Warehouse"
},
new Dictionary<string, object>
{
["$id"] = "4801",
["assetType"] = "Azure SQL Managed Instance"
},
new Dictionary<string, object>
{
["$id"] = "4802",
["assetType"] = "Azure Storage Account"
},
new Dictionary<string, object>
{
["$id"] = "4803",
["assetType"] = "Azure Blob Storage"
},
new Dictionary<string, object>
{
["$id"] = "4804",
["assetType"] = "Azure Files"
},
new Dictionary<string, object>
{
["$id"] = "4805",
["assetType"] = "Azure Table Storage"
},
new Dictionary<string, object>
{
["$id"] = "4806",
["assetType"] = "Azure Data Lake Storage Gen1"
},
new Dictionary<string, object>
{
["$id"] = "4807",
["assetType"] = "Azure Data Lake Storage Gen2"
},
new Dictionary<string, object>
{
["$id"] = "4808",
["assetType"] = "Azure Cosmos DB"
},
new Dictionary<string, object>
{
["$id"] = "4809",
["assetType"] = "Azure Data Factory"
},
new Dictionary<string, object>
{
["$id"] = "4810",
["assetType"] = "Azure Cognitive Search"
},
new Dictionary<string, object>
{
["$id"] = "4811",
["assetType"] = "Power BI"
},
new Dictionary<string, object>
{
["$id"] = "4812",
["assetType"] = "Azure Data Explorer"
},
new Dictionary<string, object>
{
["$id"] = "4813",
["assetType"] = "Amazon S3"
},
new Dictionary<string, object>
{
["$id"] = "4814",
["assetType"] = "Azure Data Share"
},
new Dictionary<string, object>
{
["$id"] = "4815",
["assetType"] = "Teradata"
},
new Dictionary<string, object>
{
["$id"] = "4816",
["assetType"] = "SAP S4HANA"
},
new Dictionary<string, object>
{
["$id"] = "4817",
["assetType"] = "SAP ECC"
},
new Dictionary<string, object>
{
["$id"] = "4818",
["assetType"] = "SQL Server Integration Services"
},
new Dictionary<string, object>
{
["$id"] = "4819",
["assetType"] = "hive"
},
new Dictionary<string, object>
{
["$id"] = "4820",
["assetType"] = "Azure Database for MySQL"
},
new Dictionary<string, object>
{
["$id"] = "4821",
["assetType"] = "Azure Database for MariaDB"
},
new Dictionary<string, object>
{
["$id"] = "4822",
["assetType"] = "Azure Database for PostgreSQL"
},
new Dictionary<string, object>
{
["$id"] = "4823",
["assetType"] = "Azure Synapse Analytics"
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryAssetType_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4796",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4797",
["assetType"] = "SQL Server"
},
new Dictionary<string, object>
{
["$id"] = "4798",
["assetType"] = "Azure SQL Server"
},
new Dictionary<string, object>
{
["$id"] = "4799",
["assetType"] = "Azure SQL Database"
},
new Dictionary<string, object>
{
["$id"] = "4800",
["assetType"] = "Azure SQL Data Warehouse"
},
new Dictionary<string, object>
{
["$id"] = "4801",
["assetType"] = "Azure SQL Managed Instance"
},
new Dictionary<string, object>
{
["$id"] = "4802",
["assetType"] = "Azure Storage Account"
},
new Dictionary<string, object>
{
["$id"] = "4803",
["assetType"] = "Azure Blob Storage"
},
new Dictionary<string, object>
{
["$id"] = "4804",
["assetType"] = "Azure Files"
},
new Dictionary<string, object>
{
["$id"] = "4805",
["assetType"] = "Azure Table Storage"
},
new Dictionary<string, object>
{
["$id"] = "4806",
["assetType"] = "Azure Data Lake Storage Gen1"
},
new Dictionary<string, object>
{
["$id"] = "4807",
["assetType"] = "Azure Data Lake Storage Gen2"
},
new Dictionary<string, object>
{
["$id"] = "4808",
["assetType"] = "Azure Cosmos DB"
},
new Dictionary<string, object>
{
["$id"] = "4809",
["assetType"] = "Azure Data Factory"
},
new Dictionary<string, object>
{
["$id"] = "4810",
["assetType"] = "Azure Cognitive Search"
},
new Dictionary<string, object>
{
["$id"] = "4811",
["assetType"] = "Power BI"
},
new Dictionary<string, object>
{
["$id"] = "4812",
["assetType"] = "Azure Data Explorer"
},
new Dictionary<string, object>
{
["$id"] = "4813",
["assetType"] = "Amazon S3"
},
new Dictionary<string, object>
{
["$id"] = "4814",
["assetType"] = "Azure Data Share"
},
new Dictionary<string, object>
{
["$id"] = "4815",
["assetType"] = "Teradata"
},
new Dictionary<string, object>
{
["$id"] = "4816",
["assetType"] = "SAP S4HANA"
},
new Dictionary<string, object>
{
["$id"] = "4817",
["assetType"] = "SAP ECC"
},
new Dictionary<string, object>
{
["$id"] = "4818",
["assetType"] = "SQL Server Integration Services"
},
new Dictionary<string, object>
{
["$id"] = "4819",
["assetType"] = "hive"
},
new Dictionary<string, object>
{
["$id"] = "4820",
["assetType"] = "Azure Database for MySQL"
},
new Dictionary<string, object>
{
["$id"] = "4821",
["assetType"] = "Azure Database for MariaDB"
},
new Dictionary<string, object>
{
["$id"] = "4822",
["assetType"] = "Azure Database for PostgreSQL"
},
new Dictionary<string, object>
{
["$id"] = "4823",
["assetType"] = "Azure Synapse Analytics"
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryAssetType_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4796",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4797",
["assetType"] = "SQL Server"
},
new Dictionary<string, object>
{
["$id"] = "4798",
["assetType"] = "Azure SQL Server"
},
new Dictionary<string, object>
{
["$id"] = "4799",
["assetType"] = "Azure SQL Database"
},
new Dictionary<string, object>
{
["$id"] = "4800",
["assetType"] = "Azure SQL Data Warehouse"
},
new Dictionary<string, object>
{
["$id"] = "4801",
["assetType"] = "Azure SQL Managed Instance"
},
new Dictionary<string, object>
{
["$id"] = "4802",
["assetType"] = "Azure Storage Account"
},
new Dictionary<string, object>
{
["$id"] = "4803",
["assetType"] = "Azure Blob Storage"
},
new Dictionary<string, object>
{
["$id"] = "4804",
["assetType"] = "Azure Files"
},
new Dictionary<string, object>
{
["$id"] = "4805",
["assetType"] = "Azure Table Storage"
},
new Dictionary<string, object>
{
["$id"] = "4806",
["assetType"] = "Azure Data Lake Storage Gen1"
},
new Dictionary<string, object>
{
["$id"] = "4807",
["assetType"] = "Azure Data Lake Storage Gen2"
},
new Dictionary<string, object>
{
["$id"] = "4808",
["assetType"] = "Azure Cosmos DB"
},
new Dictionary<string, object>
{
["$id"] = "4809",
["assetType"] = "Azure Data Factory"
},
new Dictionary<string, object>
{
["$id"] = "4810",
["assetType"] = "Azure Cognitive Search"
},
new Dictionary<string, object>
{
["$id"] = "4811",
["assetType"] = "Power BI"
},
new Dictionary<string, object>
{
["$id"] = "4812",
["assetType"] = "Azure Data Explorer"
},
new Dictionary<string, object>
{
["$id"] = "4813",
["assetType"] = "Amazon S3"
},
new Dictionary<string, object>
{
["$id"] = "4814",
["assetType"] = "Azure Data Share"
},
new Dictionary<string, object>
{
["$id"] = "4815",
["assetType"] = "Teradata"
},
new Dictionary<string, object>
{
["$id"] = "4816",
["assetType"] = "SAP S4HANA"
},
new Dictionary<string, object>
{
["$id"] = "4817",
["assetType"] = "SAP ECC"
},
new Dictionary<string, object>
{
["$id"] = "4818",
["assetType"] = "SQL Server Integration Services"
},
new Dictionary<string, object>
{
["$id"] = "4819",
["assetType"] = "hive"
},
new Dictionary<string, object>
{
["$id"] = "4820",
["assetType"] = "Azure Database for MySQL"
},
new Dictionary<string, object>
{
["$id"] = "4821",
["assetType"] = "Azure Database for MariaDB"
},
new Dictionary<string, object>
{
["$id"] = "4822",
["assetType"] = "Azure Database for PostgreSQL"
},
new Dictionary<string, object>
{
["$id"] = "4823",
["assetType"] = "Azure Synapse Analytics"
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryAssetType_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4796",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4797",
["assetType"] = "SQL Server"
},
new Dictionary<string, object>
{
["$id"] = "4798",
["assetType"] = "Azure SQL Server"
},
new Dictionary<string, object>
{
["$id"] = "4799",
["assetType"] = "Azure SQL Database"
},
new Dictionary<string, object>
{
["$id"] = "4800",
["assetType"] = "Azure SQL Data Warehouse"
},
new Dictionary<string, object>
{
["$id"] = "4801",
["assetType"] = "Azure SQL Managed Instance"
},
new Dictionary<string, object>
{
["$id"] = "4802",
["assetType"] = "Azure Storage Account"
},
new Dictionary<string, object>
{
["$id"] = "4803",
["assetType"] = "Azure Blob Storage"
},
new Dictionary<string, object>
{
["$id"] = "4804",
["assetType"] = "Azure Files"
},
new Dictionary<string, object>
{
["$id"] = "4805",
["assetType"] = "Azure Table Storage"
},
new Dictionary<string, object>
{
["$id"] = "4806",
["assetType"] = "Azure Data Lake Storage Gen1"
},
new Dictionary<string, object>
{
["$id"] = "4807",
["assetType"] = "Azure Data Lake Storage Gen2"
},
new Dictionary<string, object>
{
["$id"] = "4808",
["assetType"] = "Azure Cosmos DB"
},
new Dictionary<string, object>
{
["$id"] = "4809",
["assetType"] = "Azure Data Factory"
},
new Dictionary<string, object>
{
["$id"] = "4810",
["assetType"] = "Azure Cognitive Search"
},
new Dictionary<string, object>
{
["$id"] = "4811",
["assetType"] = "Power BI"
},
new Dictionary<string, object>
{
["$id"] = "4812",
["assetType"] = "Azure Data Explorer"
},
new Dictionary<string, object>
{
["$id"] = "4813",
["assetType"] = "Amazon S3"
},
new Dictionary<string, object>
{
["$id"] = "4814",
["assetType"] = "Azure Data Share"
},
new Dictionary<string, object>
{
["$id"] = "4815",
["assetType"] = "Teradata"
},
new Dictionary<string, object>
{
["$id"] = "4816",
["assetType"] = "SAP S4HANA"
},
new Dictionary<string, object>
{
["$id"] = "4817",
["assetType"] = "SAP ECC"
},
new Dictionary<string, object>
{
["$id"] = "4818",
["assetType"] = "SQL Server Integration Services"
},
new Dictionary<string, object>
{
["$id"] = "4819",
["assetType"] = "hive"
},
new Dictionary<string, object>
{
["$id"] = "4820",
["assetType"] = "Azure Database for MySQL"
},
new Dictionary<string, object>
{
["$id"] = "4821",
["assetType"] = "Azure Database for MariaDB"
},
new Dictionary<string, object>
{
["$id"] = "4822",
["assetType"] = "Azure Database for PostgreSQL"
},
new Dictionary<string, object>
{
["$id"] = "4823",
["assetType"] = "Azure Synapse Analytics"
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4865",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4866",
["attributeName"] = "name",
["operator"] = "eq",
["attributeValue"] = "exampledata.csv"
},
new Dictionary<string, object>
{
["$id"] = "4867",
["attributeName"] = "createTime",
["operator"] = "ge",
["attributeValue"] = 1545580800000L
},
new Dictionary<string, object>
{
["$id"] = "4868",
["attributeName"] = "modifiedTime",
["operator"] = "timerange",
["attributeValue"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4865",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4866",
["attributeName"] = "name",
["operator"] = "eq",
["attributeValue"] = "exampledata.csv"
},
new Dictionary<string, object>
{
["$id"] = "4867",
["attributeName"] = "createTime",
["operator"] = "ge",
["attributeValue"] = 1545580800000L
},
new Dictionary<string, object>
{
["$id"] = "4868",
["attributeName"] = "modifiedTime",
["operator"] = "timerange",
["attributeValue"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4865",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4866",
["attributeName"] = "name",
["operator"] = "eq",
["attributeValue"] = "exampledata.csv"
},
new Dictionary<string, object>
{
["$id"] = "4867",
["attributeName"] = "createTime",
["operator"] = "ge",
["attributeValue"] = 1545580800000L
},
new Dictionary<string, object>
{
["$id"] = "4868",
["attributeName"] = "modifiedTime",
["operator"] = "timerange",
["attributeValue"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4865",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4866",
["attributeName"] = "name",
["operator"] = "eq",
["attributeValue"] = "exampledata.csv"
},
new Dictionary<string, object>
{
["$id"] = "4867",
["attributeName"] = "createTime",
["operator"] = "ge",
["attributeValue"] = 1545580800000L
},
new Dictionary<string, object>
{
["$id"] = "4868",
["attributeName"] = "modifiedTime",
["operator"] = "timerange",
["attributeValue"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryBusinessMetadataAttribute()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4930",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4931",
["attributeName"] = "<BusinessMetadataName>.<StringAttributeName>",
["operator"] = "eq|ne|contains|prefix",
["attributeValue"] = "string value"
},
new Dictionary<string, object>
{
["$id"] = "4932",
["attributeName"] = "<BusinessMetadataName>.<NumberAttributeName>",
["operator"] = "eq|ne|gt|ge|lt|le",
["attributeValue"] = 123
},
new Dictionary<string, object>
{
["$id"] = "4933",
["attributeName"] = "<BusinessMetadataName>.<BooleanAttributeName>",
["operator"] = "eq|ne",
["attributeValue"] = true
},
new Dictionary<string, object>
{
["$id"] = "4934",
["attributeName"] = "<BusinessMetadataName>.<DateAttributeName>",
["operator"] = "timerange",
["attributeValue"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryBusinessMetadataAttribute_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4930",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4931",
["attributeName"] = "<BusinessMetadataName>.<StringAttributeName>",
["operator"] = "eq|ne|contains|prefix",
["attributeValue"] = "string value"
},
new Dictionary<string, object>
{
["$id"] = "4932",
["attributeName"] = "<BusinessMetadataName>.<NumberAttributeName>",
["operator"] = "eq|ne|gt|ge|lt|le",
["attributeValue"] = 123
},
new Dictionary<string, object>
{
["$id"] = "4933",
["attributeName"] = "<BusinessMetadataName>.<BooleanAttributeName>",
["operator"] = "eq|ne",
["attributeValue"] = true
},
new Dictionary<string, object>
{
["$id"] = "4934",
["attributeName"] = "<BusinessMetadataName>.<DateAttributeName>",
["operator"] = "timerange",
["attributeValue"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryBusinessMetadataAttribute_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4930",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4931",
["attributeName"] = "<BusinessMetadataName>.<StringAttributeName>",
["operator"] = "eq|ne|contains|prefix",
["attributeValue"] = "string value"
},
new Dictionary<string, object>
{
["$id"] = "4932",
["attributeName"] = "<BusinessMetadataName>.<NumberAttributeName>",
["operator"] = "eq|ne|gt|ge|lt|le",
["attributeValue"] = 123
},
new Dictionary<string, object>
{
["$id"] = "4933",
["attributeName"] = "<BusinessMetadataName>.<BooleanAttributeName>",
["operator"] = "eq|ne",
["attributeValue"] = true
},
new Dictionary<string, object>
{
["$id"] = "4934",
["attributeName"] = "<BusinessMetadataName>.<DateAttributeName>",
["operator"] = "timerange",
["attributeValue"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryBusinessMetadataAttribute_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4930",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "4931",
["attributeName"] = "<BusinessMetadataName>.<StringAttributeName>",
["operator"] = "eq|ne|contains|prefix",
["attributeValue"] = "string value"
},
new Dictionary<string, object>
{
["$id"] = "4932",
["attributeName"] = "<BusinessMetadataName>.<NumberAttributeName>",
["operator"] = "eq|ne|gt|ge|lt|le",
["attributeValue"] = 123
},
new Dictionary<string, object>
{
["$id"] = "4933",
["attributeName"] = "<BusinessMetadataName>.<BooleanAttributeName>",
["operator"] = "eq|ne",
["attributeValue"] = true
},
new Dictionary<string, object>
{
["$id"] = "4934",
["attributeName"] = "<BusinessMetadataName>.<DateAttributeName>",
["operator"] = "timerange",
["attributeValue"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryClassification()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4957",
                    ["classification"] = "MICROSOFT.PERSONAL.EMAIL",
                    ["includeSubClassifications"] = true
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryClassification_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "4957",
                    ["classification"] = "MICROSOFT.PERSONAL.EMAIL",
                    ["includeSubClassifications"] = true
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryClassification_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4957",
                    ["classification"] = "MICROSOFT.PERSONAL.EMAIL",
                    ["includeSubClassifications"] = true
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryClassification_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "4957",
                    ["classification"] = "MICROSOFT.PERSONAL.EMAIL",
                    ["includeSubClassifications"] = true
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryCollection()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5007",
                    ["collectionId"] = "collectionName"
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryCollection_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5007",
                    ["collectionId"] = "collectionName"
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryCollection_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5007",
                    ["collectionId"] = "collectionName"
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryCollection_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5007",
                    ["collectionId"] = "collectionName"
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryFacet()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5056",
                    ["objectType"] = "Tables"
                },
                limit = 10,
                facets = new object[]
            {
new
{
facet = "assetType",
count = 10,
},
new
{
facet = "classification",
count = 10,
},
new
{
facet = "term",
count = 10,
},
new
{
facet = "label",
count = 10,
}
            },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryFacet_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5056",
                    ["objectType"] = "Tables"
                },
                limit = 10,
                facets = new object[]
            {
new
{
facet = "assetType",
count = 10,
},
new
{
facet = "classification",
count = 10,
},
new
{
facet = "term",
count = 10,
},
new
{
facet = "label",
count = 10,
}
            },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryFacet_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5056",
                    ["objectType"] = "Tables"
                }),
                Facets = {new SearchFacetItem
{
Count = 10,
Facet = "assetType",
}, new SearchFacetItem
{
Count = 10,
Facet = "classification",
}, new SearchFacetItem
{
Count = 10,
Facet = "term",
}, new SearchFacetItem
{
Count = 10,
Facet = "label",
}},
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryFacet_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5056",
                    ["objectType"] = "Tables"
                }),
                Facets = {new SearchFacetItem
{
Count = 10,
Facet = "assetType",
}, new SearchFacetItem
{
Count = 10,
Facet = "classification",
}, new SearchFacetItem
{
Count = 10,
Facet = "term",
}, new SearchFacetItem
{
Count = 10,
Facet = "label",
}},
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryFileExtension()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5186",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5187",
["fileExtension"] = "txt"
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryFileExtension_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5186",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5187",
["fileExtension"] = "txt"
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryFileExtension_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5186",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5187",
["fileExtension"] = "txt"
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryFileExtension_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5186",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5187",
["fileExtension"] = "txt"
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryGlossaryTerm()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "<term name>",
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5230",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5231",
["objectType"] = "Glossary terms"
},
new Dictionary<string, object>
{
["$id"] = "5232",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "5233",
["glossaryType"] = "AtlasGlossary"
},
new Dictionary<string, object>
{
["$id"] = "5234",
["glossaryType"] = "AtlasGlossaryTerm"
}
}
}
            }
                },
                facets = new object[]
            {
new
{
facet = "termStatus",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "termTemplate",
count = 10,
sort = new
{
count = "desc",
},
}
            },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryGlossaryTerm_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "<term name>",
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5230",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5231",
["objectType"] = "Glossary terms"
},
new Dictionary<string, object>
{
["$id"] = "5232",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "5233",
["glossaryType"] = "AtlasGlossary"
},
new Dictionary<string, object>
{
["$id"] = "5234",
["glossaryType"] = "AtlasGlossaryTerm"
}
}
}
            }
                },
                facets = new object[]
            {
new
{
facet = "termStatus",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "termTemplate",
count = 10,
sort = new
{
count = "desc",
},
}
            },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryGlossaryTerm_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "<term name>",
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5230",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5231",
["objectType"] = "Glossary terms"
},
new Dictionary<string, object>
{
["$id"] = "5232",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "5233",
["glossaryType"] = "AtlasGlossary"
},
new Dictionary<string, object>
{
["$id"] = "5234",
["glossaryType"] = "AtlasGlossaryTerm"
}
}
}
            }
                }),
                Facets = {new SearchFacetItem
{
Count = 10,
Facet = "termStatus",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "termTemplate",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}},
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryGlossaryTerm_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "<term name>",
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5230",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5231",
["objectType"] = "Glossary terms"
},
new Dictionary<string, object>
{
["$id"] = "5232",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "5233",
["glossaryType"] = "AtlasGlossary"
},
new Dictionary<string, object>
{
["$id"] = "5234",
["glossaryType"] = "AtlasGlossaryTerm"
}
}
}
            }
                }),
                Facets = {new SearchFacetItem
{
Count = 10,
Facet = "termStatus",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "termTemplate",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}},
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryId()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5302",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5303",
["id"] = "bfecbcc3-1838-45fe-96d6-112de8a170f9"
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryId_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5302",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5303",
["id"] = "bfecbcc3-1838-45fe-96d6-112de8a170f9"
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryId_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5302",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5303",
["id"] = "bfecbcc3-1838-45fe-96d6-112de8a170f9"
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryId_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5302",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5303",
["id"] = "bfecbcc3-1838-45fe-96d6-112de8a170f9"
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryNot()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5331",
                    ["not"] = new Dictionary<string, object>
                    {
                        ["$id"] = "5332",
                        ["classification"] = "MICROSOFT.SYSTEM.TEMP_FILE"
                    }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryNot_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5331",
                    ["not"] = new Dictionary<string, object>
                    {
                        ["$id"] = "5332",
                        ["classification"] = "MICROSOFT.SYSTEM.TEMP_FILE"
                    }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryNot_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5331",
                    ["not"] = new Dictionary<string, object>
                    {
                        ["$id"] = "5332",
                        ["classification"] = "MICROSOFT.SYSTEM.TEMP_FILE"
                    }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryNot_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5331",
                    ["not"] = new Dictionary<string, object>
                    {
                        ["$id"] = "5332",
                        ["classification"] = "MICROSOFT.SYSTEM.TEMP_FILE"
                    }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryObjectType()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5374",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5375",
["objectType"] = "Dashboards"
},
new Dictionary<string, object>
{
["$id"] = "5376",
["objectType"] = "Data pipelines"
},
new Dictionary<string, object>
{
["$id"] = "5377",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5378",
["objectType"] = "Folders"
},
new Dictionary<string, object>
{
["$id"] = "5379",
["objectType"] = "Glossary terms"
},
new Dictionary<string, object>
{
["$id"] = "5380",
["objectType"] = "Reports"
},
new Dictionary<string, object>
{
["$id"] = "5381",
["objectType"] = "Stored procedures"
},
new Dictionary<string, object>
{
["$id"] = "5382",
["objectType"] = "Tables"
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryObjectType_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5374",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5375",
["objectType"] = "Dashboards"
},
new Dictionary<string, object>
{
["$id"] = "5376",
["objectType"] = "Data pipelines"
},
new Dictionary<string, object>
{
["$id"] = "5377",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5378",
["objectType"] = "Folders"
},
new Dictionary<string, object>
{
["$id"] = "5379",
["objectType"] = "Glossary terms"
},
new Dictionary<string, object>
{
["$id"] = "5380",
["objectType"] = "Reports"
},
new Dictionary<string, object>
{
["$id"] = "5381",
["objectType"] = "Stored procedures"
},
new Dictionary<string, object>
{
["$id"] = "5382",
["objectType"] = "Tables"
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryObjectType_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5374",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5375",
["objectType"] = "Dashboards"
},
new Dictionary<string, object>
{
["$id"] = "5376",
["objectType"] = "Data pipelines"
},
new Dictionary<string, object>
{
["$id"] = "5377",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5378",
["objectType"] = "Folders"
},
new Dictionary<string, object>
{
["$id"] = "5379",
["objectType"] = "Glossary terms"
},
new Dictionary<string, object>
{
["$id"] = "5380",
["objectType"] = "Reports"
},
new Dictionary<string, object>
{
["$id"] = "5381",
["objectType"] = "Stored procedures"
},
new Dictionary<string, object>
{
["$id"] = "5382",
["objectType"] = "Tables"
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryObjectType_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5374",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5375",
["objectType"] = "Dashboards"
},
new Dictionary<string, object>
{
["$id"] = "5376",
["objectType"] = "Data pipelines"
},
new Dictionary<string, object>
{
["$id"] = "5377",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5378",
["objectType"] = "Folders"
},
new Dictionary<string, object>
{
["$id"] = "5379",
["objectType"] = "Glossary terms"
},
new Dictionary<string, object>
{
["$id"] = "5380",
["objectType"] = "Reports"
},
new Dictionary<string, object>
{
["$id"] = "5381",
["objectType"] = "Stored procedures"
},
new Dictionary<string, object>
{
["$id"] = "5382",
["objectType"] = "Tables"
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryPaginationContinuationPage()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5420",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5421",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5422",
["entityType"] = "azure_blob_path"
}
            }
                },
                limit = 2,
                continuationToken = "<token>",
                orderby = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5427",
["name"] = "ASC"
},
new Dictionary<string, object>
{
["$id"] = "5429",
["updateTime"] = "DESC"
}
            },
                facets = new object[]
            {
new
{
facet = "assetType",
count = 0,
sort = new
{
count = "desc",
},
},
new
{
facet = "classification",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "contactId",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "label",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "term",
count = 10,
sort = new
{
count = "desc",
},
}
            },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryPaginationContinuationPage_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5420",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5421",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5422",
["entityType"] = "azure_blob_path"
}
            }
                },
                limit = 2,
                continuationToken = "<token>",
                orderby = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5427",
["name"] = "ASC"
},
new Dictionary<string, object>
{
["$id"] = "5429",
["updateTime"] = "DESC"
}
            },
                facets = new object[]
            {
new
{
facet = "assetType",
count = 0,
sort = new
{
count = "desc",
},
},
new
{
facet = "classification",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "contactId",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "label",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "term",
count = 10,
sort = new
{
count = "desc",
},
}
            },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryPaginationContinuationPage_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "exampledata",
                Limit = 2,
                ContinuationToken = "<token>",
                Orderby = {BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5427",
["name"] = "ASC"
}), BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5429",
["updateTime"] = "DESC"
})},
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5420",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5421",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5422",
["entityType"] = "azure_blob_path"
}
            }
                }),
                Facets = {new SearchFacetItem
{
Count = 0,
Facet = "assetType",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "classification",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "contactId",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "label",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "term",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}},
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryPaginationContinuationPage_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "exampledata",
                Limit = 2,
                ContinuationToken = "<token>",
                Orderby = {BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5427",
["name"] = "ASC"
}), BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5429",
["updateTime"] = "DESC"
})},
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5420",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5421",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5422",
["entityType"] = "azure_blob_path"
}
            }
                }),
                Facets = {new SearchFacetItem
{
Count = 0,
Facet = "assetType",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "classification",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "contactId",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "label",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "term",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}},
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryPaginationFirstPage()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5507",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5508",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5509",
["entityType"] = "azure_blob_path"
}
            }
                },
                limit = 2,
                orderby = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5513",
["name"] = "ASC"
},
new Dictionary<string, object>
{
["$id"] = "5515",
["updateTime"] = "DESC"
}
            },
                facets = new object[]
            {
new
{
facet = "assetType",
count = 0,
sort = new
{
count = "desc",
},
},
new
{
facet = "classification",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "contactId",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "label",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "term",
count = 10,
sort = new
{
count = "desc",
},
}
            },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryPaginationFirstPage_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5507",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5508",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5509",
["entityType"] = "azure_blob_path"
}
            }
                },
                limit = 2,
                orderby = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5513",
["name"] = "ASC"
},
new Dictionary<string, object>
{
["$id"] = "5515",
["updateTime"] = "DESC"
}
            },
                facets = new object[]
            {
new
{
facet = "assetType",
count = 0,
sort = new
{
count = "desc",
},
},
new
{
facet = "classification",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "contactId",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "label",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "term",
count = 10,
sort = new
{
count = "desc",
},
}
            },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryPaginationFirstPage_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "exampledata",
                Limit = 2,
                Orderby = {BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5513",
["name"] = "ASC"
}), BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5515",
["updateTime"] = "DESC"
})},
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5507",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5508",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5509",
["entityType"] = "azure_blob_path"
}
            }
                }),
                Facets = {new SearchFacetItem
{
Count = 0,
Facet = "assetType",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "classification",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "contactId",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "label",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "term",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}},
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryPaginationFirstPage_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "exampledata",
                Limit = 2,
                Orderby = {BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5513",
["name"] = "ASC"
}), BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5515",
["updateTime"] = "DESC"
})},
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5507",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5508",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5509",
["entityType"] = "azure_blob_path"
}
            }
                }),
                Facets = {new SearchFacetItem
{
Count = 0,
Facet = "assetType",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "classification",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "contactId",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "label",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "term",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}},
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryPaginationLastPage()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5593",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5594",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5595",
["entityType"] = "azure_blob_path"
}
            }
                },
                limit = 2,
                continuationToken = "<token>",
                orderby = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5600",
["name"] = "ASC"
},
new Dictionary<string, object>
{
["$id"] = "5602",
["updateTime"] = "DESC"
}
            },
                facets = new object[]
            {
new
{
facet = "assetType",
count = 0,
sort = new
{
count = "desc",
},
},
new
{
facet = "classification",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "contactId",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "label",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "term",
count = 10,
sort = new
{
count = "desc",
},
}
            },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryPaginationLastPage_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5593",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5594",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5595",
["entityType"] = "azure_blob_path"
}
            }
                },
                limit = 2,
                continuationToken = "<token>",
                orderby = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5600",
["name"] = "ASC"
},
new Dictionary<string, object>
{
["$id"] = "5602",
["updateTime"] = "DESC"
}
            },
                facets = new object[]
            {
new
{
facet = "assetType",
count = 0,
sort = new
{
count = "desc",
},
},
new
{
facet = "classification",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "contactId",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "label",
count = 10,
sort = new
{
count = "desc",
},
},
new
{
facet = "term",
count = 10,
sort = new
{
count = "desc",
},
}
            },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryPaginationLastPage_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "exampledata",
                Limit = 2,
                ContinuationToken = "<token>",
                Orderby = {BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5600",
["name"] = "ASC"
}), BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5602",
["updateTime"] = "DESC"
})},
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5593",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5594",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5595",
["entityType"] = "azure_blob_path"
}
            }
                }),
                Facets = {new SearchFacetItem
{
Count = 0,
Facet = "assetType",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "classification",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "contactId",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "label",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "term",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}},
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryPaginationLastPage_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "exampledata",
                Limit = 2,
                ContinuationToken = "<token>",
                Orderby = {BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5600",
["name"] = "ASC"
}), BinaryData.FromObjectAsJson(new Dictionary<string, object>
{
["$id"] = "5602",
["updateTime"] = "DESC"
})},
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5593",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5594",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5595",
["entityType"] = "azure_blob_path"
}
            }
                }),
                Facets = {new SearchFacetItem
{
Count = 0,
Facet = "assetType",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "classification",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "contactId",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "label",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}, new SearchFacetItem
{
Count = 10,
Facet = "term",
Sort = new SearchFacetSort
{
Count = SearchSortOrder.Descend,
},
}},
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQuerySystemTime()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5679",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5680",
["createTime"] = new Dictionary<string, object>
{
["$id"] = "5681",
["operator"] = "lt",
["timeThreshold"] = 1545580800000L
}
},
new Dictionary<string, object>
{
["$id"] = "5682",
["updateTime"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQuerySystemTime_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5679",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5680",
["createTime"] = new Dictionary<string, object>
{
["$id"] = "5681",
["operator"] = "lt",
["timeThreshold"] = 1545580800000L
}
},
new Dictionary<string, object>
{
["$id"] = "5682",
["updateTime"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQuerySystemTime_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5679",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5680",
["createTime"] = new Dictionary<string, object>
{
["$id"] = "5681",
["operator"] = "lt",
["timeThreshold"] = 1545580800000L
}
},
new Dictionary<string, object>
{
["$id"] = "5682",
["updateTime"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQuerySystemTime_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5679",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5680",
["createTime"] = new Dictionary<string, object>
{
["$id"] = "5681",
["operator"] = "lt",
["timeThreshold"] = 1545580800000L
}
},
new Dictionary<string, object>
{
["$id"] = "5682",
["updateTime"] = "LAST_24H|LAST_7D|LAST_30D|LAST_365D|MORE_THAN_365D"
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryTaxonomy()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5715",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5716",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5717",
["not"] = new Dictionary<string, object>
{
["$id"] = "5718",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "5719",
["attributeName"] = "size",
["operator"] = "eq",
["attributeValue"] = 0
},
new Dictionary<string, object>
{
["$id"] = "5720",
["attributeName"] = "fileSize",
["operator"] = "eq",
["attributeValue"] = 0
}
}
}
},
new Dictionary<string, object>
{
["$id"] = "5721",
["not"] = new Dictionary<string, object>
{
["$id"] = "5722",
["classification"] = "MICROSOFT.SYSTEM.TEMP_FILE"
}
}
            }
                },
                limit = 10,
                taxonomySetting = new
                {
                    assetTypes = new object[]
            {
"Azure Blob Storage"
            },
                    facet = new
                    {
                        count = 10,
                        sort = new
                        {
                            count = "desc",
                        },
                    },
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryTaxonomy_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5715",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5716",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5717",
["not"] = new Dictionary<string, object>
{
["$id"] = "5718",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "5719",
["attributeName"] = "size",
["operator"] = "eq",
["attributeValue"] = 0
},
new Dictionary<string, object>
{
["$id"] = "5720",
["attributeName"] = "fileSize",
["operator"] = "eq",
["attributeValue"] = 0
}
}
}
},
new Dictionary<string, object>
{
["$id"] = "5721",
["not"] = new Dictionary<string, object>
{
["$id"] = "5722",
["classification"] = "MICROSOFT.SYSTEM.TEMP_FILE"
}
}
            }
                },
                limit = 10,
                taxonomySetting = new
                {
                    assetTypes = new object[]
            {
"Azure Blob Storage"
            },
                    facet = new
                    {
                        count = 10,
                        sort = new
                        {
                            count = "desc",
                        },
                    },
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryTaxonomy_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "exampledata",
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5715",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5716",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5717",
["not"] = new Dictionary<string, object>
{
["$id"] = "5718",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "5719",
["attributeName"] = "size",
["operator"] = "eq",
["attributeValue"] = 0
},
new Dictionary<string, object>
{
["$id"] = "5720",
["attributeName"] = "fileSize",
["operator"] = "eq",
["attributeValue"] = 0
}
}
}
},
new Dictionary<string, object>
{
["$id"] = "5721",
["not"] = new Dictionary<string, object>
{
["$id"] = "5722",
["classification"] = "MICROSOFT.SYSTEM.TEMP_FILE"
}
}
            }
                }),
                TaxonomySetting = new SearchTaxonomySetting
                {
                    AssetTypes = { "Azure Blob Storage" },
                    Facet = new SearchFacetItem
                    {
                        Count = 10,
                        Sort = new SearchFacetSort
                        {
                            Count = SearchSortOrder.Descend,
                        },
                    },
                },
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryTaxonomy_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "exampledata",
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5715",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5716",
["objectType"] = "Files"
},
new Dictionary<string, object>
{
["$id"] = "5717",
["not"] = new Dictionary<string, object>
{
["$id"] = "5718",
["or"] = new object[]
{
new Dictionary<string, object>
{
["$id"] = "5719",
["attributeName"] = "size",
["operator"] = "eq",
["attributeValue"] = 0
},
new Dictionary<string, object>
{
["$id"] = "5720",
["attributeName"] = "fileSize",
["operator"] = "eq",
["attributeValue"] = 0
}
}
}
},
new Dictionary<string, object>
{
["$id"] = "5721",
["not"] = new Dictionary<string, object>
{
["$id"] = "5722",
["classification"] = "MICROSOFT.SYSTEM.TEMP_FILE"
}
}
            }
                }),
                TaxonomySetting = new SearchTaxonomySetting
                {
                    AssetTypes = { "Azure Blob Storage" },
                    Facet = new SearchFacetItem
                    {
                        Count = 10,
                        Sort = new SearchFacetSort
                        {
                            Count = SearchSortOrder.Descend,
                        },
                    },
                },
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryTermAssignment()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "<asset name>",
                limit = 3,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5776",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5777",
["term"] = "ExampleTerm"
},
new Dictionary<string, object>
{
["$id"] = "5778",
["term"] = "ExampleTerm",
["glossary"] = "GlossaryName"
},
new Dictionary<string, object>
{
["$id"] = "5779",
["termGuid"] = "<term guid>"
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryTermAssignment_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "<asset name>",
                limit = 3,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5776",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5777",
["term"] = "ExampleTerm"
},
new Dictionary<string, object>
{
["$id"] = "5778",
["term"] = "ExampleTerm",
["glossary"] = "GlossaryName"
},
new Dictionary<string, object>
{
["$id"] = "5779",
["termGuid"] = "<term guid>"
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryTermAssignment_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "<asset name>",
                Limit = 3,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5776",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5777",
["term"] = "ExampleTerm"
},
new Dictionary<string, object>
{
["$id"] = "5778",
["term"] = "ExampleTerm",
["glossary"] = "GlossaryName"
},
new Dictionary<string, object>
{
["$id"] = "5779",
["termGuid"] = "<term guid>"
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryTermAssignment_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Keywords = "<asset name>",
                Limit = 3,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5776",
                    ["or"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5777",
["term"] = "ExampleTerm"
},
new Dictionary<string, object>
{
["$id"] = "5778",
["term"] = "ExampleTerm",
["glossary"] = "GlossaryName"
},
new Dictionary<string, object>
{
["$id"] = "5779",
["termGuid"] = "<term guid>"
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryType()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5812",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5813",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                },
            });
            Response response = client.Query(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryType_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                limit = 10,
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5812",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5813",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                },
            });
            Response response = await client.QueryAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Query_DiscoveryQueryType_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5812",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5813",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                }),
            };
            Response<QueryResult> response = client.Query(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Query_DiscoveryQueryType_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            QueryConfig body = new QueryConfig
            {
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5812",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5813",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                }),
            };
            Response<QueryResult> response = await client.QueryAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Suggest_DiscoverySuggest()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5869",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5870",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                },
                limit = 10,
            });
            Response response = client.Suggest(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Suggest_DiscoverySuggest_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exampledata",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5869",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5870",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                },
                limit = 10,
            });
            Response response = await client.SuggestAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_Suggest_DiscoverySuggest_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            SuggestConfig body = new SuggestConfig
            {
                Keywords = "exampledata",
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5869",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5870",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                }),
            };
            Response<SuggestResult> response = client.Suggest(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_Suggest_DiscoverySuggest_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            SuggestConfig body = new SuggestConfig
            {
                Keywords = "exampledata",
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5869",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5870",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                }),
            };
            Response<SuggestResult> response = await client.SuggestAsync(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_AutoComplete_DiscoveryAutoComplete()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exa",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5924",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5925",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                },
                limit = 10,
            });
            Response response = client.AutoComplete(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_AutoComplete_DiscoveryAutoComplete_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            using RequestContent content = RequestContent.Create(new
            {
                keywords = "exa",
                filter = new Dictionary<string, object>
                {
                    ["$id"] = "5924",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5925",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                },
                limit = 10,
            });
            Response response = await client.AutoCompleteAsync(content);

            JsonElement result = JsonDocument.Parse(response.ContentStream).RootElement;
            Console.WriteLine(result.ToString());
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public void Example_Discovery_AutoComplete_DiscoveryAutoComplete_Convenience()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            AutoCompleteConfig body = new AutoCompleteConfig
            {
                Keywords = "exa",
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5924",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5925",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                }),
            };
            Response<AutoCompleteResult> response = client.AutoComplete(body);
        }

        [Test]
        [Ignore("Only validating compilation of examples")]
        public async Task Example_Discovery_AutoComplete_DiscoveryAutoComplete_Convenience_Async()
        {
            Uri endpoint = new Uri("<endpoint>");
            TokenCredential credential = new DefaultAzureCredential();
            Discovery client = new DataMapClient(endpoint, credential).GetDiscoveryClient(apiVersion: "2023-09-01");

            AutoCompleteConfig body = new AutoCompleteConfig
            {
                Keywords = "exa",
                Limit = 10,
                Filter = BinaryData.FromObjectAsJson(new Dictionary<string, object>
                {
                    ["$id"] = "5924",
                    ["and"] = new object[]
            {
new Dictionary<string, object>
{
["$id"] = "5925",
["entityType"] = "azure_blob_path",
["includeSubTypes"] = false
}
            }
                }),
            };
            Response<AutoCompleteResult> response = await client.AutoCompleteAsync(body);
        }
    }
}
