// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Type Category. </summary>
    public readonly partial struct TypeCategory : IEquatable<TypeCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="TypeCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public TypeCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string PrimitiveValue = "PRIMITIVE";
        private const string ObjectIdTypeValue = "OBJECT_ID_TYPE";
        private const string EnumValue = "ENUM";
        private const string StructValue = "STRUCT";
        private const string ClassificationValue = "CLASSIFICATION";
        private const string EntityValue = "ENTITY";
        private const string ArrayValue = "ARRAY";
        private const string MapValue = "MAP";
        private const string RelationshipValue = "RELATIONSHIP";
        private const string TermTemplateValue = "TERM_TEMPLATE";

        /// <summary> primitive. </summary>
        public static TypeCategory Primitive { get; } = new TypeCategory(PrimitiveValue);
        /// <summary> object id type. </summary>
        public static TypeCategory ObjectIdType { get; } = new TypeCategory(ObjectIdTypeValue);
        /// <summary> enum. </summary>
        public static TypeCategory Enum { get; } = new TypeCategory(EnumValue);
        /// <summary> struct. </summary>
        public static TypeCategory Struct { get; } = new TypeCategory(StructValue);
        /// <summary> classification. </summary>
        public static TypeCategory Classification { get; } = new TypeCategory(ClassificationValue);
        /// <summary> entity. </summary>
        public static TypeCategory Entity { get; } = new TypeCategory(EntityValue);
        /// <summary> array. </summary>
        public static TypeCategory Array { get; } = new TypeCategory(ArrayValue);
        /// <summary> map. </summary>
        public static TypeCategory Map { get; } = new TypeCategory(MapValue);
        /// <summary> relationship. </summary>
        public static TypeCategory Relationship { get; } = new TypeCategory(RelationshipValue);
        /// <summary> term template. </summary>
        public static TypeCategory TermTemplate { get; } = new TypeCategory(TermTemplateValue);
        /// <summary> Determines if two <see cref="TypeCategory"/> values are the same. </summary>
        public static bool operator ==(TypeCategory left, TypeCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="TypeCategory"/> values are not the same. </summary>
        public static bool operator !=(TypeCategory left, TypeCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="TypeCategory"/>. </summary>
        public static implicit operator TypeCategory(string value) => new TypeCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is TypeCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(TypeCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
