// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The payload of suggest request. </summary>
    public partial class SuggestConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SuggestConfig"/>. </summary>
        public SuggestConfig()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SuggestConfig"/>. </summary>
        /// <param name="keywords">
        /// The keywords applied to all fields that support suggest operation. It must be
        /// at least 1 character, and no more than 100 characters. In the index schema we
        /// defined a default suggester which lists all the supported fields and specifies
        /// a search mode.
        /// </param>
        /// <param name="limit">
        /// The number of suggestions we hope to return. The default value is 5. The value
        /// must be a number between 1 and 100.
        /// </param>
        /// <param name="filter"> The filter for the search. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SuggestConfig(string keywords, int? limit, BinaryData filter, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Keywords = keywords;
            Limit = limit;
            Filter = filter;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// The keywords applied to all fields that support suggest operation. It must be
        /// at least 1 character, and no more than 100 characters. In the index schema we
        /// defined a default suggester which lists all the supported fields and specifies
        /// a search mode.
        /// </summary>
        public string Keywords { get; set; }
        /// <summary>
        /// The number of suggestions we hope to return. The default value is 5. The value
        /// must be a number between 1 and 100.
        /// </summary>
        public int? Limit { get; set; }
        /// <summary>
        /// The filter for the search.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData Filter { get; set; }
    }
}
