// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Status for atlas relationship. </summary>
    public readonly partial struct StatusAtlasRelationship : IEquatable<StatusAtlasRelationship>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="StatusAtlasRelationship"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public StatusAtlasRelationship(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "ACTIVE";
        private const string DeletedValue = "DELETED";

        /// <summary> active. </summary>
        public static StatusAtlasRelationship Active { get; } = new StatusAtlasRelationship(ActiveValue);
        /// <summary> deleted. </summary>
        public static StatusAtlasRelationship Deleted { get; } = new StatusAtlasRelationship(DeletedValue);
        /// <summary> Determines if two <see cref="StatusAtlasRelationship"/> values are the same. </summary>
        public static bool operator ==(StatusAtlasRelationship left, StatusAtlasRelationship right) => left.Equals(right);
        /// <summary> Determines if two <see cref="StatusAtlasRelationship"/> values are not the same. </summary>
        public static bool operator !=(StatusAtlasRelationship left, StatusAtlasRelationship right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="StatusAtlasRelationship"/>. </summary>
        public static implicit operator StatusAtlasRelationship(string value) => new StatusAtlasRelationship(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is StatusAtlasRelationship other && Equals(other);
        /// <inheritdoc />
        public bool Equals(StatusAtlasRelationship other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
