// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Taxonomy setting for search request. </summary>
    public partial class SearchTaxonomySetting
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SearchTaxonomySetting"/>. </summary>
        public SearchTaxonomySetting()
        {
            AssetTypes = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SearchTaxonomySetting"/>. </summary>
        /// <param name="assetTypes"> Asset types. </param>
        /// <param name="facet"> The content of a search facet result item. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SearchTaxonomySetting(IList<string> assetTypes, SearchFacetItem facet, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AssetTypes = assetTypes;
            Facet = facet;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Asset types. </summary>
        public IList<string> AssetTypes { get; }
        /// <summary> The content of a search facet result item. </summary>
        public SearchFacetItem Facet { get; set; }
    }
}
