// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Search sort order. </summary>
    public readonly partial struct SearchSortOrder : IEquatable<SearchSortOrder>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SearchSortOrder"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SearchSortOrder(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AscendValue = "asc";
        private const string DescendValue = "desc";

        /// <summary> Use ascending order for sorting. </summary>
        public static SearchSortOrder Ascend { get; } = new SearchSortOrder(AscendValue);
        /// <summary> Use descending order for sorting. </summary>
        public static SearchSortOrder Descend { get; } = new SearchSortOrder(DescendValue);
        /// <summary> Determines if two <see cref="SearchSortOrder"/> values are the same. </summary>
        public static bool operator ==(SearchSortOrder left, SearchSortOrder right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SearchSortOrder"/> values are not the same. </summary>
        public static bool operator !=(SearchSortOrder left, SearchSortOrder right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SearchSortOrder"/>. </summary>
        public static implicit operator SearchSortOrder(string value) => new SearchSortOrder(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SearchSortOrder other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SearchSortOrder other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
