// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary>
    /// A highlight list that consists of index fields id ,qualifiedName, name,
    /// description, entityType. When the keyword appears in those fields, the value of
    /// the field, attached with emphasis mark, is returned as an element of
    /// @search.highlights.
    /// </summary>
    public partial class SearchHighlights
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SearchHighlights"/>. </summary>
        internal SearchHighlights()
        {
            Id = new ChangeTrackingList<string>();
            QualifiedName = new ChangeTrackingList<string>();
            Name = new ChangeTrackingList<string>();
            Description = new ChangeTrackingList<string>();
            EntityType = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="SearchHighlights"/>. </summary>
        /// <param name="id"> Id. </param>
        /// <param name="qualifiedName"> Qualified name. </param>
        /// <param name="name"> Name. </param>
        /// <param name="description"> Description. </param>
        /// <param name="entityType"> Entity type. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SearchHighlights(IReadOnlyList<string> id, IReadOnlyList<string> qualifiedName, IReadOnlyList<string> name, IReadOnlyList<string> description, IReadOnlyList<string> entityType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            QualifiedName = qualifiedName;
            Name = name;
            Description = description;
            EntityType = entityType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Id. </summary>
        public IReadOnlyList<string> Id { get; }
        /// <summary> Qualified name. </summary>
        public IReadOnlyList<string> QualifiedName { get; }
        /// <summary> Name. </summary>
        public IReadOnlyList<string> Name { get; }
        /// <summary> Description. </summary>
        public IReadOnlyList<string> Description { get; }
        /// <summary> Entity type. </summary>
        public IReadOnlyList<string> EntityType { get; }
    }
}
