// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary>
    /// A facet list that consists of index fields assetType ,classification,
    /// contactId, and label. When the facet is specified in the request, the value of
    /// the facet is returned as an element of @search.facets.
    /// </summary>
    public partial class SearchFacetResultValue
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SearchFacetResultValue"/>. </summary>
        internal SearchFacetResultValue()
        {
            EntityType = new ChangeTrackingList<SearchFacetItemValue>();
            AssetType = new ChangeTrackingList<SearchFacetItemValue>();
            Classification = new ChangeTrackingList<SearchFacetItemValue>();
            Term = new ChangeTrackingList<SearchFacetItemValue>();
            ContactId = new ChangeTrackingList<SearchFacetItemValue>();
            ContactType = new ChangeTrackingList<SearchFacetItemValue>();
            Label = new ChangeTrackingList<SearchFacetItemValue>();
            GlossaryType = new ChangeTrackingList<SearchFacetItemValue>();
            TermStatus = new ChangeTrackingList<SearchFacetItemValue>();
            TermTemplate = new ChangeTrackingList<SearchFacetItemValue>();
        }

        /// <summary> Initializes a new instance of <see cref="SearchFacetResultValue"/>. </summary>
        /// <param name="entityType"> Entity type. </param>
        /// <param name="assetType"> Asset type. </param>
        /// <param name="classification"> Classification. </param>
        /// <param name="term"> Term. </param>
        /// <param name="contactId"> Contact id. </param>
        /// <param name="contactType"> Contact type. </param>
        /// <param name="label"> Label. </param>
        /// <param name="glossaryType"> Glossary type. </param>
        /// <param name="termStatus"> Term status. </param>
        /// <param name="termTemplate"> Term template. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SearchFacetResultValue(IReadOnlyList<SearchFacetItemValue> entityType, IReadOnlyList<SearchFacetItemValue> assetType, IReadOnlyList<SearchFacetItemValue> classification, IReadOnlyList<SearchFacetItemValue> term, IReadOnlyList<SearchFacetItemValue> contactId, IReadOnlyList<SearchFacetItemValue> contactType, IReadOnlyList<SearchFacetItemValue> label, IReadOnlyList<SearchFacetItemValue> glossaryType, IReadOnlyList<SearchFacetItemValue> termStatus, IReadOnlyList<SearchFacetItemValue> termTemplate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EntityType = entityType;
            AssetType = assetType;
            Classification = classification;
            Term = term;
            ContactId = contactId;
            ContactType = contactType;
            Label = label;
            GlossaryType = glossaryType;
            TermStatus = termStatus;
            TermTemplate = termTemplate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Entity type. </summary>
        public IReadOnlyList<SearchFacetItemValue> EntityType { get; }
        /// <summary> Asset type. </summary>
        public IReadOnlyList<SearchFacetItemValue> AssetType { get; }
        /// <summary> Classification. </summary>
        public IReadOnlyList<SearchFacetItemValue> Classification { get; }
        /// <summary> Term. </summary>
        public IReadOnlyList<SearchFacetItemValue> Term { get; }
        /// <summary> Contact id. </summary>
        public IReadOnlyList<SearchFacetItemValue> ContactId { get; }
        /// <summary> Contact type. </summary>
        public IReadOnlyList<SearchFacetItemValue> ContactType { get; }
        /// <summary> Label. </summary>
        public IReadOnlyList<SearchFacetItemValue> Label { get; }
        /// <summary> Glossary type. </summary>
        public IReadOnlyList<SearchFacetItemValue> GlossaryType { get; }
        /// <summary> Term status. </summary>
        public IReadOnlyList<SearchFacetItemValue> TermStatus { get; }
        /// <summary> Term template. </summary>
        public IReadOnlyList<SearchFacetItemValue> TermTemplate { get; }
    }
}
