// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text.Json;
using Azure.Core;

namespace Azure.Analytics.Purview.DataMap
{
    public partial class SearchFacetResultValue : IUtf8JsonSerializable, IJsonModel<SearchFacetResultValue>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SearchFacetResultValue>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SearchFacetResultValue>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SearchFacetResultValue>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SearchFacetResultValue)} does not support writing '{format}' format.");
            }

            if (Optional.IsCollectionDefined(EntityType))
            {
                writer.WritePropertyName("entityType"u8);
                writer.WriteStartArray();
                foreach (var item in EntityType)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(AssetType))
            {
                writer.WritePropertyName("assetType"u8);
                writer.WriteStartArray();
                foreach (var item in AssetType)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Classification))
            {
                writer.WritePropertyName("classification"u8);
                writer.WriteStartArray();
                foreach (var item in Classification)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Term))
            {
                writer.WritePropertyName("term"u8);
                writer.WriteStartArray();
                foreach (var item in Term)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ContactId))
            {
                writer.WritePropertyName("contactId"u8);
                writer.WriteStartArray();
                foreach (var item in ContactId)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(ContactType))
            {
                writer.WritePropertyName("contactType"u8);
                writer.WriteStartArray();
                foreach (var item in ContactType)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(Label))
            {
                writer.WritePropertyName("label"u8);
                writer.WriteStartArray();
                foreach (var item in Label)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(GlossaryType))
            {
                writer.WritePropertyName("glossaryType"u8);
                writer.WriteStartArray();
                foreach (var item in GlossaryType)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TermStatus))
            {
                writer.WritePropertyName("termStatus"u8);
                writer.WriteStartArray();
                foreach (var item in TermStatus)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(TermTemplate))
            {
                writer.WritePropertyName("termTemplate"u8);
                writer.WriteStartArray();
                foreach (var item in TermTemplate)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SearchFacetResultValue IJsonModel<SearchFacetResultValue>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SearchFacetResultValue>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SearchFacetResultValue)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSearchFacetResultValue(document.RootElement, options);
        }

        internal static SearchFacetResultValue DeserializeSearchFacetResultValue(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<SearchFacetItemValue> entityType = default;
            IReadOnlyList<SearchFacetItemValue> assetType = default;
            IReadOnlyList<SearchFacetItemValue> classification = default;
            IReadOnlyList<SearchFacetItemValue> term = default;
            IReadOnlyList<SearchFacetItemValue> contactId = default;
            IReadOnlyList<SearchFacetItemValue> contactType = default;
            IReadOnlyList<SearchFacetItemValue> label = default;
            IReadOnlyList<SearchFacetItemValue> glossaryType = default;
            IReadOnlyList<SearchFacetItemValue> termStatus = default;
            IReadOnlyList<SearchFacetItemValue> termTemplate = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("entityType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SearchFacetItemValue> array = new List<SearchFacetItemValue>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchFacetItemValue.DeserializeSearchFacetItemValue(item, options));
                    }
                    entityType = array;
                    continue;
                }
                if (property.NameEquals("assetType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SearchFacetItemValue> array = new List<SearchFacetItemValue>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchFacetItemValue.DeserializeSearchFacetItemValue(item, options));
                    }
                    assetType = array;
                    continue;
                }
                if (property.NameEquals("classification"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SearchFacetItemValue> array = new List<SearchFacetItemValue>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchFacetItemValue.DeserializeSearchFacetItemValue(item, options));
                    }
                    classification = array;
                    continue;
                }
                if (property.NameEquals("term"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SearchFacetItemValue> array = new List<SearchFacetItemValue>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchFacetItemValue.DeserializeSearchFacetItemValue(item, options));
                    }
                    term = array;
                    continue;
                }
                if (property.NameEquals("contactId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SearchFacetItemValue> array = new List<SearchFacetItemValue>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchFacetItemValue.DeserializeSearchFacetItemValue(item, options));
                    }
                    contactId = array;
                    continue;
                }
                if (property.NameEquals("contactType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SearchFacetItemValue> array = new List<SearchFacetItemValue>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchFacetItemValue.DeserializeSearchFacetItemValue(item, options));
                    }
                    contactType = array;
                    continue;
                }
                if (property.NameEquals("label"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SearchFacetItemValue> array = new List<SearchFacetItemValue>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchFacetItemValue.DeserializeSearchFacetItemValue(item, options));
                    }
                    label = array;
                    continue;
                }
                if (property.NameEquals("glossaryType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SearchFacetItemValue> array = new List<SearchFacetItemValue>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchFacetItemValue.DeserializeSearchFacetItemValue(item, options));
                    }
                    glossaryType = array;
                    continue;
                }
                if (property.NameEquals("termStatus"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SearchFacetItemValue> array = new List<SearchFacetItemValue>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchFacetItemValue.DeserializeSearchFacetItemValue(item, options));
                    }
                    termStatus = array;
                    continue;
                }
                if (property.NameEquals("termTemplate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SearchFacetItemValue> array = new List<SearchFacetItemValue>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SearchFacetItemValue.DeserializeSearchFacetItemValue(item, options));
                    }
                    termTemplate = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SearchFacetResultValue(
                entityType ?? new ChangeTrackingList<SearchFacetItemValue>(),
                assetType ?? new ChangeTrackingList<SearchFacetItemValue>(),
                classification ?? new ChangeTrackingList<SearchFacetItemValue>(),
                term ?? new ChangeTrackingList<SearchFacetItemValue>(),
                contactId ?? new ChangeTrackingList<SearchFacetItemValue>(),
                contactType ?? new ChangeTrackingList<SearchFacetItemValue>(),
                label ?? new ChangeTrackingList<SearchFacetItemValue>(),
                glossaryType ?? new ChangeTrackingList<SearchFacetItemValue>(),
                termStatus ?? new ChangeTrackingList<SearchFacetItemValue>(),
                termTemplate ?? new ChangeTrackingList<SearchFacetItemValue>(),
                serializedAdditionalRawData);
        }

        BinaryData IPersistableModel<SearchFacetResultValue>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SearchFacetResultValue>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                default:
                    throw new FormatException($"The model {nameof(SearchFacetResultValue)} does not support writing '{options.Format}' format.");
            }
        }

        SearchFacetResultValue IPersistableModel<SearchFacetResultValue>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SearchFacetResultValue>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSearchFacetResultValue(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SearchFacetResultValue)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SearchFacetResultValue>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";

        /// <summary> Deserializes the model from a raw response. </summary>
        /// <param name="response"> The response to deserialize the model from. </param>
        internal static SearchFacetResultValue FromResponse(Response response)
        {
            using var document = JsonDocument.Parse(response.Content);
            return DeserializeSearchFacetResultValue(document.RootElement);
        }

        /// <summary> Convert into a <see cref="RequestContent"/>. </summary>
        internal virtual RequestContent ToRequestContent()
        {
            var content = new Utf8JsonRequestContent();
            content.JsonWriter.WriteObjectValue(this, ModelSerializationExtensions.WireOptions);
            return content;
        }
    }
}
