// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Relationship Category. </summary>
    public readonly partial struct RelationshipCategory : IEquatable<RelationshipCategory>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RelationshipCategory"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RelationshipCategory(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string AssociationValue = "ASSOCIATION";
        private const string AggregationValue = "AGGREGATION";
        private const string CompositionValue = "COMPOSITION";

        /// <summary> association. </summary>
        public static RelationshipCategory Association { get; } = new RelationshipCategory(AssociationValue);
        /// <summary> aggregation. </summary>
        public static RelationshipCategory Aggregation { get; } = new RelationshipCategory(AggregationValue);
        /// <summary> composition. </summary>
        public static RelationshipCategory Composition { get; } = new RelationshipCategory(CompositionValue);
        /// <summary> Determines if two <see cref="RelationshipCategory"/> values are the same. </summary>
        public static bool operator ==(RelationshipCategory left, RelationshipCategory right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RelationshipCategory"/> values are not the same. </summary>
        public static bool operator !=(RelationshipCategory left, RelationshipCategory right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RelationshipCategory"/>. </summary>
        public static implicit operator RelationshipCategory(string value) => new RelationshipCategory(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RelationshipCategory other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RelationshipCategory other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
