// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The search query of advanced search request. </summary>
    public partial class QueryConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="QueryConfig"/>. </summary>
        public QueryConfig()
        {
            Orderby = new ChangeTrackingList<BinaryData>();
            Facets = new ChangeTrackingList<SearchFacetItem>();
        }

        /// <summary> Initializes a new instance of <see cref="QueryConfig"/>. </summary>
        /// <param name="keywords"> The keywords applied to all searchable fields. </param>
        /// <param name="limit">
        /// The limit of the number of the search result. default value is 50; maximum
        /// value is 1000.
        /// </param>
        /// <param name="continuationToken">
        /// The token used to get next batch of data. Default 'Null' to get the first
        /// batch, and will return new token in each response unless there's no more data.
        /// </param>
        /// <param name="orderby"> The sort order of search results, can specify multiple fields. </param>
        /// <param name="filter"> The filter for the search. See examples for the usage of supported filters. </param>
        /// <param name="facets"> The facets for search. See examples for the usage of supported facets. </param>
        /// <param name="taxonomySetting"> The taxonomy setting for search. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal QueryConfig(string keywords, int? limit, string continuationToken, IList<BinaryData> orderby, BinaryData filter, IList<SearchFacetItem> facets, SearchTaxonomySetting taxonomySetting, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Keywords = keywords;
            Limit = limit;
            ContinuationToken = continuationToken;
            Orderby = orderby;
            Filter = filter;
            Facets = facets;
            TaxonomySetting = taxonomySetting;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The keywords applied to all searchable fields. </summary>
        public string Keywords { get; set; }
        /// <summary>
        /// The limit of the number of the search result. default value is 50; maximum
        /// value is 1000.
        /// </summary>
        public int? Limit { get; set; }
        /// <summary>
        /// The token used to get next batch of data. Default 'Null' to get the first
        /// batch, and will return new token in each response unless there's no more data.
        /// </summary>
        public string ContinuationToken { get; set; }
        /// <summary>
        /// The sort order of search results, can specify multiple fields.
        /// <para>
        /// To assign an object to the element of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public IList<BinaryData> Orderby { get; }
        /// <summary>
        /// The filter for the search. See examples for the usage of supported filters.
        /// <para>
        /// To assign an object to this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        public BinaryData Filter { get; set; }
        /// <summary> The facets for search. See examples for the usage of supported facets. </summary>
        public IList<SearchFacetItem> Facets { get; }
        /// <summary> The taxonomy setting for search. </summary>
        public SearchTaxonomySetting TaxonomySetting { get; set; }
    }
}
