// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The lineage relation with GUID of the from and to entity. </summary>
    public partial class LineageRelation
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LineageRelation"/>. </summary>
        internal LineageRelation()
        {
        }

        /// <summary> Initializes a new instance of <see cref="LineageRelation"/>. </summary>
        /// <param name="fromEntityId"> The GUID of from-entity. </param>
        /// <param name="relationshipId"> The GUID of relationship. </param>
        /// <param name="toEntityId"> The GUID of to-entity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LineageRelation(string fromEntityId, string relationshipId, string toEntityId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FromEntityId = fromEntityId;
            RelationshipId = relationshipId;
            ToEntityId = toEntityId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The GUID of from-entity. </summary>
        public string FromEntityId { get; }
        /// <summary> The GUID of relationship. </summary>
        public string RelationshipId { get; }
        /// <summary> The GUID of to-entity. </summary>
        public string ToEntityId { get; }
    }
}
