// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Lineage direction. </summary>
    public readonly partial struct LineageDirection : IEquatable<LineageDirection>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LineageDirection"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LineageDirection(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InputValue = "INPUT";
        private const string OutputValue = "OUTPUT";
        private const string BothValue = "BOTH";

        /// <summary> input. </summary>
        public static LineageDirection Input { get; } = new LineageDirection(InputValue);
        /// <summary> output. </summary>
        public static LineageDirection Output { get; } = new LineageDirection(OutputValue);
        /// <summary> both. </summary>
        public static LineageDirection Both { get; } = new LineageDirection(BothValue);
        /// <summary> Determines if two <see cref="LineageDirection"/> values are the same. </summary>
        public static bool operator ==(LineageDirection left, LineageDirection right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LineageDirection"/> values are not the same. </summary>
        public static bool operator !=(LineageDirection left, LineageDirection right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LineageDirection"/>. </summary>
        public static implicit operator LineageDirection(string value) => new LineageDirection(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LineageDirection other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LineageDirection other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
