// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Threading;
using System.Threading.Tasks;
using Azure.Core;
using Azure.Core.Pipeline;

namespace Azure.Analytics.Purview.DataMap
{
    // Data plane generated sub-client.
    /// <summary> The Lineage sub-client. </summary>
    public partial class Lineage
    {
        private static readonly string[] AuthorizationScopes = new string[] { "https://purview.azure.net/.default" };
        private readonly TokenCredential _tokenCredential;
        private readonly HttpPipeline _pipeline;
        private readonly Uri _endpoint;
        private readonly string _apiVersion;

        /// <summary> The ClientDiagnostics is used to provide tracing support for the client library. </summary>
        internal ClientDiagnostics ClientDiagnostics { get; }

        /// <summary> The HTTP pipeline for sending and receiving REST requests and responses. </summary>
        public virtual HttpPipeline Pipeline => _pipeline;

        /// <summary> Initializes a new instance of Lineage for mocking. </summary>
        protected Lineage()
        {
        }

        /// <summary> Initializes a new instance of Lineage. </summary>
        /// <param name="clientDiagnostics"> The handler for diagnostic messaging in the client. </param>
        /// <param name="pipeline"> The HTTP pipeline for sending and receiving REST requests and responses. </param>
        /// <param name="tokenCredential"> The token credential to copy. </param>
        /// <param name="endpoint"> The <see cref="Uri"/> to use. </param>
        /// <param name="apiVersion"> The API version to use for this operation. </param>
        internal Lineage(ClientDiagnostics clientDiagnostics, HttpPipeline pipeline, TokenCredential tokenCredential, Uri endpoint, string apiVersion)
        {
            ClientDiagnostics = clientDiagnostics;
            _pipeline = pipeline;
            _tokenCredential = tokenCredential;
            _endpoint = endpoint;
            _apiVersion = apiVersion;
        }

        /// <summary> Get lineage info of the entity specified by GUID. </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetLineageAsync(string,LineageDirection,int?,CancellationToken)']/*" />
        public virtual async Task<Response<AtlasLineageInfo>> GetLineageAsync(string guid, LineageDirection direction, int? depth = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetLineageAsync(guid, direction.ToString(), depth, context).ConfigureAwait(false);
            return Response.FromValue(AtlasLineageInfo.FromResponse(response), response);
        }

        /// <summary> Get lineage info of the entity specified by GUID. </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetLineage(string,LineageDirection,int?,CancellationToken)']/*" />
        public virtual Response<AtlasLineageInfo> GetLineage(string guid, LineageDirection direction, int? depth = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetLineage(guid, direction.ToString(), depth, context);
            return Response.FromValue(AtlasLineageInfo.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Get lineage info of the entity specified by GUID.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLineageAsync(string,LineageDirection,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "INPUT" | "OUTPUT" | "BOTH". </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetLineageAsync(string,string,int?,RequestContext)']/*" />
        public virtual async Task<Response> GetLineageAsync(string guid, string direction, int? depth = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("Lineage.GetLineage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLineageRequest(guid, direction, depth, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Get lineage info of the entity specified by GUID.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetLineage(string,LineageDirection,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "INPUT" | "OUTPUT" | "BOTH". </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetLineage(string,string,int?,RequestContext)']/*" />
        public virtual Response GetLineage(string guid, string direction, int? depth = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("Lineage.GetLineage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetLineageRequest(guid, direction, depth, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary> Return immediate next page lineage info about entity with pagination. </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. </param>
        /// <param name="offset"> The offset for pagination purpose. </param>
        /// <param name="limit"> The page size - by default there is no paging. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetNextPageAsync(string,LineageDirection,int?,int?,CancellationToken)']/*" />
        public virtual async Task<Response<AtlasLineageInfo>> GetNextPageAsync(string guid, LineageDirection direction, int? offset = null, int? limit = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetNextPageAsync(guid, direction.ToString(), offset, limit, context).ConfigureAwait(false);
            return Response.FromValue(AtlasLineageInfo.FromResponse(response), response);
        }

        /// <summary> Return immediate next page lineage info about entity with pagination. </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. </param>
        /// <param name="offset"> The offset for pagination purpose. </param>
        /// <param name="limit"> The page size - by default there is no paging. </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetNextPage(string,LineageDirection,int?,int?,CancellationToken)']/*" />
        public virtual Response<AtlasLineageInfo> GetNextPage(string guid, LineageDirection direction, int? offset = null, int? limit = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetNextPage(guid, direction.ToString(), offset, limit, context);
            return Response.FromValue(AtlasLineageInfo.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Return immediate next page lineage info about entity with pagination
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNextPageAsync(string,LineageDirection,int?,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "INPUT" | "OUTPUT" | "BOTH". </param>
        /// <param name="offset"> The offset for pagination purpose. </param>
        /// <param name="limit"> The page size - by default there is no paging. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetNextPageAsync(string,string,int?,int?,RequestContext)']/*" />
        public virtual async Task<Response> GetNextPageAsync(string guid, string direction, int? offset = null, int? limit = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("Lineage.GetNextPage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNextPageRequest(guid, direction, offset, limit, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Return immediate next page lineage info about entity with pagination
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetNextPage(string,LineageDirection,int?,int?,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="guid"> The globally unique identifier of the entity. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "INPUT" | "OUTPUT" | "BOTH". </param>
        /// <param name="offset"> The offset for pagination purpose. </param>
        /// <param name="limit"> The page size - by default there is no paging. </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="guid"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="guid"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetNextPage(string,string,int?,int?,RequestContext)']/*" />
        public virtual Response GetNextPage(string guid, string direction, int? offset = null, int? limit = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(guid, nameof(guid));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("Lineage.GetNextPage");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetNextPageRequest(guid, direction, offset, limit, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// Return lineage info about entity.
        ///
        /// In addition to the typeName path parameter,
        /// attribute key-value pair(s) can be provided in the following
        /// format
        ///
        /// attr:[attrName]=[attrValue]
        ///
        /// NOTE: The attrName and attrValue should be
        /// unique across entities, eg. qualifiedName.
        ///
        /// The REST request would look
        /// something like this:
        ///
        /// GET
        /// /v2/lineage/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.
        /// </summary>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="attribute">
        /// The qualified name of the entity. (This is only an example. qualifiedName can
        /// be changed to other unique attributes)
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="typeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="typeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetByUniqueAttributeAsync(string,LineageDirection,int?,string,CancellationToken)']/*" />
        public virtual async Task<Response<AtlasLineageInfo>> GetByUniqueAttributeAsync(string typeName, LineageDirection direction, int? depth = null, string attribute = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(typeName, nameof(typeName));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = await GetByUniqueAttributeAsync(typeName, direction.ToString(), depth, attribute, context).ConfigureAwait(false);
            return Response.FromValue(AtlasLineageInfo.FromResponse(response), response);
        }

        /// <summary>
        /// Return lineage info about entity.
        ///
        /// In addition to the typeName path parameter,
        /// attribute key-value pair(s) can be provided in the following
        /// format
        ///
        /// attr:[attrName]=[attrValue]
        ///
        /// NOTE: The attrName and attrValue should be
        /// unique across entities, eg. qualifiedName.
        ///
        /// The REST request would look
        /// something like this:
        ///
        /// GET
        /// /v2/lineage/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.
        /// </summary>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="attribute">
        /// The qualified name of the entity. (This is only an example. qualifiedName can
        /// be changed to other unique attributes)
        /// </param>
        /// <param name="cancellationToken"> The cancellation token to use. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="typeName"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="typeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetByUniqueAttribute(string,LineageDirection,int?,string,CancellationToken)']/*" />
        public virtual Response<AtlasLineageInfo> GetByUniqueAttribute(string typeName, LineageDirection direction, int? depth = null, string attribute = null, CancellationToken cancellationToken = default)
        {
            Argument.AssertNotNullOrEmpty(typeName, nameof(typeName));

            RequestContext context = FromCancellationToken(cancellationToken);
            Response response = GetByUniqueAttribute(typeName, direction.ToString(), depth, attribute, context);
            return Response.FromValue(AtlasLineageInfo.FromResponse(response), response);
        }

        /// <summary>
        /// [Protocol Method] Return lineage info about entity.
        ///
        /// In addition to the typeName path parameter,
        /// attribute key-value pair(s) can be provided in the following
        /// format
        ///
        /// attr:[attrName]=[attrValue]
        ///
        /// NOTE: The attrName and attrValue should be
        /// unique across entities, eg. qualifiedName.
        ///
        /// The REST request would look
        /// something like this:
        ///
        /// GET
        /// /v2/lineage/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetByUniqueAttributeAsync(string,LineageDirection,int?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "INPUT" | "OUTPUT" | "BOTH". </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="attribute">
        /// The qualified name of the entity. (This is only an example. qualifiedName can
        /// be changed to other unique attributes)
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="typeName"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="typeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetByUniqueAttributeAsync(string,string,int?,string,RequestContext)']/*" />
        public virtual async Task<Response> GetByUniqueAttributeAsync(string typeName, string direction, int? depth = null, string attribute = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(typeName, nameof(typeName));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("Lineage.GetByUniqueAttribute");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetByUniqueAttributeRequest(typeName, direction, depth, attribute, context);
                return await _pipeline.ProcessMessageAsync(message, context).ConfigureAwait(false);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        /// <summary>
        /// [Protocol Method] Return lineage info about entity.
        ///
        /// In addition to the typeName path parameter,
        /// attribute key-value pair(s) can be provided in the following
        /// format
        ///
        /// attr:[attrName]=[attrValue]
        ///
        /// NOTE: The attrName and attrValue should be
        /// unique across entities, eg. qualifiedName.
        ///
        /// The REST request would look
        /// something like this:
        ///
        /// GET
        /// /v2/lineage/uniqueAttribute/type/aType?attr:aTypeAttribute=someValue.
        /// <list type="bullet">
        /// <item>
        /// <description>
        /// This <see href="https://github.com/Azure/azure-sdk-for-net/blob/main/sdk/core/Azure.Core/samples/ProtocolMethods.md">protocol method</see> allows explicit creation of the request and processing of the response for advanced scenarios.
        /// </description>
        /// </item>
        /// <item>
        /// <description>
        /// Please try the simpler <see cref="GetByUniqueAttribute(string,LineageDirection,int?,string,CancellationToken)"/> convenience overload with strongly typed models first.
        /// </description>
        /// </item>
        /// </list>
        /// </summary>
        /// <param name="typeName"> The name of the type. </param>
        /// <param name="direction"> The direction of the lineage, which could be INPUT, OUTPUT or BOTH. Allowed values: "INPUT" | "OUTPUT" | "BOTH". </param>
        /// <param name="depth"> The number of hops for lineage. </param>
        /// <param name="attribute">
        /// The qualified name of the entity. (This is only an example. qualifiedName can
        /// be changed to other unique attributes)
        /// </param>
        /// <param name="context"> The request context, which can override default behaviors of the client pipeline on a per-call basis. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="typeName"/> or <paramref name="direction"/> is null. </exception>
        /// <exception cref="ArgumentException"> <paramref name="typeName"/> is an empty string, and was expected to be non-empty. </exception>
        /// <exception cref="RequestFailedException"> Service returned a non-success status code. </exception>
        /// <returns> The response returned from the service. </returns>
        /// <include file="Docs/Lineage.xml" path="doc/members/member[@name='GetByUniqueAttribute(string,string,int?,string,RequestContext)']/*" />
        public virtual Response GetByUniqueAttribute(string typeName, string direction, int? depth = null, string attribute = null, RequestContext context = null)
        {
            Argument.AssertNotNullOrEmpty(typeName, nameof(typeName));
            Argument.AssertNotNull(direction, nameof(direction));

            using var scope = ClientDiagnostics.CreateScope("Lineage.GetByUniqueAttribute");
            scope.Start();
            try
            {
                using HttpMessage message = CreateGetByUniqueAttributeRequest(typeName, direction, depth, attribute, context);
                return _pipeline.ProcessMessage(message, context);
            }
            catch (Exception e)
            {
                scope.Failed(e);
                throw;
            }
        }

        internal HttpMessage CreateGetLineageRequest(string guid, string direction, int? depth, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/datamap/api", false);
            uri.AppendPath("/atlas/v2/lineage/", false);
            uri.AppendPath(guid, true);
            uri.AppendQuery("direction", direction, true);
            if (depth != null)
            {
                uri.AppendQuery("depth", depth.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetNextPageRequest(string guid, string direction, int? offset, int? limit, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/datamap/api", false);
            uri.AppendPath("/lineage/", false);
            uri.AppendPath(guid, true);
            uri.AppendPath("/next/", false);
            uri.AppendQuery("direction", direction, true);
            uri.AppendQuery("api-version", _apiVersion, true);
            if (offset != null)
            {
                uri.AppendQuery("offset", offset.Value, true);
            }
            if (limit != null)
            {
                uri.AppendQuery("limit", limit.Value, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        internal HttpMessage CreateGetByUniqueAttributeRequest(string typeName, string direction, int? depth, string attribute, RequestContext context)
        {
            var message = _pipeline.CreateMessage(context, ResponseClassifier200);
            var request = message.Request;
            request.Method = RequestMethod.Get;
            var uri = new RawRequestUriBuilder();
            uri.Reset(_endpoint);
            uri.AppendRaw("/datamap/api", false);
            uri.AppendPath("/atlas/v2/lineage/uniqueAttribute/type/", false);
            uri.AppendPath(typeName, true);
            uri.AppendQuery("direction", direction, true);
            if (depth != null)
            {
                uri.AppendQuery("depth", depth.Value, true);
            }
            if (attribute != null)
            {
                uri.AppendQuery("attr:qualifiedName", attribute, true);
            }
            request.Uri = uri;
            request.Headers.Add("Accept", "application/json");
            return message;
        }

        private static RequestContext DefaultRequestContext = new RequestContext();
        internal static RequestContext FromCancellationToken(CancellationToken cancellationToken = default)
        {
            if (!cancellationToken.CanBeCanceled)
            {
                return DefaultRequestContext;
            }

            return new RequestContext() { CancellationToken = cancellationToken };
        }

        private static ResponseClassifier _responseClassifier200;
        private static ResponseClassifier ResponseClassifier200 => _responseClassifier200 ??= new StatusCodeClassifier(stackalloc ushort[] { 200 });
    }
}
