// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Status for import. </summary>
    public readonly partial struct ImportStatus : IEquatable<ImportStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ImportStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ImportStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SuccessValue = "SUCCESS";
        private const string FailedValue = "FAILED";

        /// <summary> Success. </summary>
        public static ImportStatus Success { get; } = new ImportStatus(SuccessValue);
        /// <summary> Failed. </summary>
        public static ImportStatus Failed { get; } = new ImportStatus(FailedValue);
        /// <summary> Determines if two <see cref="ImportStatus"/> values are the same. </summary>
        public static bool operator ==(ImportStatus left, ImportStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ImportStatus"/> values are not the same. </summary>
        public static bool operator !=(ImportStatus left, ImportStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ImportStatus"/>. </summary>
        public static implicit operator ImportStatus(string value) => new ImportStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ImportStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ImportStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
