// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Status - can be active or deleted. </summary>
    public readonly partial struct EntityStatus : IEquatable<EntityStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="EntityStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public EntityStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ActiveValue = "ACTIVE";
        private const string DeletedValue = "DELETED";

        /// <summary> The status is active. </summary>
        public static EntityStatus Active { get; } = new EntityStatus(ActiveValue);
        /// <summary> The status is deleted. </summary>
        public static EntityStatus Deleted { get; } = new EntityStatus(DeletedValue);
        /// <summary> Determines if two <see cref="EntityStatus"/> values are the same. </summary>
        public static bool operator ==(EntityStatus left, EntityStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="EntityStatus"/> values are not the same. </summary>
        public static bool operator !=(EntityStatus left, EntityStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="EntityStatus"/>. </summary>
        public static implicit operator EntityStatus(string value) => new EntityStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is EntityStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(EntityStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
