// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using Azure.Core;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Client options for DataMapClient. </summary>
    public partial class DataMapClientOptions : ClientOptions
    {
        private const ServiceVersion LatestVersion = ServiceVersion.V2023_09_01;

        /// <summary> The version of the service to use. </summary>
        public enum ServiceVersion
        {
            /// <summary> Service version "2023-09-01". </summary>
            V2023_09_01 = 1,
        }

        internal string Version { get; }

        /// <summary> Initializes new instance of DataMapClientOptions. </summary>
        public DataMapClientOptions(ServiceVersion version = LatestVersion)
        {
            Version = version switch
            {
                ServiceVersion.V2023_09_01 => "2023-09-01",
                _ => throw new NotSupportedException()
            };
        }
    }
}
