// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The contact in the search and suggest result. </summary>
    public partial class ContactSearchResultValue
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ContactSearchResultValue"/>. </summary>
        internal ContactSearchResultValue()
        {
        }

        /// <summary> Initializes a new instance of <see cref="ContactSearchResultValue"/>. </summary>
        /// <param name="id"> The GUID of the contact. </param>
        /// <param name="info"> The description of the contact. </param>
        /// <param name="contactType">
        /// The type of the contact. It can be Expert or Owner for an entity. It can be
        /// Expert or Steward for a glossary term.
        /// </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ContactSearchResultValue(string id, string info, string contactType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Id = id;
            Info = info;
            ContactType = contactType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The GUID of the contact. </summary>
        public string Id { get; }
        /// <summary> The description of the contact. </summary>
        public string Info { get; }
        /// <summary>
        /// The type of the contact. It can be Expert or Owner for an entity. It can be
        /// Expert or Steward for a glossary term.
        /// </summary>
        public string ContactType { get; }
    }
}
