// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The request payload for classification association. </summary>
    public partial class ClassificationAssociateConfig
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="ClassificationAssociateConfig"/>. </summary>
        public ClassificationAssociateConfig()
        {
            EntityGuids = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="ClassificationAssociateConfig"/>. </summary>
        /// <param name="classification">
        /// An instance of a classification; it doesn't have an identity, this object
        /// exists only when associated with an entity.
        /// </param>
        /// <param name="entityGuids"> The GUID of the entity. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal ClassificationAssociateConfig(AtlasClassification classification, IList<string> entityGuids, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Classification = classification;
            EntityGuids = entityGuids;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary>
        /// An instance of a classification; it doesn't have an identity, this object
        /// exists only when associated with an entity.
        /// </summary>
        public AtlasClassification Classification { get; set; }
        /// <summary> The GUID of the entity. </summary>
        public IList<string> EntityGuids { get; }
    }
}
