// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> Cardinality. </summary>
    public readonly partial struct CardinalityValue : IEquatable<CardinalityValue>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="CardinalityValue"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public CardinalityValue(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string SingleValue = "SINGLE";
        private const string ListValue = "LIST";
        private const string SetValue = "SET";

        /// <summary> single. </summary>
        public static CardinalityValue Single { get; } = new CardinalityValue(SingleValue);
        /// <summary> list. </summary>
        public static CardinalityValue List { get; } = new CardinalityValue(ListValue);
        /// <summary> set. </summary>
        public static CardinalityValue Set { get; } = new CardinalityValue(SetValue);
        /// <summary> Determines if two <see cref="CardinalityValue"/> values are the same. </summary>
        public static bool operator ==(CardinalityValue left, CardinalityValue right) => left.Equals(right);
        /// <summary> Determines if two <see cref="CardinalityValue"/> values are not the same. </summary>
        public static bool operator !=(CardinalityValue left, CardinalityValue right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="CardinalityValue"/>. </summary>
        public static implicit operator CardinalityValue(string value) => new CardinalityValue(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is CardinalityValue other && Equals(other);
        /// <inheritdoc />
        public bool Equals(CardinalityValue other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
