// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The value item of the autocomplete suggest. </summary>
    public partial class AutoCompleteResultValue
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AutoCompleteResultValue"/>. </summary>
        internal AutoCompleteResultValue()
        {
        }

        /// <summary> Initializes a new instance of <see cref="AutoCompleteResultValue"/>. </summary>
        /// <param name="text"> The completed term or phrase. </param>
        /// <param name="queryPlusText"> The completed search query text. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AutoCompleteResultValue(string text, string queryPlusText, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Text = text;
            QueryPlusText = queryPlusText;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The completed term or phrase. </summary>
        public string Text { get; }
        /// <summary> The completed search query text. </summary>
        public string QueryPlusText { get; }
    }
}
