// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.Analytics.Purview.DataMap
{
    /// <summary> The timezone information. </summary>
    public partial class AtlasTimeZone
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="AtlasTimeZone"/>. </summary>
        public AtlasTimeZone()
        {
            AvailableIds = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="AtlasTimeZone"/>. </summary>
        /// <param name="dstSavings"> The value of the daylight saving time. </param>
        /// <param name="id"> The ID of the timezone. </param>
        /// <param name="availableIds"> An array of available IDs. </param>
        /// <param name="default"> The timezone information. </param>
        /// <param name="displayName"> The display name of the timezone. </param>
        /// <param name="rawOffset"> The raw offset of the timezone. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal AtlasTimeZone(int? dstSavings, string id, IList<string> availableIds, AtlasTimeZone @default, string displayName, int? rawOffset, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DstSavings = dstSavings;
            Id = id;
            AvailableIds = availableIds;
            Default = @default;
            DisplayName = displayName;
            RawOffset = rawOffset;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The value of the daylight saving time. </summary>
        public int? DstSavings { get; set; }
        /// <summary> The ID of the timezone. </summary>
        public string Id { get; set; }
        /// <summary> An array of available IDs. </summary>
        public IList<string> AvailableIds { get; }
        /// <summary> The timezone information. </summary>
        public AtlasTimeZone Default { get; set; }
        /// <summary> The display name of the timezone. </summary>
        public string DisplayName { get; set; }
        /// <summary> The raw offset of the timezone. </summary>
        public int? RawOffset { get; set; }
    }
}
